/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.refactoring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.cdt.refactoring.CRefactoringMatch;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class CRefactoringMatchStore {
    private Map fFileToPathMap = new HashMap();
    private Map fPathToMatches = new HashMap();
    private Comparator fOffsetComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((CRefactoringMatch)o1).getOffset() - ((CRefactoringMatch)o2).getOffset();
        }
    };

    public void addMatch(CRefactoringMatch match) {
        IPath path = this.resolvePath(match.getFile());
        if (path != null) {
            Map matchesForPath = this.getMapForPath(path, true);
            matchesForPath.put(match, match);
        }
    }

    private Map getMapForPath(IPath path, boolean create) {
        TreeMap map = (TreeMap)this.fPathToMatches.get(path);
        if (map == null && create) {
            map = new TreeMap(this.fOffsetComparator);
            this.fPathToMatches.put(path, map);
        }
        return map;
    }

    private IPath resolvePath(IFile file) {
        IPath path = (IPath)this.fFileToPathMap.get(file);
        if (path == null) {
            path = file.getLocation();
            if (path == null) {
                path = file.getFullPath();
            }
            this.fFileToPathMap.put(file, path);
        }
        return path;
    }

    public int getFileCount() {
        return this.fFileToPathMap.size();
    }

    public List getFileList() {
        return new ArrayList(this.fFileToPathMap.keySet());
    }

    public boolean contains(IFile file) {
        return this.fFileToPathMap.containsKey(file);
    }

    public Collection getMatchesForFile(IFile file) {
        return this.getMatchesForPath((IPath)this.fFileToPathMap.get(file));
    }

    public Collection getMatchesForPath(IPath path) {
        SortedMap map;
        if (path != null && (map = (SortedMap)this.fPathToMatches.get(path)) != null) {
            return map.keySet();
        }
        return Collections.EMPTY_SET;
    }

    public CRefactoringMatch findMatch(IPath path, int nodeOffset) {
        Map map = (Map)this.fPathToMatches.get(path);
        if (map != null) {
            return (CRefactoringMatch)map.get(new CRefactoringMatch(null, nodeOffset, 0, 0));
        }
        return null;
    }

    public void removePath(IPath path) {
        Map map = (Map)this.fPathToMatches.remove(path);
        if (map != null && !map.isEmpty()) {
            IFile file = ((CRefactoringMatch)map.values().iterator().next()).getFile();
            this.fFileToPathMap.remove(file);
        }
    }

    public Collection findMatchesInRange(Path path, int offset, int end) {
        SortedMap map;
        if (path != null && (map = (SortedMap)this.fPathToMatches.get(path)) != null) {
            return map.subMap(new CRefactoringMatch(null, offset, 0, 0), new CRefactoringMatch(null, end, 0, 0)).keySet();
        }
        return Collections.EMPTY_SET;
    }
}

