/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.core.attributes;

import org.eclipse.ptp.core.attributes.AbstractAttribute;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IAttributeDescription;

public final class DoubleAttribute
extends AbstractAttribute {
    private final Double value;

    public DoubleAttribute(IAttributeDescription description, double value) {
        super(description);
        this.value = value;
    }

    public DoubleAttribute(IAttributeDescription description, String string) throws IAttribute.IllegalValue {
        super(description);
        try {
            this.value = Double.valueOf(string);
        }
        catch (NumberFormatException e) {
            throw new IAttribute.IllegalValue(e);
        }
    }

    public IAttribute create(String string) throws IAttribute.IllegalValue {
        return new DoubleAttribute(this.getDescription(), string);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DoubleAttribute) {
            DoubleAttribute attr = (DoubleAttribute)obj;
            return this.value.equals(attr.value);
        }
        return false;
    }

    public String getStringRep() {
        return this.value.toString();
    }

    public double getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    protected int doCompareTo(AbstractAttribute arg0) {
        DoubleAttribute attr = (DoubleAttribute)arg0;
        return this.value.compareTo(attr.value);
    }
}

