/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.core;

import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.ptp.core.IModelListener;
import org.eclipse.ptp.core.IModelManager;
import org.eclipse.ptp.core.INodeListener;
import org.eclipse.ptp.core.IPJob;
import org.eclipse.ptp.core.IPNode;
import org.eclipse.ptp.core.IPProcess;
import org.eclipse.ptp.core.IPUniverse;
import org.eclipse.ptp.core.IProcessListener;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.events.IModelEvent;
import org.eclipse.ptp.core.events.INodeEvent;
import org.eclipse.ptp.core.events.IProcessEvent;
import org.eclipse.ptp.core.events.ModelErrorEvent;
import org.eclipse.ptp.core.events.ModelRuntimeNotifierEvent;
import org.eclipse.ptp.core.events.ModelSysChangedEvent;
import org.eclipse.ptp.core.events.NodeEvent;
import org.eclipse.ptp.core.events.ProcessEvent;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.internal.core.PJob;
import org.eclipse.ptp.internal.core.PMachine;
import org.eclipse.ptp.internal.core.PNode;
import org.eclipse.ptp.internal.core.PProcess;
import org.eclipse.ptp.internal.core.PUniverse;
import org.eclipse.ptp.internal.core.elementcontrols.IPUniverseControl;
import org.eclipse.ptp.rtsystem.IControlSystem;
import org.eclipse.ptp.rtsystem.IMonitoringSystem;
import org.eclipse.ptp.rtsystem.IRuntimeListener;
import org.eclipse.ptp.rtsystem.IRuntimeProxy;
import org.eclipse.ptp.rtsystem.JobRunConfiguration;
import org.eclipse.ptp.rtsystem.event.IRuntimeErrorEvent;
import org.eclipse.ptp.rtsystem.event.IRuntimeEvent;
import org.eclipse.ptp.rtsystem.event.IRuntimeJobExitedEvent;
import org.eclipse.ptp.rtsystem.event.IRuntimeJobStateChangedEvent;
import org.eclipse.ptp.rtsystem.event.IRuntimeNewJobEvent;
import org.eclipse.ptp.rtsystem.event.IRuntimeNodeGeneralChangedEvent;
import org.eclipse.ptp.rtsystem.event.IRuntimeProcessAttrChangedEvent;
import org.eclipse.ptp.rtsystem.event.IRuntimeProcessOutputEvent;
import org.eclipse.ptp.rtsystem.mpich2.MPICH2ControlSystem;
import org.eclipse.ptp.rtsystem.mpich2.MPICH2MonitoringSystem;
import org.eclipse.ptp.rtsystem.mpich2.MPICH2ProxyRuntimeClient;
import org.eclipse.ptp.rtsystem.ompi.OMPIControlSystem;
import org.eclipse.ptp.rtsystem.ompi.OMPIMonitoringSystem;
import org.eclipse.ptp.rtsystem.ompi.OMPIProxyRuntimeClient;
import org.eclipse.ptp.rtsystem.simulation.SimulationControlSystem;
import org.eclipse.ptp.rtsystem.simulation.SimulationMonitoringSystem;

public class ModelManager
implements IModelManager,
IRuntimeListener {
    private static int MAX_WAIT_DISCOVERY = 10000;
    protected ListenerList modelListeners = new ListenerList();
    protected ListenerList nodeListeners = new ListenerList();
    protected ListenerList processListeners = new ListenerList();
    protected IPJob processRoot = null;
    protected IPUniverseControl universe = null;
    protected ILaunchConfiguration config = null;
    protected IControlSystem controlSystem = null;
    protected IMonitoringSystem monitoringSystem = null;
    protected IRuntimeProxy runtimeProxy = null;
    private int currentControlSystem = -1;
    private int currentMonitoringSystem = -1;
    private final int theMSChoiceID;
    private final int theCSChoiceID;
    private final Lock stateLock;
    private final Lock initializingLock;
    private final Condition notInitializing;
    private boolean initializing = false;
    private boolean initialized = false;
    private final Condition universeNotEmpty;
    private int numMachines = 1;
    private int[] numNodes = new int[]{255};
    private int jobID = 1;

    public void setPTPConfiguration(ILaunchConfiguration config) {
        this.config = config;
    }

    public ILaunchConfiguration getPTPConfiguration() {
        return this.config;
    }

    public ModelManager(int theMSChoiceID, int theCSChoiceID) {
        this.initializingLock = new ReentrantLock();
        this.notInitializing = this.initializingLock.newCondition();
        this.stateLock = new ReentrantLock();
        this.universeNotEmpty = this.stateLock.newCondition();
        this.theMSChoiceID = theMSChoiceID;
        this.theCSChoiceID = theCSChoiceID;
    }

    public ModelManager(int numMachines, int[] numNodes) {
        this(100, 100);
        this.numMachines = numMachines;
        this.numNodes = (int[])numNodes.clone();
    }

    public IControlSystem getControlSystem() {
        return this.controlSystem;
    }

    public int getControlSystemID() {
        return this.currentControlSystem;
    }

    public IMonitoringSystem getMonitoringSystem() {
        return this.monitoringSystem;
    }

    public int getMonitoringSystemID() {
        return this.currentMonitoringSystem;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void refreshRuntimeSystems(IProgressMonitor monitor, boolean force) throws CoreException {
        this.initializingLock.lock();
        try {
            initialized = this.isInitialized();
            System.out.println("XXXXXXXXXXX refreshRuntimeSystems(" + force + "), isInitialized():" + initialized);
            if (!force && initialized) {
                this.initializingLock.unlock();
                return;
            }
            if (true) ** GOTO lbl18
        }
        catch (Throwable var4_5) {
            this.initializingLock.unlock();
            throw var4_5;
        }
        do {
            try {
                this.notInitializing.await();
            }
            catch (InterruptedException v0) {
                Thread.currentThread().interrupt();
            }
lbl18:
            // 3 sources

        } while (this.isInitializing());
        this.setInitializing(true);
        this.initializingLock.unlock();
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        System.out.println("XXXXXXXXXXX refreshRuntimeSystems calling initialize(), force:" + force + ", isInitialized():" + this.initialized);
        preferences = PTPCorePlugin.getDefault().getPluginPreferences();
        MSChoiceID = preferences.getInt("MONITORING_SYSTEM_SELECTION");
        CSChoiceID = preferences.getInt("CONTROL_SYSTEM_SELECTION");
        this.initialize(CSChoiceID, MSChoiceID, monitor);
        this.setInitialized(true);
    }

    private void initialize(int controlSystemID, int monitoringSystemID, IProgressMonitor monitor) throws CoreException {
        try {
            System.err.println("refreshRuntimeSystems");
            this.stateLock.lock();
            try {
                if (this.universe == null) {
                    this.universe = new PUniverse();
                } else {
                    this.universe.removeChildren();
                }
            }
            finally {
                this.stateLock.unlock();
            }
            monitor.beginTask("Refreshing runtime system...", 200);
            this.stateLock.lock();
            try {
                System.out.println("SHUTTING DOWN CONTROL/MONITORING/PROXY systems where appropriate");
                if (this.controlSystem != null) {
                    monitor.subTask("Shutting down control system...");
                    this.controlSystem.removeRuntimeListener(this);
                    this.controlSystem.shutdown();
                    this.controlSystem = null;
                    monitor.worked(10);
                }
                if (this.monitoringSystem != null) {
                    monitor.subTask("Shutting down monitor system...");
                    this.monitoringSystem.removeRuntimeListener(this);
                    this.monitoringSystem.shutdown();
                    this.monitoringSystem = null;
                    monitor.worked(10);
                }
                if (this.runtimeProxy != null) {
                    monitor.subTask("Shutting down runtime proxy...");
                    this.runtimeProxy.shutdown();
                    this.runtimeProxy = null;
                    monitor.worked(10);
                }
                if (monitor.isCanceled()) {
                    throw new CoreException(Status.CANCEL_STATUS);
                }
            }
            finally {
                this.stateLock.unlock();
            }
            monitor.worked(10);
            if (monitoringSystemID == 100 && controlSystemID == 100) {
                monitor.subTask("Initializing Simulation");
                this.initializeSimulation((IProgressMonitor)new SubProgressMonitor(monitor, 10));
            } else if (monitoringSystemID == 105 && controlSystemID == 105) {
                monitor.subTask("Initializing MPICH2");
                this.initializeMPICH2((IProgressMonitor)new SubProgressMonitor(monitor, 10));
            } else {
                monitor.subTask("Initializing OMPI");
                this.initializeORTE((IProgressMonitor)new SubProgressMonitor(monitor, 10));
            }
            this.stateLock.lock();
            try {
                this.currentControlSystem = controlSystemID;
                this.currentMonitoringSystem = monitoringSystemID;
            }
            finally {
                this.stateLock.unlock();
            }
            monitor.subTask("Starting up monitor system...");
            this.monitoringSystem.startup();
            monitor.worked(10);
            monitor.subTask("Starting up control system...");
            this.controlSystem.startup();
            monitor.worked(10);
            monitor.subTask("Setup the monitoring system...");
            this.monitoringSystem.addRuntimeListener(this);
            this.controlSystem.addRuntimeListener(this);
            monitor.worked(1);
            this.setInitializing(false);
            this.monitoringSystem.initiateDiscovery();
            monitor.done();
            monitor.worked(10);
        }
        finally {
            this.setInitializing(false);
            this.fireEvent(new ModelSysChangedEvent(0, null));
            if (!monitor.isCanceled()) {
                monitor.done();
            }
        }
    }

    public final boolean isInitialized() {
        this.initializingLock.lock();
        try {
            boolean bl = this.initialized;
            return bl;
        }
        finally {
            this.initializingLock.unlock();
        }
    }

    protected final void setInitialized(boolean initialized) {
        this.initializingLock.lock();
        try {
            this.initialized = initialized;
        }
        finally {
            this.initializingLock.unlock();
        }
    }

    protected final void waitForPopulatedUniverse(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("Waiting for Universe to Populate", MAX_WAIT_DISCOVERY);
        System.out.println("XXXXXXXXXXXX   Waiting for Universe to Populate");
        this.stateLock.lock();
        try {
            try {
                int count = 1;
                while (this.universe.getMachines().length < 1) {
                    this.universeNotEmpty.await(500L, TimeUnit.MILLISECONDS);
                    monitor.worked(++count * 500);
                    if (!monitor.isCanceled() && count * 500 <= MAX_WAIT_DISCOVERY) continue;
                    throw this.makeCoreException("Universe never became populated", null);
                }
            }
            catch (InterruptedException e) {
                throw this.makeCoreException("Interrupted before Universe populated", e);
            }
        }
        finally {
            this.stateLock.unlock();
            monitor.done();
        }
    }

    private void initializeMPICH2(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Initializing MPICH2 system...", 30);
        try {
            monitor.subTask("Starting MPICH2 proxy runtime...");
            this.runtimeProxy = new MPICH2ProxyRuntimeClient(this);
            monitor.worked(10);
            if (!this.runtimeProxy.startup(monitor)) {
                System.err.println("Failed to start up the proxy runtime.");
                this.runtimeProxy = null;
                if (monitor.isCanceled()) {
                    throw new CoreException(Status.CANCEL_STATUS);
                }
                throw new CoreException((IStatus)new Status(4, PTPCorePlugin.getUniqueIdentifier(), 4, "There was an error starting the MPICH2 proxy runtime.  The path to 'ptp_mpich2_proxy' may have been incorrect. Try checking the console log or error logs for more detailed information.", null));
            }
            monitor.subTask("Starting MPICH2 monitoring system...");
            this.monitoringSystem = new MPICH2MonitoringSystem((MPICH2ProxyRuntimeClient)this.runtimeProxy);
            monitor.worked(10);
            monitor.subTask("Starting MPICH2 control system...");
            this.controlSystem = new MPICH2ControlSystem((MPICH2ProxyRuntimeClient)this.runtimeProxy);
            monitor.worked(10);
        }
        finally {
            monitor.done();
        }
    }

    private void initializeORTE(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Initializing OMPI system...", 30);
        try {
            monitor.subTask("Starting OMPI proxy runtime...");
            this.runtimeProxy = new OMPIProxyRuntimeClient(this);
            monitor.worked(10);
            if (!this.runtimeProxy.startup(monitor)) {
                System.err.println("Failed to start up the proxy runtime.");
                this.runtimeProxy = null;
                if (monitor.isCanceled()) {
                    throw new CoreException(Status.CANCEL_STATUS);
                }
                throw new CoreException((IStatus)new Status(4, PTPCorePlugin.getUniqueIdentifier(), 4, "There was an error starting the OMPI proxy runtime.  The path to 'ptp_orte_proxy' or 'orted' may have been incorrect.  The 'orted' binary MUST be in your PATH to be found by 'ptp_orte_proxy'.  Try checking the console log or error logs for more detailed information.", null));
            }
            monitor.subTask("Starting OMPI monitoring system...");
            this.monitoringSystem = new OMPIMonitoringSystem((OMPIProxyRuntimeClient)this.runtimeProxy);
            monitor.worked(10);
            monitor.subTask("Starting OMPI control system...");
            this.controlSystem = new OMPIControlSystem((OMPIProxyRuntimeClient)this.runtimeProxy);
            monitor.worked(10);
        }
        finally {
            monitor.done();
        }
    }

    private void initializeSimulation(IProgressMonitor monitor) {
        monitor.beginTask("Initializing Simulation system...", 20);
        try {
            monitor.subTask("Starting simulation...");
            Preferences p = PTPCorePlugin.getDefault().getPluginPreferences();
            int numMachines = p.getInt("SIMULATION_NUM_MACHINES");
            if (numMachines < 1) {
                numMachines = 1;
            }
            int[] nodes = new int[numMachines];
            int i = 0;
            while (i < numMachines) {
                int nnodes = p.getInt("SIMULATION_MACHINE_NODE_" + i);
                if (nnodes < 1) {
                    nnodes = 1;
                }
                nodes[i] = nnodes;
                ++i;
            }
            this.monitoringSystem = new SimulationMonitoringSystem(numMachines, nodes);
            monitor.worked(10);
            this.controlSystem = new SimulationControlSystem();
            monitor.worked(10);
            this.runtimeProxy = null;
        }
        finally {
            monitor.done();
        }
    }

    public void performRuntimeEvent(IRuntimeEvent event) {
        if (event instanceof IRuntimeNodeGeneralChangedEvent) {
            IRuntimeNodeGeneralChangedEvent e = (IRuntimeNodeGeneralChangedEvent)event;
            this.runtimeNodeGeneralChange(e.getKeys(), e.getValues());
        } else if (event instanceof IRuntimeProcessOutputEvent) {
            IRuntimeProcessOutputEvent e = (IRuntimeProcessOutputEvent)event;
            this.runtimeProcessOutput(e.getJobID(), e.getOutput());
        } else if (event instanceof IRuntimeJobExitedEvent) {
            IRuntimeJobExitedEvent e = (IRuntimeJobExitedEvent)event;
            this.runtimeJobExited(e.getJobID());
        } else if (event instanceof IRuntimeJobStateChangedEvent) {
            IRuntimeJobStateChangedEvent e = (IRuntimeJobStateChangedEvent)event;
            this.runtimeJobStateChanged(e.getJobID(), e.getState());
        } else if (event instanceof IRuntimeNewJobEvent) {
            IRuntimeNewJobEvent e = (IRuntimeNewJobEvent)event;
            this.runtimeNewJob(e.getJobID());
        } else if (event instanceof IRuntimeProcessAttrChangedEvent) {
            IRuntimeProcessAttrChangedEvent e = (IRuntimeProcessAttrChangedEvent)event;
            this.runtimeProcAttrChange(e.getJobID(), e.getProcesses(), e.getState(), e.getProcArray(), e.getAttributeValues());
        } else if (event instanceof IRuntimeErrorEvent) {
            IRuntimeErrorEvent e = (IRuntimeErrorEvent)event;
            this.fireEvent(new ModelErrorEvent(e.getCode(), e.getMessage()));
            IPJob[] jobs = this.universe.getJobs();
            int i = 0;
            while (i < jobs.length) {
                this.stateLock.lock();
                try {
                    IPProcess[] procs = jobs[i].getProcesses();
                    if (procs != null) {
                        int j = 0;
                        while (j < procs.length) {
                            procs[j].setStatus("error");
                            ++j;
                        }
                    }
                }
                finally {
                    this.stateLock.unlock();
                }
                ++i;
            }
            PTPCorePlugin.errorDialog("Fatal PTP Control System Error", "There was a fatal PTP Control System error (ERROR CODE: " + e.getCode() + ").\n" + "Error message: \"" + e.getMessage() + "\"\n\n" + "System is now disabled.", null);
        }
    }

    public void runtimeNodeGeneralChange(String[] keys, String[] values) {
        boolean newEntity = false;
        PMachine curmachine = null;
        PNode curnode = null;
        boolean one_node_changed = false;
        PNode the_one_changed_node = null;
        this.stateLock.lock();
        try {
            System.out.println("ModelManager.runtimeNodeGeneralName - #keys = " + keys.length + ", #values = " + values.length);
            int i = 0;
            while (i < keys.length) {
                String key = keys[i];
                String value = values[i];
                if (key.equals("Machine ID")) {
                    curmachine = (PMachine)this.universe.findMachineById(value);
                    if (curmachine == null) {
                        System.out.println("\t\tUnknown machine ID (" + value + "), adding to the model.");
                        curmachine = new PMachine(this.universe, "Machine" + value, value);
                        this.universe.addChild(curmachine);
                        newEntity = true;
                        this.universeNotEmpty.signalAll();
                    }
                } else if (curmachine != null && key.equals("Node Number")) {
                    curnode = (PNode)curmachine.findNodeByName("Node" + value);
                    if (curnode == null) {
                        System.out.println("\t\tUnknown node number (" + value + "), adding to the model.");
                        curnode = new PNode(curmachine, "Node" + value, value);
                        curmachine.addChild(curnode);
                        newEntity = true;
                    }
                    if (the_one_changed_node == null) {
                        the_one_changed_node = curnode;
                        one_node_changed = true;
                    } else {
                        one_node_changed = false;
                    }
                } else if (curmachine != null && curnode != null) {
                    curnode.setAttribute(key, value);
                } else {
                    System.err.println("\t!!! ERROR: Received key/value attribute pair but have no associated machine/node to assign it to.");
                }
                ++i;
            }
        }
        finally {
            this.stateLock.unlock();
        }
        if (newEntity) {
            this.fireEvent(new ModelSysChangedEvent(2, null));
        }
        if (one_node_changed && the_one_changed_node != null) {
            this.fireEvent(new NodeEvent(the_one_changed_node, 0, null));
        } else {
            this.fireEvent(new ModelSysChangedEvent(1, null));
        }
    }

    public void runtimeProcessOutput(String ne, String output) {
        ProcessEvent event = null;
        this.stateLock.lock();
        try {
            IPProcess p = this.universe.findProcessByName(ne);
            if (p != null) {
                p.addOutput(output);
                event = new ProcessEvent(p, 3, String.valueOf(output) + "\n");
            }
        }
        finally {
            this.stateLock.unlock();
        }
        if (event != null) {
            this.fireEvent(event);
        }
    }

    public void runtimeJobExited(String ne) {
    }

    public void runtimeJobStateChanged(String nejob, String state) {
        IPJob job;
        this.stateLock.lock();
        try {
            System.out.println("*********** JOB STATE CHANGE: " + state + " (job = " + nejob + ")");
            job = this.universe.findJobByName(nejob);
        }
        finally {
            this.stateLock.unlock();
        }
        if (job != null) {
            ArrayList<ProcessEvent> processEvents = new ArrayList<ProcessEvent>();
            this.stateLock.lock();
            try {
                IPProcess[] iPProcessArray = job.getProcesses();
                if (iPProcessArray != null) {
                    int i = 0;
                    while (i < iPProcessArray.length) {
                        iPProcessArray[i].setStatus(state);
                        processEvents.add(new ProcessEvent(iPProcessArray[i], 0, iPProcessArray[i].getStatus()));
                        ++i;
                    }
                }
            }
            finally {
                this.stateLock.unlock();
            }
            for (IProcessEvent iProcessEvent : processEvents) {
                this.fireEvent(iProcessEvent);
            }
            if (state.equals("running")) {
                this.fireEvent(new ModelRuntimeNotifierEvent(job.getIDString(), 0, 0));
            } else if (state.equals("exited")) {
                this.fireEvent(new ModelRuntimeNotifierEvent(job.getIDString(), 0, 3));
            } else if (state.equals("starting")) {
                this.fireEvent(new ModelRuntimeNotifierEvent(job.getIDString(), 0, 1));
            }
        }
    }

    public void runtimeNewJob(String ne) {
    }

    public void runtimeProcAttrChange(String nejob, BitList cprocs, String kv, int[] dprocs, String[] kvs) {
        this.stateLock.lock();
        try {
            System.out.println("*********** PROC ATTRIBUTE CHANGE: (job = " + nejob + ")");
            IPJob job = this.universe.findJobByName(nejob);
            if (job != null) {
                int i = 0;
                while (i < dprocs.length) {
                    IPProcess proc = job.findProcessByName(String.valueOf(nejob) + "_process" + dprocs[i]);
                    String[] attr = kvs[i].split("=");
                    if (attr.length == 2 && proc != null) {
                        if (attr[0].equals("ATTRIB_PROCESS_PID")) {
                            System.err.println("setting pid[" + proc.getName() + "]=" + attr[1]);
                            proc.setPid(attr[1]);
                        } else if (attr[0].equals("ATTRIB_PROCESS_NODE_NAME")) {
                            if (attr[1].equals("localhost")) {
                                String nodeName0 = "Node0";
                                IPNode node = this.universe.getMachines()[0].findNodeByName(nodeName0);
                                proc.setNode(node);
                            } else {
                                IPNode[] nodes = this.universe.getMachines()[0].getNodes();
                                int j = 0;
                                while (j < nodes.length) {
                                    IPNode node = nodes[j];
                                    Object nodeName = node.getAttribute("Node Name");
                                    if (nodeName.equals(attr[1])) {
                                        System.err.println("setting node[" + proc.getName() + "]=" + attr[1] + "(" + node.getNodeNumber() + ")");
                                        proc.setNode(node);
                                        break;
                                    }
                                    ++j;
                                }
                            }
                        }
                    }
                    ++i;
                }
            }
        }
        finally {
            this.stateLock.unlock();
        }
    }

    public void shutdown() {
        this.stateLock.lock();
        try {
            this.modelListeners.clear();
            this.modelListeners = null;
            if (this.monitoringSystem != null) {
                this.monitoringSystem.shutdown();
            }
            if (this.controlSystem != null) {
                this.controlSystem.shutdown();
            }
            if (this.runtimeProxy != null) {
                this.runtimeProxy.shutdown();
            }
            this.currentControlSystem = -1;
            this.currentMonitoringSystem = -1;
            this.universe = null;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    public void addNodeListener(INodeListener listener) {
        this.nodeListeners.add((Object)listener);
    }

    public void removeNodeListener(INodeListener listener) {
        this.nodeListeners.remove((Object)listener);
    }

    public void addProcessListener(IProcessListener listener) {
        this.processListeners.add((Object)listener);
    }

    public void removeProcessListener(IProcessListener listener) {
        this.processListeners.remove((Object)listener);
    }

    public void addModelListener(IModelListener listener) {
        this.modelListeners.add((Object)listener);
    }

    public void removeModelListener(IModelListener listener) {
        this.modelListeners.remove((Object)listener);
    }

    public void fireEvent(final IProcessEvent event) {
        Object[] array = this.processListeners.getListeners();
        int i = 0;
        while (i < array.length) {
            final IProcessListener l = (IProcessListener)array[i];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.processEvent(event);
                }
            });
            ++i;
        }
    }

    public void fireEvent(final INodeEvent event) {
        Object[] array = this.nodeListeners.getListeners();
        int i = 0;
        while (i < array.length) {
            final INodeListener l = (INodeListener)array[i];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.nodeEvent(event);
                }
            });
            ++i;
        }
    }

    public void fireEvent(final IModelEvent event) {
        Object[] array = this.modelListeners.getListeners();
        int i = 0;
        while (i < array.length) {
            final IModelListener l = (IModelListener)array[i];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.modelEvent(event);
                }
            });
            ++i;
        }
    }

    public void abortJob(String jobName) throws CoreException {
        IPJob j;
        this.stateLock.lock();
        try {
            j = this.universe.findJobByName(jobName);
            if (j == null) {
                System.err.println("ERROR: tried to delete a job that was not found '" + jobName + "'");
                return;
            }
        }
        finally {
            this.stateLock.unlock();
        }
        try {
            this.controlSystem.terminateJob(j);
        }
        catch (CoreException coreException) {
            PTPCorePlugin.errorDialog("Fatal PTP Control System Error", "The PTP Control System is down.", null);
            return;
        }
        System.err.println("aborted");
        this.fireEvent(new ModelRuntimeNotifierEvent(j.getIDString(), 0, 2));
    }

    public IPJob run(ILaunch launch, JobRunConfiguration jobRunConfig, IProgressMonitor monitor) throws CoreException {
        monitor.setTaskName("Creating the job...");
        monitor.beginTask("Creating the job...", 200);
        try {
            this.waitForPopulatedUniverse((IProgressMonitor)new SubProgressMonitor(monitor, 100));
            if (monitor.isCanceled()) {
                return null;
            }
            if (this.controlSystem == null || !this.controlSystem.isHealthy()) {
                throw this.makeCoreException("Control System is dead.", null);
            }
            IPJob job = this.newJob(jobRunConfig.getNumberOfProcesses(), jobRunConfig.isDebug(), monitor);
            System.out.println("ModelManager.run() - new JobID = " + job.getJobNumberInt());
            this.controlSystem.run(job.getJobNumberInt(), jobRunConfig);
            monitor.worked(100);
            IPJob iPJob = job;
            return iPJob;
        }
        finally {
            monitor.done();
        }
    }

    protected void clearUsedMemory() {
        long wasFree;
        System.out.println("********** clearUsedMemory");
        Runtime rt = Runtime.getRuntime();
        long isFree = rt.freeMemory();
        do {
            wasFree = isFree;
            rt.gc();
        } while ((isFree = rt.freeMemory()) > wasFree);
        rt.runFinalization();
    }

    /*
     * Exception decompiling
     */
    public IPUniverse getUniverse() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int newJobID() {
        this.stateLock.lock();
        try {
            int n = this.jobID++;
            return n;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    private IPJob newJob(int numProcesses, boolean debug, IProgressMonitor monitor) throws CoreException {
        PJob job;
        this.stateLock.lock();
        try {
            int jobID = this.newJobID();
            String jobName = "job" + jobID;
            String jobOwner = "";
            System.out.println("MODEL MANAGER: newJob(" + jobID + ")");
            job = new PJob(this.universe, jobName, "" + (10000 + jobID), jobID);
            if (debug) {
                job.setDebug();
            }
            this.universe.addChild(job);
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask("", numProcesses);
            monitor.setTaskName("Creating processes....");
            IPNode[] nodes = this.universe.getMachines()[0].getNodes();
            if (nodes.length > 0) {
                jobOwner = (String)nodes[0].getAttribute("User Owner");
            }
            PProcess.deleteOutputFiles(jobName, jobOwner);
            int i = 0;
            while (i < numProcesses) {
                PProcess proc = new PProcess(job, jobOwner, String.valueOf(jobName) + "_process" + i, "" + i, "0", i, "starting", "", "");
                job.addChild(proc);
                ++i;
            }
        }
        finally {
            this.stateLock.unlock();
        }
        if (debug) {
            this.fireEvent(new ModelRuntimeNotifierEvent(job.getIDString(), 0, 1));
        }
        return job;
    }

    protected final boolean isUniversePopulated() {
        this.stateLock.lock();
        try {
            boolean bl = this.universe != null && this.universe.getMachines().length > 0;
            return bl;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    protected CoreException makeCoreException(String string, Throwable e) {
        Status status = new Status(4, PTPCorePlugin.getUniqueIdentifier(), 4, string, e);
        return new CoreException((IStatus)status);
    }

    private final boolean isInitializing() {
        return this.initializing;
    }

    private final void setInitializing(boolean initializing) {
        this.initializingLock.lock();
        try {
            this.initializing = initializing;
            if (!initializing) {
                this.notInitializing.signalAll();
            }
        }
        finally {
            this.initializingLock.unlock();
        }
    }
}

