/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.core;

import java.util.ArrayList;
import org.eclipse.ptp.core.IPJob;
import org.eclipse.ptp.core.IPMachine;
import org.eclipse.ptp.core.IPProcess;
import org.eclipse.ptp.internal.core.Parent;
import org.eclipse.ptp.internal.core.elementcontrols.IPElementControl;
import org.eclipse.ptp.internal.core.elementcontrols.IPMachineControl;
import org.eclipse.ptp.internal.core.elementcontrols.IPNodeControl;
import org.eclipse.ptp.internal.core.elementcontrols.IPProcessControl;

public class PNode
extends Parent
implements IPNodeControl {
    protected String NAME_TAG = "node ";

    public PNode(IPElementControl mac, String name, String key) {
        super(mac, name, key, 12);
        this.setAttribute("Node Number", new Integer(key));
    }

    public IPMachine getMachine() {
        IPElementControl current = this;
        do {
            if (!(current instanceof IPMachineControl)) continue;
            return (IPMachineControl)current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    public String getNodeNumber() {
        return "" + (Integer)this.getAttribute("Node Number");
    }

    public int getNodeNumberInt() {
        return (Integer)this.getAttribute("Node Number");
    }

    public IPProcess[] getProcesses() {
        return this.getCollection().toArray(new IPProcessControl[this.size()]);
    }

    public IPProcess[] getSortedProcesses() {
        IPElementControl[] processes = (IPProcessControl[])this.getProcesses();
        this.sort(processes);
        return processes;
    }

    public IPProcess findProcess(String processNumber) {
        IPElementControl element = this.findChild(processNumber);
        if (element != null) {
            return (IPProcessControl)element;
        }
        return null;
    }

    public IPJob[] getJobs() {
        IPProcess[] processes = this.getProcesses();
        ArrayList<IPJob> array = new ArrayList<IPJob>(0);
        int i = 0;
        while (i < processes.length) {
            IPJob job = processes[i].getJob();
            if (job != null && !array.contains(job)) {
                array.add(job);
            }
            ++i;
        }
        return array.toArray(new IPJob[array.size()]);
    }

    public Object getAttribute(String key) {
        return this.getAttribute(3, key);
    }

    public void setAttribute(String key, Object o) {
        this.setAttribute(3, key, o);
    }

    public String[] getAttributeKeys() {
        return this.getAttributeKeys(3);
    }

    public String getName() {
        return this.getElementName();
    }

    public int getNumProcesses() {
        return this.size();
    }

    public boolean hasChildProcesses() {
        return this.getNumProcesses() > 0;
    }
}

