/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rmsystem;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.rmsystem.IResourceManager;
import org.eclipse.ptp.rmsystem.IResourceManagerConfiguration;
import org.eclipse.ptp.rmsystem.IResourceManagerFactory;
import org.eclipse.ptp.rmsystem.ResourceManagerStatus;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class ResourceManagerPersistence {
    private static final String TAG_CURRENT_RESOURCEMANAGER = "CurrentResourceManager";
    private static final String TAG_RESOURCEMANAGER_INDEX = "ResourceManagerIndex";
    private static final String TAG_RESOURCEMANAGERS = "ResourceManagers";
    private static final String TAG_RESOURCEMANGER = "ResourceManager";
    private static final String TAG_RESOURCEMANGER_CONFIGURATION = "Configuration";
    private static final String TAG_RESOURCEMANGER_ID = "ResourceManagerId";
    private static final String TAG_RESOURCEMANGER_RUNNING = "IsRunning";
    private IResourceManager[] resourceManagers = new IResourceManager[0];
    private IResourceManager savedCurrentResourceManager;

    public static void saveResourceManagers(File file, IResourceManager[] resourceManagers, IResourceManager currentResourceManager) {
        System.out.println("In saveResourceManagers");
        XMLMemento memento = XMLMemento.createWriteRoot((String)TAG_RESOURCEMANAGERS);
        ResourceManagerPersistence.saveResourceManagers(memento, resourceManagers, currentResourceManager);
        FileWriter writer = null;
        try {
            try {
                writer = new FileWriter(file);
                memento.save((Writer)writer);
            }
            catch (IOException e) {
                PTPCorePlugin.log(e);
            }
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                PTPCorePlugin.log(e);
            }
        }
        System.out.println("Leaving saveResourceManagers");
    }

    private static void saveResourceManagers(XMLMemento memento, IResourceManager[] resourceManagers, IResourceManager currentResourceManager) {
        int currentResourceManagerIndex = -1;
        int i = 0;
        while (i < resourceManagers.length) {
            if (currentResourceManager == resourceManagers[i]) {
                currentResourceManagerIndex = i;
            }
            IMemento child = memento.createChild(TAG_RESOURCEMANGER);
            child.putString(TAG_RESOURCEMANGER_ID, resourceManagers[i].getConfiguration().getResourceManagerId());
            child.putInteger(TAG_RESOURCEMANAGER_INDEX, i);
            boolean isRunning = resourceManagers[i].getStatus().equals(ResourceManagerStatus.STARTED);
            child.putString(TAG_RESOURCEMANGER_RUNNING, isRunning ? "true" : "false");
            IMemento grandchild = child.createChild(TAG_RESOURCEMANGER_CONFIGURATION);
            resourceManagers[i].getConfiguration().save(grandchild);
            ++i;
        }
        memento.putInteger(TAG_CURRENT_RESOURCEMANAGER, currentResourceManagerIndex);
    }

    public IResourceManager[] getResourceManagers() {
        return this.resourceManagers;
    }

    public IResourceManager getSavedCurrentResourceManager() {
        return this.savedCurrentResourceManager;
    }

    public void loadResourceManagers(File file, IResourceManagerFactory[] factories) {
        FileReader reader = null;
        try {
            try {
                reader = new FileReader(file);
                this.loadResourceManagers(XMLMemento.createReadRoot((Reader)reader), factories);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (Exception e) {
                PTPCorePlugin.log(e);
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                PTPCorePlugin.log(e);
            }
        }
    }

    private IResourceManagerFactory getResourceManagerFactory(IResourceManagerFactory[] factories, String id) {
        int i = 0;
        while (i < factories.length) {
            if (factories[i].getId().equals(id)) {
                return factories[i];
            }
            ++i;
        }
        return null;
    }

    private void loadResourceManagers(XMLMemento memento, IResourceManagerFactory[] factories) {
        IMemento[] children = memento.getChildren(TAG_RESOURCEMANGER);
        IResourceManager[] tmpRMs = new IResourceManager[children.length];
        ArrayList<IResourceManager> rms = new ArrayList<IResourceManager>(tmpRMs.length);
        int i = 0;
        while (i < children.length) {
            IMemento grandchild;
            IResourceManagerConfiguration configuration;
            String resourceManagerId = children[i].getString(TAG_RESOURCEMANGER_ID);
            int index = children[i].getInteger(TAG_RESOURCEMANAGER_INDEX);
            String isRunningRep = children[i].getString(TAG_RESOURCEMANGER_RUNNING);
            boolean isRunning = "true".equalsIgnoreCase(isRunningRep);
            IResourceManagerFactory factory = this.getResourceManagerFactory(factories, resourceManagerId);
            if (factory != null && (configuration = factory.loadConfiguration(grandchild = children[i].getChild(TAG_RESOURCEMANGER_CONFIGURATION))) != null) {
                tmpRMs[index] = factory.create(configuration);
                if (tmpRMs[index] != null) {
                    if (isRunning) {
                        try {
                            tmpRMs[index].start();
                        }
                        catch (CoreException e) {
                            PTPCorePlugin.log(e);
                        }
                    }
                    rms.add(tmpRMs[index]);
                }
            }
            ++i;
        }
        int savedCurrentRMIndex = memento.getInteger(TAG_CURRENT_RESOURCEMANAGER);
        if (savedCurrentRMIndex >= 0) {
            this.setSavedCurrentResourceManager(tmpRMs[savedCurrentRMIndex]);
        }
        this.resourceManagers = rms.toArray(new IResourceManager[rms.size()]);
    }

    private void setSavedCurrentResourceManager(IResourceManager manager) {
        this.savedCurrentResourceManager = manager;
    }
}

