/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rmsystem;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.ptp.core.IModelPresentation;
import org.eclipse.ptp.rmsystem.IResourceManager;
import org.eclipse.ptp.rmsystem.IResourceManagerConfiguration;
import org.eclipse.ptp.rmsystem.IResourceManagerListener;
import org.eclipse.ptp.rmsystem.ResourceManagerStatus;
import org.eclipse.ptp.rtsystem.IControlSystem;

public abstract class AbstractResourceManager
extends PlatformObject
implements IResourceManager {
    private final ListenerList listeners = new ListenerList();
    private final IResourceManagerConfiguration config;
    private ResourceManagerStatus status;

    public AbstractResourceManager(IResourceManagerConfiguration config) {
        this.config = config;
        this.status = ResourceManagerStatus.INIT;
    }

    public void addResourceManagerListener(IResourceManagerListener listener) {
        this.listeners.add((Object)listener);
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isInstance(this)) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public IResourceManagerConfiguration getConfiguration() {
        return this.config;
    }

    public abstract IControlSystem getControlSystem();

    public String getDescription() {
        return this.config.getDescription();
    }

    public abstract IModelPresentation getModelPresentation();

    public String getName() {
        return this.config.getName();
    }

    public ResourceManagerStatus getStatus() {
        return this.status;
    }

    public void removeResourceManagerListener(IResourceManagerListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void start() throws CoreException {
        if (!this.status.equals(ResourceManagerStatus.STARTED) && !this.status.equals(ResourceManagerStatus.ERROR)) {
            this.doStart();
            this.fireStarted();
        }
    }

    public void stop() throws CoreException {
        if (this.status.equals(ResourceManagerStatus.STARTED)) {
            this.doStop();
            this.fireStopped();
        }
    }

    private void fireStarted() {
        Object[] tmpListeners = this.listeners.getListeners();
        int i = 0;
        int n = tmpListeners.length;
        while (i < n) {
            final IResourceManagerListener listener = (IResourceManagerListener)tmpListeners[i];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    listener.handleStarted(AbstractResourceManager.this);
                }
            });
            ++i;
        }
    }

    private void fireStatusChanged(final ResourceManagerStatus oldStatus) {
        Object[] tmpListeners = this.listeners.getListeners();
        int i = 0;
        int n = tmpListeners.length;
        while (i < n) {
            final IResourceManagerListener listener = (IResourceManagerListener)tmpListeners[i];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    listener.handleStatusChanged(oldStatus, AbstractResourceManager.this);
                }
            });
            ++i;
        }
    }

    private void fireStopped() {
        Object[] tmpListeners = this.listeners.getListeners();
        int i = 0;
        int n = tmpListeners.length;
        while (i < n) {
            final IResourceManagerListener listener = (IResourceManagerListener)tmpListeners[i];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    listener.handleStopped(AbstractResourceManager.this);
                }
            });
            ++i;
        }
    }

    protected abstract void doStart() throws CoreException;

    protected abstract void doStop() throws CoreException;

    protected void setStatus(ResourceManagerStatus status, boolean fireEvent) {
        ResourceManagerStatus oldStatus = this.status;
        this.status = status;
        if (fireEvent) {
            this.fireStatusChanged(oldStatus);
        }
    }
}

