/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.core.aif;

import org.eclipse.ptp.debug.core.aif.AIFFactory;
import org.eclipse.ptp.debug.core.aif.IAIF;
import org.eclipse.ptp.debug.core.aif.IAIFType;
import org.eclipse.ptp.debug.core.aif.IAIFValue;

public class AIF
implements IAIF {
    private IAIFType aifType;
    private IAIFValue aifValue;
    private String typeDesc = "";

    public AIF(IAIFType aifType, IAIFValue aifValue) {
        this.aifType = aifType;
        this.aifValue = aifValue;
    }

    public AIF(String fds, byte[] data) {
        this.aifType = AIFFactory.getAIFType(fds);
        this.aifValue = AIFFactory.getAIFValue(null, this.aifType, data);
    }

    public AIF(String fds, byte[] data, String desc) {
        this(fds, data);
        this.typeDesc = desc;
    }

    public IAIFType getType() {
        return this.aifType;
    }

    public IAIFValue getValue() {
        return this.aifValue;
    }

    protected void setType(IAIFType t) {
        this.aifType = t;
    }

    protected void setValue(IAIFValue v) {
        this.aifValue = v;
    }

    public String getDescription() {
        return this.typeDesc;
    }

    public String toString() {
        try {
            return "<" + this.aifType.toString() + "," + this.aifValue.toString() + ">";
        }
        catch (Exception e) {
            return "err: " + e.getMessage();
        }
    }
}

