/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.aif;

import java.math.BigInteger;
import org.eclipse.ptp.debug.core.aif.AIFException;
import org.eclipse.ptp.debug.core.aif.AIFFactory;
import org.eclipse.ptp.debug.core.aif.IAIFTypeAddress;
import org.eclipse.ptp.debug.core.aif.IAIFValueAddress;
import org.eclipse.ptp.debug.internal.core.aif.AIFValue;
import org.eclipse.ptp.debug.internal.core.aif.ValueIntegral;

public class AIFValueAddress
extends AIFValue
implements IAIFValueAddress {
    String addr = "";

    public AIFValueAddress(IAIFTypeAddress type, AIFFactory.SimpleByteBuffer buffer) {
        super(type);
        this.parse(buffer);
    }

    protected void parse(AIFFactory.SimpleByteBuffer buffer) {
        this.size = this.type.sizeof();
        int i = 0;
        while (i < this.size) {
            this.addr = String.valueOf(this.addr) + Integer.toHexString(256 + (buffer.get() & 0xFF)).substring(1);
            ++i;
        }
    }

    public String getValueString() throws AIFException {
        if (this.result == null) {
            this.result = "0x" + this.addr;
        }
        return this.result;
    }

    public BigInteger getAddress() throws AIFException {
        return ValueIntegral.bigIntegerValue(this.getValueString());
    }
}

