/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.sourcelookup;

import java.io.File;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupParticipant;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.ptp.debug.core.model.IPStackFrame;
import org.eclipse.ptp.debug.core.sourcelookup.ISourceLookupChangeListener;
import org.eclipse.ptp.debug.internal.core.ListenerList;

public class PSourceLookupParticipant
extends AbstractSourceLookupParticipant {
    private static final NoSourceElement gfNoSource = new NoSourceElement();
    private ListenerList fListeners = new ListenerList(1);

    public String getSourceName(Object object) throws CoreException {
        IPStackFrame frame;
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof IAdaptable && (frame = (IPStackFrame)((IAdaptable)object).getAdapter(IPStackFrame.class)) != null) {
            String name = frame.getFile();
            return name != null && name.trim().length() > 0 ? name : null;
        }
        return null;
    }

    public Object[] findSourceElements(Object object) throws CoreException {
        File file;
        String name = null;
        if (object instanceof IAdaptable) {
            IPStackFrame frame = (IPStackFrame)((IAdaptable)object).getAdapter(IPStackFrame.class);
            if (frame != null && ((name = frame.getFile().trim()) == null || name.length() == 0)) {
                return new Object[]{gfNoSource};
            }
        } else if (object instanceof String) {
            name = (String)object;
        }
        if (name != null && (file = new File(name)).isAbsolute() && file.exists()) {
            return this.findSourceElementByFile(file);
        }
        return super.findSourceElements(object);
    }

    private Object[] findSourceElementByFile(File file) {
        Object[] wfiles = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)new Path(file.getPath()));
        if (wfiles.length > 0) {
            return wfiles;
        }
        return new LocalFileStorage[]{new LocalFileStorage(file)};
    }

    public void dispose() {
        this.fListeners.removeAll();
        super.dispose();
    }

    public void addSourceLookupChangeListener(ISourceLookupChangeListener listener) {
        this.fListeners.add(listener);
    }

    public void removeSourceLookupChangeListener(ISourceLookupChangeListener listener) {
        this.fListeners.remove(listener);
    }

    public void sourceContainersChanged(ISourceLookupDirector director) {
        Object[] listeners = this.fListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ISourceLookupChangeListener)listeners[i]).sourceContainersChanged(director);
            ++i;
        }
        super.sourceContainersChanged(director);
    }

    private static class NoSourceElement {
        private NoSourceElement() {
        }
    }
}

