/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.ui;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConfiguration;
import org.eclipse.cdt.debug.core.ICDebugConstants;
import org.eclipse.cdt.debug.ui.ICDebuggerPage;
import org.eclipse.cdt.launch.internal.ui.AbstractCDebuggerTab;
import org.eclipse.cdt.launch.internal.ui.LaunchMessages;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CDebuggerTab
extends AbstractCDebuggerTab {
    protected final boolean fAttachMode;
    protected Button fAdvancedButton;
    protected Button fStopInMain;
    protected Text fStopInMainSymbol;
    protected Button fAttachButton;
    private Map fAdvancedAttributes = new HashMap(5);

    public CDebuggerTab(boolean attachMode) {
        this.fAttachMode = attachMode;
        ICDebugConfiguration dc = CDebugCorePlugin.getDefault().getDefaultDefaultDebugConfiguration();
        if (dc == null) {
            CDebugCorePlugin.getDefault().getPluginPreferences().setDefault(ICDebugConstants.PREF_DEFAULT_DEBUGGER_TYPE, "org.eclipse.cdt.debug.mi.core.CDebuggerNew");
        }
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        LaunchUIPlugin.getDefault().getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.cdt.launch.launch_configuration_dialog_debugger_tab");
        int numberOfColumns = this.fAttachMode ? 2 : 1;
        GridLayout layout = new GridLayout(numberOfColumns, false);
        comp.setLayout((Layout)layout);
        GridData gd = new GridData(1, 2, true, false);
        comp.setLayoutData((Object)gd);
        this.createDebuggerCombo(comp, this.fAttachMode ? 1 : 2);
        this.createOptionsComposite(comp);
        this.createDebuggerGroup(comp, 2);
    }

    protected void loadDebuggerComboBox(ILaunchConfiguration config, String selection) {
        ICDebugConfiguration dc;
        String configPlatform = this.getPlatform(config);
        ICDebugConfiguration[] debugConfigs = CDebugCorePlugin.getDefault().getActiveDebugConfigurations();
        Arrays.sort(debugConfigs, new Comparator(){

            public int compare(Object o1, Object o2) {
                ICDebugConfiguration ic1 = (ICDebugConfiguration)o1;
                ICDebugConfiguration ic2 = (ICDebugConfiguration)o2;
                return ic1.getName().compareTo(ic2.getName());
            }
        });
        ArrayList<ICDebugConfiguration> list = new ArrayList<ICDebugConfiguration>();
        String mode = this.fAttachMode ? "attach" : "run";
        if (selection.equals("") && (dc = CDebugCorePlugin.getDefault().getDefaultDebugConfiguration()) != null) {
            selection = dc.getID();
        }
        String defaultSelection = selection;
        int i = 0;
        while (i < debugConfigs.length) {
            if (debugConfigs[i].supportsMode(mode)) {
                String debuggerPlatform = debugConfigs[i].getPlatform();
                if (this.validatePlatform(config, debugConfigs[i])) {
                    list.add(debugConfigs[i]);
                    if (defaultSelection.equals("") && debuggerPlatform.equalsIgnoreCase(configPlatform)) {
                        defaultSelection = debugConfigs[i].getID();
                    }
                }
            }
            ++i;
        }
        this.setInitializeDefault(selection.equals(""));
        this.loadDebuggerCombo(list.toArray(new ICDebugConfiguration[list.size()]), defaultSelection);
    }

    protected void updateComboFromSelection() {
        super.updateComboFromSelection();
        this.initializeCommonControls(this.getLaunchConfiguration());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        super.setDefaults(config);
        if (this.fAttachMode) {
            config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "attach");
        } else {
            config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
            config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", true);
        }
        config.setAttribute("org.eclipse.cdt.launch.ENABLE_VARIABLE_BOOKKEEPING", false);
        config.setAttribute("org.eclipse.cdt.launch.ENABLE_REGISTER_BOOKKEEPING", false);
        ICDebugConfiguration dc = CDebugCorePlugin.getDefault().getDefaultDebugConfiguration();
        if (dc != null) {
            config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_ID", dc.getID());
        }
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.setInitializing(true);
        super.initializeFrom(config);
        try {
            String id = config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_ID", "");
            this.loadDebuggerComboBox(config, id);
            this.initializeCommonControls(config);
        }
        catch (CoreException coreException) {}
        this.setInitializing(false);
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        super.performApply(config);
        if (this.fAttachMode) {
            config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "attach");
        } else {
            config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", this.fStopInMain.getSelection());
            config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN_SYMBOL", this.fStopInMainSymbol.getText());
            config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
        }
        this.applyAdvancedAttributes(config);
    }

    public boolean isValid(ILaunchConfiguration config) {
        String mode;
        if (!this.validateDebuggerConfig(config)) {
            return false;
        }
        ICDebugConfiguration debugConfig = this.getDebugConfig();
        String string = mode = this.fAttachMode ? "attach" : "run";
        if (!debugConfig.supportsMode(mode)) {
            this.setErrorMessage(MessageFormat.format(LaunchMessages.getString("CDebuggerTab.Mode_not_supported"), mode));
            return false;
        }
        if (this.fStopInMain != null && this.fStopInMainSymbol != null) {
            String mainSymbol = this.fStopInMainSymbol.getText().trim();
            if (this.fStopInMain.getSelection() && mainSymbol.length() == 0) {
                this.setErrorMessage(LaunchMessages.getString("CDebuggerTab.Stop_on_startup_at_can_not_be_empty"));
                return false;
            }
        }
        return super.isValid(config);
    }

    protected boolean validatePlatform(ILaunchConfiguration config, ICDebugConfiguration debugConfig) {
        String configPlatform = this.getPlatform(config);
        String debuggerPlatform = debugConfig.getPlatform();
        return debuggerPlatform.equals("*") || debuggerPlatform.equalsIgnoreCase(configPlatform);
    }

    protected boolean validateCPU(ILaunchConfiguration config, ICDebugConfiguration debugConfig) {
        IBinaryParser.IBinaryObject binaryFile = null;
        try {
            binaryFile = this.getBinary(config);
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getLocalizedMessage());
        }
        String projectCPU = "native";
        if (binaryFile != null) {
            projectCPU = binaryFile.getCPU();
        }
        return debugConfig.supportsCPU(projectCPU);
    }

    protected IBinaryParser.IBinaryObject getBinary(ILaunchConfiguration config) throws CoreException {
        String programName = null;
        String projectName = null;
        try {
            projectName = config.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", null);
            programName = config.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", null);
        }
        catch (CoreException coreException) {}
        if (programName != null) {
            Path exePath = new Path(programName);
            if (projectName != null && !projectName.equals("")) {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                if (!project.isAccessible()) {
                    return null;
                }
                if (!exePath.isAbsolute()) {
                    exePath = project.getLocation().append((IPath)exePath);
                }
                ICExtensionReference[] parserRef = CCorePlugin.getDefault().getBinaryParserExtensions(project);
                int i = 0;
                while (i < parserRef.length) {
                    try {
                        IBinaryParser parser = (IBinaryParser)parserRef[i].createExtension();
                        IBinaryParser.IBinaryObject exe = (IBinaryParser.IBinaryObject)parser.getBinary((IPath)exePath);
                        if (exe != null) {
                            return exe;
                        }
                    }
                    catch (ClassCastException classCastException) {
                    }
                    catch (IOException iOException) {}
                    ++i;
                }
            }
            IBinaryParser parser = CCorePlugin.getDefault().getDefaultBinaryParser();
            try {
                IBinaryParser.IBinaryObject exe = (IBinaryParser.IBinaryObject)parser.getBinary((IPath)exePath);
                return exe;
            }
            catch (ClassCastException classCastException) {
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    protected boolean validateDebuggerConfig(ILaunchConfiguration config) {
        ICDebugConfiguration debugConfig = this.getDebugConfig();
        if (debugConfig == null) {
            this.setErrorMessage(LaunchMessages.getString("CDebuggerTab.No_debugger_available"));
            return false;
        }
        if (!this.validatePlatform(config, debugConfig)) {
            this.setErrorMessage(LaunchMessages.getString("CDebuggerTab.Platform_is_not_supported"));
            return false;
        }
        if (!this.validateCPU(config, debugConfig)) {
            this.setErrorMessage(LaunchMessages.getString("CDebuggerTab.CPU_is_not_supported"));
            return false;
        }
        return true;
    }

    protected void update() {
        if (!this.isInitializing()) {
            super.updateLaunchConfigurationDialog();
        }
    }

    protected void createOptionsComposite(Composite parent) {
        Composite optionsComp = new Composite(parent, 0);
        int numberOfColumns = this.fAttachMode ? 1 : 3;
        GridLayout layout = new GridLayout(numberOfColumns, false);
        optionsComp.setLayout((Layout)layout);
        optionsComp.setLayoutData((Object)new GridData(1, 2, true, false, 1, 1));
        if (!this.fAttachMode) {
            this.fStopInMain = this.createCheckButton(optionsComp, LaunchMessages.getString("CDebuggerTab.Stop_at_main_on_startup"));
            this.fStopInMain.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CDebuggerTab.this.fStopInMainSymbol.setEnabled(CDebuggerTab.this.fStopInMain.getSelection());
                    CDebuggerTab.this.update();
                }
            });
            this.fStopInMainSymbol = new Text(optionsComp, 2052);
            GridData gridData = new GridData(4, 2, false, false);
            gridData.widthHint = 100;
            this.fStopInMainSymbol.setLayoutData((Object)gridData);
            this.fStopInMainSymbol.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent evt) {
                    CDebuggerTab.this.update();
                }
            });
        }
        this.fAdvancedButton = this.createPushButton(optionsComp, LaunchMessages.getString("CDebuggerTab.Advanced"), null);
        ((GridData)this.fAdvancedButton.getLayoutData()).horizontalAlignment = 3;
        this.fAdvancedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdvancedDebuggerOptionsDialog dialog = new AdvancedDebuggerOptionsDialog(CDebuggerTab.this.getShell());
                dialog.open();
            }
        });
    }

    protected Map getAdvancedAttributes() {
        return this.fAdvancedAttributes;
    }

    private void initializeAdvancedAttributes(ILaunchConfiguration config) {
        Map attr = this.getAdvancedAttributes();
        try {
            Boolean varBookkeeping = config.getAttribute("org.eclipse.cdt.launch.ENABLE_VARIABLE_BOOKKEEPING", false) ? Boolean.TRUE : Boolean.FALSE;
            attr.put("org.eclipse.cdt.launch.ENABLE_VARIABLE_BOOKKEEPING", varBookkeeping);
        }
        catch (CoreException coreException) {}
        try {
            Boolean regBookkeeping = config.getAttribute("org.eclipse.cdt.launch.ENABLE_REGISTER_BOOKKEEPING", false) ? Boolean.TRUE : Boolean.FALSE;
            attr.put("org.eclipse.cdt.launch.ENABLE_REGISTER_BOOKKEEPING", regBookkeeping);
        }
        catch (CoreException coreException) {}
    }

    private void applyAdvancedAttributes(ILaunchConfigurationWorkingCopy config) {
        Object regBookkeeping;
        Map attr = this.getAdvancedAttributes();
        Object varBookkeeping = attr.get("org.eclipse.cdt.launch.ENABLE_VARIABLE_BOOKKEEPING");
        if (varBookkeeping instanceof Boolean) {
            config.setAttribute("org.eclipse.cdt.launch.ENABLE_VARIABLE_BOOKKEEPING", ((Boolean)varBookkeeping).booleanValue());
        }
        if ((regBookkeeping = attr.get("org.eclipse.cdt.launch.ENABLE_REGISTER_BOOKKEEPING")) instanceof Boolean) {
            config.setAttribute("org.eclipse.cdt.launch.ENABLE_REGISTER_BOOKKEEPING", ((Boolean)regBookkeeping).booleanValue());
        }
    }

    protected Shell getShell() {
        return super.getShell();
    }

    public void dispose() {
        this.getAdvancedAttributes().clear();
        ICDebuggerPage debuggerPage = this.getDynamicTab();
        if (debuggerPage != null) {
            debuggerPage.dispose();
        }
        super.dispose();
    }

    protected void initializeCommonControls(ILaunchConfiguration config) {
        try {
            if (!this.fAttachMode) {
                this.fStopInMain.setSelection(config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", true));
                this.fStopInMainSymbol.setText(config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN_SYMBOL", "main"));
                this.fStopInMainSymbol.setEnabled(this.fStopInMain.getSelection());
            }
            this.initializeAdvancedAttributes(config);
        }
        catch (CoreException coreException) {}
    }

    protected void setInitializeDefault(boolean init) {
        super.setInitializeDefault(init);
    }

    public class AdvancedDebuggerOptionsDialog
    extends Dialog {
        private Button fVarBookKeeping;
        private Button fRegBookKeeping;

        protected AdvancedDebuggerOptionsDialog(Shell parentShell) {
            super(parentShell);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Group group = new Group(composite, 0);
            group.setText(LaunchMessages.getString("CDebuggerTab.Automatically_track_values_of"));
            GridLayout layout = new GridLayout();
            group.setLayout((Layout)layout);
            group.setLayoutData((Object)new GridData(768));
            this.fVarBookKeeping = new Button((Composite)group, 32);
            this.fVarBookKeeping.setText(LaunchMessages.getString("CDebuggerTab.Variables"));
            this.fRegBookKeeping = new Button((Composite)group, 32);
            this.fRegBookKeeping.setText(LaunchMessages.getString("CDebuggerTab.Registers"));
            this.initialize();
            return composite;
        }

        protected void okPressed() {
            this.saveValues();
            super.okPressed();
        }

        private void initialize() {
            Map attr = CDebuggerTab.this.getAdvancedAttributes();
            Object varBookkeeping = attr.get("org.eclipse.cdt.launch.ENABLE_VARIABLE_BOOKKEEPING");
            this.fVarBookKeeping.setSelection(varBookkeeping instanceof Boolean ? !((Boolean)varBookkeeping).booleanValue() : true);
            Object regBookkeeping = attr.get("org.eclipse.cdt.launch.ENABLE_REGISTER_BOOKKEEPING");
            this.fRegBookKeeping.setSelection(regBookkeeping instanceof Boolean ? !((Boolean)regBookkeeping).booleanValue() : true);
        }

        private void saveValues() {
            Map attr = CDebuggerTab.this.getAdvancedAttributes();
            Boolean varBookkeeping = !this.fVarBookKeeping.getSelection();
            attr.put("org.eclipse.cdt.launch.ENABLE_VARIABLE_BOOKKEEPING", varBookkeeping);
            Boolean regBookkeeping = !this.fRegBookKeeping.getSelection();
            attr.put("org.eclipse.cdt.launch.ENABLE_REGISTER_BOOKKEEPING", regBookkeeping);
            CDebuggerTab.this.update();
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(LaunchMessages.getString("CDebuggerTab.Advanced_Options_Dialog_Title"));
        }
    }
}

