/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.Context;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.LineData;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Node;
import edu.uoregon.tau.perfdmf.Thread;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class HPMToolkitDataSource
extends DataSource {
    private Object initializeObject;
    private int metric = 0;
    private Function function = null;
    private FunctionProfile functionProfile = null;
    private Node node = null;
    private Context context = null;
    private Thread thread = null;
    private int nodeID = -1;
    private int contextID = -1;
    private int threadID = -1;
    private int timeMetric = -1;
    private String inputString = null;
    private BufferedReader br = null;
    boolean initialized = false;
    Hashtable eventNames = new Hashtable();
    private LineData header1 = new LineData();
    private LineData header2 = new LineData();
    private LineData header3 = new LineData();
    private LineData header4 = new LineData();

    public HPMToolkitDataSource(Object object) {
        this.initializeObject = object;
    }

    public void cancelLoad() {
    }

    public int getProgress() {
        return 0;
    }

    public void load() throws FileNotFoundException, IOException {
        boolean bl = true;
        List list = (List)this.initializeObject;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            File[] fileArray = (File[])iterator.next();
            for (int i = 0; i < fileArray.length; ++i) {
                long l = System.currentTimeMillis();
                FileInputStream fileInputStream = new FileInputStream(fileArray[i]);
                InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
                this.br = new BufferedReader(inputStreamReader);
                ++this.nodeID;
                this.eventNames = new Hashtable();
                this.inputString = this.br.readLine();
                if (this.inputString == null) {
                    return;
                }
                while ((this.inputString = this.br.readLine()) != null && !this.inputString.trim().startsWith("Instrumented section:")) {
                }
                boolean bl2 = true;
                boolean bl3 = false;
                while (this.inputString != null) {
                    if (this.inputString.length() != 0) {
                        if (this.inputString.trim().startsWith("Instrumented section:")) {
                            if (!bl2 && !bl3) {
                                this.functionProfile.setExclusive(this.timeMetric, this.functionProfile.getInclusive(this.timeMetric));
                            }
                            bl2 = false;
                            bl3 = false;
                            this.processHeaderLine1(this.inputString);
                        } else if (this.inputString.trim().startsWith("file:")) {
                            this.processHeaderLine2(this.inputString);
                        } else if (this.inputString.trim().startsWith("Count:")) {
                            this.processHeaderLine3(this.inputString);
                        } else if (this.inputString.trim().startsWith("Wall Clock Time:")) {
                            this.processTime(this.inputString, true);
                        } else if (this.inputString.trim().startsWith("Average duration:")) {
                            this.processHeaderLine4(this.inputString, 1);
                        } else if (this.inputString.trim().startsWith("Standard deviation:")) {
                            this.processHeaderLine4(this.inputString, 2);
                        } else if (this.inputString.trim().startsWith("Exclusive duration:")) {
                            this.processTime(this.inputString, false);
                            bl3 = true;
                        } else if (this.inputString.trim().startsWith("Total time in user mode:")) {
                            this.processHardwareCounter(this.inputString);
                        } else {
                            this.processHardwareCounter(this.inputString);
                        }
                    }
                    this.inputString = this.br.readLine();
                }
                if (!bl2 && !bl3) {
                    this.functionProfile.setExclusive(this.timeMetric, this.functionProfile.getInclusive(this.timeMetric));
                }
                this.br.close();
                l = System.currentTimeMillis() - l;
            }
        }
        this.generateDerivedData();
    }

    private void initializeThread() {
        this.function = this.header2.s1 == null ? this.addFunction(this.header1.s0 + ", " + this.header2.s0, 1) : this.addFunction(this.header1.s0 + ", " + this.header2.s0 + " lines " + this.header2.s1, 1);
        this.nodeID = this.nodeID == -1 ? 0 : this.nodeID;
        this.contextID = this.contextID == -1 ? 0 : this.contextID;
        this.threadID = this.threadID == -1 ? 0 : this.threadID;
        this.thread = this.addThread(this.nodeID, this.contextID, this.threadID);
        this.functionProfile = this.thread.getFunctionProfile(this.function);
        if (this.functionProfile == null) {
            this.functionProfile = new FunctionProfile(this.function, this.getNumberOfMetrics());
            this.thread.addFunctionProfile(this.functionProfile);
        }
        this.initialized = true;
    }

    private void processHeaderLine1(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
        string = stringTokenizer.nextToken();
        StringTokenizer stringTokenizer2 = new StringTokenizer(string, ":");
        string = stringTokenizer2.nextToken();
        this.header1.i0 = Integer.parseInt(stringTokenizer2.nextToken().trim());
        string = stringTokenizer.nextToken();
        stringTokenizer2 = new StringTokenizer(string, ":");
        string = stringTokenizer2.nextToken();
        this.header1.s0 = stringTokenizer2.nextToken().trim();
        string = stringTokenizer.nextToken();
        stringTokenizer2 = new StringTokenizer(string, ":");
        string = stringTokenizer2.nextToken();
        this.header1.i1 = Integer.parseInt(stringTokenizer2.nextToken().trim());
        if (this.eventNames.containsKey(this.header1.s0)) {
            Integer n = (Integer)this.eventNames.get(this.header1.s0);
            this.threadID = n;
            ++this.threadID;
            this.eventNames.put(this.header1.s0, new Integer(this.threadID));
        } else {
            this.threadID = 0;
            this.eventNames.put(this.header1.s0, new Integer(this.threadID));
        }
        this.initialized = false;
    }

    private void processHeaderLine2(String string) {
        this.header2.s0 = null;
        this.header2.s1 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        string = stringTokenizer.nextToken();
        StringTokenizer stringTokenizer2 = new StringTokenizer(string, ":");
        string = stringTokenizer2.nextToken();
        this.header2.s0 = stringTokenizer2.nextToken().trim();
        string = stringTokenizer.nextToken();
        stringTokenizer2 = new StringTokenizer(string, ":");
        string = stringTokenizer2.nextToken();
        this.header2.s1 = stringTokenizer2.nextToken().trim();
    }

    private void processHeaderLine3(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        string = stringTokenizer.nextToken();
        this.header3.i0 = Integer.parseInt(stringTokenizer.nextToken().trim());
    }

    private void processHeaderLine4(String string, int n) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        string = stringTokenizer.nextToken();
        string = stringTokenizer.nextToken();
        StringTokenizer stringTokenizer2 = new StringTokenizer(string, " ");
        if (n == 0) {
            this.header4.d0 = Double.parseDouble(stringTokenizer2.nextToken());
        } else if (n == 1) {
            this.header4.d1 = Double.parseDouble(stringTokenizer2.nextToken());
        } else if (n == 2) {
            this.header4.d2 = Double.parseDouble(stringTokenizer2.nextToken());
        } else if (n == 3) {
            this.header4.d3 = Double.parseDouble(stringTokenizer2.nextToken());
        }
    }

    private void processHardwareCounter(String string) {
        if (!this.initialized) {
            if (this.header2.s0 == null) {
                this.header2.s0 = new String("Entire Program");
            }
            if (this.header3.i0 == 0) {
                this.header3.i0 = 1;
            }
            this.initializeThread();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        String string2 = stringTokenizer.nextToken().trim();
        String string3 = stringTokenizer.nextToken().trim();
        stringTokenizer = new StringTokenizer(string3, " ");
        double d = 0.0;
        boolean bl = false;
        string3 = stringTokenizer.nextToken().trim();
        boolean bl2 = false;
        try {
            d = Double.parseDouble(string3);
        }
        catch (NumberFormatException numberFormatException) {
            d = 0.0;
        }
        bl2 = true;
        if (stringTokenizer.hasMoreTokens()) {
            string2 = string2 + " (" + stringTokenizer.nextToken() + ")";
        }
        Metric metric = this.addMetric(string2);
        this.metric = metric.getID();
        if (bl2) {
            this.functionProfile.setExclusive(this.metric, d);
            this.functionProfile.setInclusive(this.metric, d);
        } else {
            this.functionProfile.setExclusive(this.metric, (double)bl);
            this.functionProfile.setInclusive(this.metric, (double)bl);
        }
        this.functionProfile.setNumCalls(this.header3.i0);
        this.functionProfile.setNumSubr(0.0);
    }

    private void processTime(String string, boolean bl) {
        if (!this.initialized) {
            if (this.header2.s0 == null) {
                this.header2.s0 = new String("Entire Program");
            }
            if (this.header3.i0 == 0) {
                this.header3.i0 = 1;
            }
            this.initializeThread();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        String string2 = stringTokenizer.nextToken().trim();
        string2 = "Time";
        String string3 = stringTokenizer.nextToken().trim();
        boolean bl2 = false;
        boolean bl3 = false;
        stringTokenizer = new StringTokenizer(string3, " ");
        double d = 0.0;
        boolean bl4 = false;
        string3 = stringTokenizer.nextToken().trim();
        try {
            d = Double.parseDouble(string3);
        }
        catch (NumberFormatException numberFormatException) {
            d = 0.0;
        }
        Metric metric = this.addMetric(string2);
        this.timeMetric = this.metric = metric.getID();
        d = d * 1000.0 * 1000.0;
        if (bl) {
            this.functionProfile.setInclusive(this.metric, d);
        } else {
            this.functionProfile.setExclusive(this.metric, d);
        }
        this.functionProfile.setNumCalls(this.header3.i0);
        this.functionProfile.setNumSubr(0.0);
    }

    private String getMetricName(String string) {
        String string2 = null;
        int n = string.indexOf("_MULTI_");
        if (n > 0) {
            string2 = string.substring(n + 7);
            return string2;
        }
        return string2;
    }
}

