/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.DataSourceException;
import edu.uoregon.tau.perfdmf.SnapshotXMLHandler;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SnapshotDataSource
extends DataSource {
    private volatile long totalBytes = 0L;
    private volatile long bytesRead = 0L;
    private volatile TrackerInputStream tracker;
    private File[] files;

    public SnapshotDataSource(File[] fileArray) {
        this.files = fileArray;
    }

    public void cancelLoad() {
    }

    public int getProgress() {
        if (this.totalBytes != 0L) {
            return (int)((float)(this.bytesRead + this.tracker.byteCount()) / (float)this.totalBytes * 100.0f);
        }
        return 0;
    }

    public void load() throws FileNotFoundException, IOException, DataSourceException, SQLException {
        try {
            int n;
            long l = System.currentTimeMillis();
            XMLReader xMLReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            this.totalBytes = 0L;
            for (n = 0; n < this.files.length; ++n) {
                this.totalBytes += this.files[n].length();
            }
            for (n = 0; n < this.files.length; ++n) {
                FileInputStream fileInputStream = new FileInputStream(this.files[n]);
                this.tracker = new TrackerInputStream(fileInputStream);
                SnapshotXMLHandler snapshotXMLHandler = new SnapshotXMLHandler(this);
                xMLReader.setContentHandler(snapshotXMLHandler);
                xMLReader.setErrorHandler(snapshotXMLHandler);
                xMLReader.parse(new InputSource(new RootWrap(new BufferedInputStream(this.tracker))));
                this.bytesRead += this.files[n].length();
            }
            l = System.currentTimeMillis() - l;
            this.generateDerivedData();
            this.aggregateMetaData();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            throw new DataSourceException(sAXException);
        }
    }

    class TrackerInputStream
    extends FilterInputStream {
        private long count;

        public TrackerInputStream(InputStream inputStream) {
            super(inputStream);
        }

        public long byteCount() {
            return this.count;
        }

        public int read() throws IOException {
            ++this.count;
            return super.read();
        }

        public int read(byte[] byArray) throws IOException {
            this.count += (long)byArray.length;
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = super.read(byArray, n, n2);
            if (n3 > 0) {
                this.count += (long)n3;
            }
            return n3;
        }
    }

    private static class RootWrap
    extends InputStream {
        private InputStream stream;
        private static String before = "<root>";
        private static String after = "</root>";
        private int position = 0;
        private static int BEFORE = 0;
        private static int DURING = 1;
        private static int AFTER = 2;
        private int state = BEFORE;

        public RootWrap(InputStream inputStream) {
            this.stream = inputStream;
        }

        public int read() throws IOException {
            if (this.state == DURING) {
                int n = this.stream.read();
                if (n == -1) {
                    this.state = AFTER;
                    this.position = 0;
                }
                return n;
            }
            if (this.state == BEFORE) {
                char c = before.charAt(this.position++);
                if (this.position == before.length()) {
                    this.state = DURING;
                }
                return c;
            }
            if (this.state == AFTER) {
                if (this.position < after.length()) {
                    return after.charAt(this.position++);
                }
                return -1;
            }
            return -1;
        }

        public int read(byte[] byArray) throws IOException {
            if (this.state == DURING) {
                int n = this.stream.read(byArray);
                if (n == -1) {
                    this.state = AFTER;
                    this.position = 0;
                }
                return n;
            }
            return super.read(byArray);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.state == DURING) {
                int n3 = this.stream.read(byArray, n, n2);
                if (n3 == -1) {
                    this.state = AFTER;
                    this.position = 0;
                }
                return n3;
            }
            return super.read(byArray, n, n2);
        }
    }
}

