/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf.database;

import edu.uoregon.tau.perfdmf.Database;
import edu.uoregon.tau.perfdmf.database.DB;
import edu.uoregon.tau.perfdmf.database.ParseConfig;
import edu.uoregon.tau.perfdmf.database.PasswordCallback;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class DBConnector
implements DB {
    private Statement statement;
    private Connection conn;
    private ParseConfig config;
    private String dbaddress;
    private String dbUser;
    private String dbPassword;
    private String driverName;
    private String JDBCjarFileName;
    private Database database;
    private static Map passwordMap = new HashMap();
    private static PasswordCallback passwordCallback;

    public DBConnector(String string, String string2, Database database) throws SQLException {
        this.database = database;
        this.config = database.getConfig();
        this.setJDBC(this.config);
        this.register();
        this.connect(string, string2);
    }

    public DBConnector(String string, String string2, Database database, boolean bl) throws SQLException {
        this.database = database;
        this.config = database.getConfig();
        this.setJDBC(this.config);
        this.register();
        if (bl) {
            this.connectAndCreate(string, string2);
        }
    }

    public void setJDBC(ParseConfig parseConfig) {
        this.driverName = parseConfig.getJDBCDriver();
        this.dbaddress = parseConfig.getConnectionString();
        this.JDBCjarFileName = parseConfig.getJDBCJarFile();
    }

    public void close() {
        try {
            if (this.conn.isClosed()) {
                return;
            }
            this.conn.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.conn.setAutoCommit(bl);
    }

    public void commit() throws SQLException {
        this.conn.commit();
    }

    public void rollback() throws SQLException {
        this.conn.rollback();
    }

    private static String findPassword(ParseConfig parseConfig) {
        String string = (String)passwordMap.get(parseConfig.getPath());
        if (string == null && passwordCallback != null) {
            string = passwordCallback.getPassword(parseConfig);
            passwordMap.put(parseConfig.getPath(), string);
        }
        return string;
    }

    public boolean connect(String string, String string2) throws SQLException {
        String string3 = "";
        try {
            if (this.conn != null) {
                return true;
            }
            string3 = this.getConnectString();
            if (string2 == null) {
                string2 = DBConnector.findPassword(this.config);
            }
            this.conn = DriverManager.getConnection(string3, string, string2);
            return true;
        }
        catch (SQLException sQLException) {
            System.err.println("Cannot connect to server.");
            System.err.println("Connection String: " + string3);
            System.err.println("Exception Message: " + sQLException.getMessage());
            throw sQLException;
        }
    }

    public void connectAndCreate(String string, String string2) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append(this.getConnectString());
            stringBuffer.append(";create=true");
            if (string2 == null) {
                string2 = DBConnector.findPassword(this.config);
            }
            this.conn = DriverManager.getConnection(stringBuffer.toString(), string, string2);
            this.conn.close();
            System.out.println("Database created, command: " + stringBuffer.toString());
        }
        catch (SQLException sQLException) {
            System.err.println("Cannot create database.");
            System.err.println("Connection String: " + stringBuffer);
            System.err.println("Exception Message: " + sQLException.getMessage());
            throw sQLException;
        }
    }

    public ResultSet executeQuery(String string) throws SQLException {
        if (this.statement == null) {
            if (this.conn == null) {
                System.err.println("Database is closed for " + string);
                return null;
            }
            this.statement = this.conn.createStatement();
        }
        return this.statement.executeQuery(string.trim());
    }

    public boolean execute(String string) throws SQLException {
        if (this.statement == null) {
            if (this.conn == null) {
                System.err.println("Database is closed for " + string);
                return false;
            }
            this.statement = this.conn.createStatement();
        }
        return this.statement.execute(string.trim());
    }

    public int executeUpdate(String string) throws SQLException {
        if (this.statement == null) {
            if (this.conn == null) {
                System.err.println("Database is closed for " + string);
                return 0;
            }
            this.statement = this.conn.createStatement();
        }
        return this.statement.executeUpdate(string.trim());
    }

    public Connection getConnection() {
        return this.conn;
    }

    public String getConnectString() {
        return this.dbaddress;
    }

    public String getDataItem(String string) throws SQLException {
        ResultSet resultSet = this.executeQuery(string);
        if (!resultSet.next()) {
            resultSet.close();
            return null;
        }
        String string2 = resultSet.getString(1);
        resultSet.close();
        return string2;
    }

    public boolean isClosed() {
        if (this.conn == null) {
            return true;
        }
        try {
            return this.conn.isClosed();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return true;
        }
    }

    public void register() {
        try {
            File file = new File(this.JDBCjarFileName);
            if (!file.exists()) {
                System.err.println("Warning: file '" + this.JDBCjarFileName + "' does not exist!");
            }
            URL[] uRLArray = new URL[]{System.getProperty("os.name").toLowerCase().trim().startsWith("windows") ? new URL("file:\\" + this.JDBCjarFileName.replace('\\', '/')) : new URL("file://" + this.JDBCjarFileName)};
            URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
            try {
                Class<?> clazz = Class.forName(this.driverName, true, uRLClassLoader);
                Driver driver = (Driver)clazz.newInstance();
                DriverManager.registerDriver(new DriverShim(driver));
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    Class.forName(this.driverName).newInstance();
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    System.err.println("Unable to load driver '" + this.driverName + "' from " + this.JDBCjarFileName);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.conn.getMetaData();
    }

    public void setDBAddress(String string) {
        this.dbaddress = string;
    }

    public String getDBType() {
        return new String(this.config.getDBType());
    }

    public String getSchemaPrefix() {
        if (this.getDBType().compareTo("oracle") == 0) {
            if (this.config.getDBSchemaPrefix() != null && this.config.getDBSchemaPrefix().compareTo("") != 0) {
                return new String(this.config.getDBSchemaPrefix() + ".");
            }
            return "";
        }
        if (this.getDBType().compareTo("db2") == 0) {
            if (this.config.getDBSchemaPrefix() != null && this.config.getDBSchemaPrefix().compareTo("") != 0) {
                return new String(this.config.getDBSchemaPrefix() + ".");
            }
            return "";
        }
        return "";
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        return this.getConnection().prepareStatement(string);
    }

    public static boolean isReadAbleType(int n) {
        return n == 12 || n == 2005 || n == 4 || n == 3 || n == 8 || n == 6 || n == -1 || n == 92 || n == 93 || n == -2 || n == -3 || n == -4 || n == 2004;
    }

    public static boolean isWritableType(int n) {
        return n == 12 || n == 2005 || n == 4 || n == 3 || n == 8 || n == 6 || n == -1 || n == -2 || n == -3 || n == -4 || n == 2004;
    }

    public static boolean isIntegerType(int n) {
        return n == 4;
    }

    public static boolean isFloatingPointType(int n) {
        if (n == 3) {
            return true;
        }
        if (n == 8) {
            return true;
        }
        return n == 6;
    }

    public int checkTable(DatabaseMetaData databaseMetaData, String string, String[] stringArray) throws SQLException {
        int n;
        boolean[] blArray = new boolean[stringArray.length];
        ResultSet resultSet = null;
        resultSet = this.getDBType().compareTo("oracle") == 0 || this.getDBType().compareTo("derby") == 0 || this.getDBType().compareTo("db2") == 0 ? databaseMetaData.getColumns(null, null, string.toUpperCase(), "%") : databaseMetaData.getColumns(null, null, string, "%");
        while (resultSet.next()) {
            n = resultSet.getInt("DATA_TYPE");
            String string2 = resultSet.getString("COLUMN_NAME");
            String string3 = resultSet.getString("TYPE_NAME");
            if (!DBConnector.isReadAbleType(n)) continue;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].toUpperCase().compareTo(string2.toUpperCase()) != 0) continue;
                blArray[i] = true;
            }
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (blArray[n]) continue;
            System.out.println("Couldn't find column \"" + stringArray[n] + "\" in table \"" + string + "\"");
            return -1;
        }
        return 0;
    }

    public int checkSchema() throws SQLException {
        Object var1_1 = null;
        DatabaseMetaData databaseMetaData = this.getMetaData();
        String[] stringArray = new String[]{"ID", "NAME"};
        if (this.checkTable(databaseMetaData, "application", stringArray) != 0) {
            return -1;
        }
        String[] stringArray2 = new String[]{"ID", "NAME", "application"};
        if (this.checkTable(databaseMetaData, "experiment", stringArray2) != 0) {
            return -1;
        }
        String[] stringArray3 = new String[]{"ID", "NAME", "experiment"};
        if (this.checkTable(databaseMetaData, "trial", stringArray3) != 0) {
            return -1;
        }
        String[] stringArray4 = new String[]{"id", "name", "trial"};
        if (this.checkTable(databaseMetaData, "metric", stringArray4) != 0) {
            return -1;
        }
        String[] stringArray5 = new String[]{"id", "name", "trial", "group_name"};
        if (this.checkTable(databaseMetaData, "interval_event", stringArray5) != 0) {
            return -1;
        }
        String[] stringArray6 = new String[]{"id", "name", "trial", "group_name"};
        if (this.checkTable(databaseMetaData, "atomic_event", stringArray6) != 0) {
            return -1;
        }
        String[] stringArray7 = new String[]{"interval_event", "node", "context", "thread", "metric", "inclusive_percentage", "inclusive", "exclusive_percentage", "exclusive", "call", "subroutines", "inclusive_per_call"};
        if (this.getDBType().compareTo("oracle") == 0) {
            stringArray7[8] = "excl";
        } else if (this.getDBType().compareTo("derby") == 0) {
            stringArray7[9] = "num_calls";
        } else if (this.getDBType().compareTo("mysql") == 0) {
            stringArray7[9] = "call";
        }
        if (this.checkTable(databaseMetaData, "interval_location_profile", stringArray7) != 0) {
            return -1;
        }
        String[] stringArray8 = new String[]{"atomic_event", "node", "context", "thread", "sample_count", "maximum_value", "minimum_value", "mean_value", "standard_deviation"};
        if (this.checkTable(databaseMetaData, "atomic_location_profile", stringArray8) != 0) {
            return -1;
        }
        String[] stringArray9 = new String[]{"interval_event", "metric", "inclusive_percentage", "inclusive", "exclusive_percentage", "exclusive", "call", "subroutines", "inclusive_per_call"};
        if (this.getDBType().compareTo("oracle") == 0) {
            stringArray9[5] = "excl";
        } else if (this.getDBType().compareTo("derby") == 0) {
            stringArray9[6] = "num_calls";
        } else if (this.getDBType().compareTo("mysql") == 0) {
            stringArray9[6] = "call";
        }
        if (this.checkTable(databaseMetaData, "interval_total_summary", stringArray9) != 0) {
            return -1;
        }
        if (this.checkTable(databaseMetaData, "interval_mean_summary", stringArray9) != 0) {
            return -1;
        }
        return 0;
    }

    public Database getDatabase() {
        return this.database;
    }

    public static void setPasswordCallback(PasswordCallback passwordCallback) {
        DBConnector.passwordCallback = passwordCallback;
    }

    public static class DriverShim
    implements Driver {
        private Driver driver;

        DriverShim(Driver driver) {
            this.driver = driver;
        }

        public boolean acceptsURL(String string) throws SQLException {
            return this.driver.acceptsURL(string);
        }

        public Connection connect(String string, Properties properties) throws SQLException {
            return this.driver.connect(string, properties);
        }

        public int getMajorVersion() {
            return this.driver.getMajorVersion();
        }

        public int getMinorVersion() {
            return this.driver.getMinorVersion();
        }

        public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
            return this.driver.getPropertyInfo(string, properties);
        }

        public boolean jdbcCompliant() {
            return this.driver.jdbcCompliant();
        }
    }
}

