/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.actions;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.photran.internal.ui.actions.FortranEditorActionDelegate;
import org.eclipse.photran.internal.ui.editor.AbstractFortranEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class FortranBlockCommentActionDelegate
extends FortranEditorActionDelegate {
    static /* synthetic */ Class class$0;

    public FortranBlockCommentActionDelegate() {
    }

    public FortranBlockCommentActionDelegate(AbstractFortranEditor ed) {
        super(ed);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor progressMonitor) {
        IRewriteTarget target;
        AbstractFortranEditor editor = this.getFortranEditor();
        ITextSelection selection = editor.getSelection();
        IDocument document = editor.getIDocument();
        if (document == null) {
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.jface.text.IRewriteTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$0 = clazz2;
        }
        if ((target = (IRewriteTarget)editor.getAdapter(clazz)) != null) {
            target.beginCompoundChange();
        }
        Edit.EditFactory factory = new Edit.EditFactory(document);
        try {
            try {
                this.runInternal(selection, factory);
            }
            catch (BadLocationException badLocationException) {}
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            factory.release();
            if (target == null) throw throwable;
            target.endCompoundChange();
            throw throwable;
        }
        {
            Object var7_9 = null;
            factory.release();
            if (target == null) return;
        }
        target.endCompoundChange();
    }

    protected void executeEdits(List edits) throws BadLocationException {
        Iterator it = edits.iterator();
        while (it.hasNext()) {
            Edit edit = (Edit)((Object)it.next());
            edit.perform();
        }
    }

    protected void runInternal(ITextSelection selection, Edit.EditFactory factory) throws BadLocationException {
        int selectionOffset = selection.getStartLine();
        int selectionEndOffset = selection.getEndLine();
        LinkedList<Edit> edits = new LinkedList<Edit>();
        IDocumentProvider dp = this.getFortranEditor().getDocumentProvider();
        IDocument doc = dp.getDocument((Object)this.getFortranEditor().getEditorInput());
        int i = selectionOffset;
        while (i <= selectionEndOffset) {
            int eff = doc.getLineOffset(i);
            if (doc.getChar(eff) == '!') {
                edits.add(factory.createEdit(eff, 1, ""));
            } else {
                edits.add(factory.createEdit(eff, 0, "!"));
            }
            ++i;
        }
        this.executeEdits(edits);
        if (selectionEndOffset == doc.getNumberOfLines() - 1) {
            this.getFortranEditor().selectAndReveal(selection.getOffset(), selection.getLength());
            this.getFortranEditor().selectAndReveal(doc.getLineOffset(selectionOffset), doc.getLineOffset(selectionEndOffset) - doc.getLineOffset(selectionOffset) + doc.getLineLength(doc.getLineLength(doc.getNumberOfLines())));
        } else {
            this.getFortranEditor().selectAndReveal(doc.getLineOffset(selectionOffset), doc.getLineOffset(selectionEndOffset + 1) - doc.getLineOffset(selectionOffset));
        }
    }

    static class Edit
    extends DocumentEvent {
        private Position fPosition;

        protected Edit(IDocument document, int length, String text, Position position) {
            super(document, 0, length, text);
            this.fPosition = position;
        }

        public int getOffset() {
            return this.fPosition.getOffset();
        }

        public void perform() throws BadLocationException {
            this.getDocument().replace(this.getOffset(), this.getLength(), this.getText());
        }

        public static class EditFactory {
            private static final String CATEGORY = "__positionalEditPositionCategory";
            private static int fgCount = 0;
            private final String fCategory = "__positionalEditPositionCategory" + fgCount++;
            private IDocument fDocument;
            private IPositionUpdater fUpdater;

            public EditFactory(IDocument document) {
                this.fDocument = document;
            }

            public Edit createEdit(int offset, int length, String text) throws BadLocationException {
                if (!this.fDocument.containsPositionCategory(this.fCategory)) {
                    this.fDocument.addPositionCategory(this.fCategory);
                    this.fUpdater = new DefaultPositionUpdater(this.fCategory);
                    this.fDocument.addPositionUpdater(this.fUpdater);
                }
                Position position = new Position(offset);
                try {
                    this.fDocument.addPosition(this.fCategory, position);
                }
                catch (BadPositionCategoryException badPositionCategoryException) {
                    System.err.println("BadPosition within Create edit");
                    Assert.isTrue((boolean)false);
                }
                return new Edit(this.fDocument, length, text, position);
            }

            public void release() {
                if (this.fDocument != null && this.fDocument.containsPositionCategory(this.fCategory)) {
                    this.fDocument.removePositionUpdater(this.fUpdater);
                    try {
                        this.fDocument.removePositionCategory(this.fCategory);
                    }
                    catch (BadPositionCategoryException badPositionCategoryException) {
                        Assert.isTrue((boolean)false);
                    }
                    this.fDocument = null;
                    this.fUpdater = null;
                }
            }
        }
    }
}

