/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.editor;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.editor.CContentOutlinePage;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IWorkingCopyManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.MarginPainter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.photran.core.util.OffsetLength;
import org.eclipse.photran.internal.core.preferences.FortranPreferences;
import org.eclipse.photran.internal.ui.actions.FortranBlockCommentActionDelegate;
import org.eclipse.photran.internal.ui.editor.FortranHorizontalRuler;
import org.eclipse.photran.ui.FortranUIPlugin;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.WorkbenchChainedTextFontFieldEditor;

public abstract class AbstractFortranEditor
extends TextEditor
implements ISelectionChangedListener {
    private static String[] PARTITION_TYPES = new String[]{"__dftl_partition_content_type"};
    private static String FORTRAN_EDITOR_CONTEXT_ID = "org.eclipse.photran.ui.FortranEditorContext";
    private static String CONTEXT_MENU_ID = "#FortranEditorContextMenu";
    private static String BLOCK_COMMENT_COMMAND_ID = "org.eclipse.photran.ui.CommentCommand";
    private static String OPEN_DECLARATION_COMMAND_ID = "org.eclipse.photran.ui.OpenDeclarationCommand";
    private static final RGB VERTICAL_LINE_COLOR = new RGB(176, 180, 185);
    private IPreferenceStore fCombinedPreferenceStore;
    private Composite fMainComposite;
    private CContentOutlinePage fOutlinePage;
    private FortranHorizontalRuler fHRuler;
    private Color verticalLineColor;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public AbstractFortranEditor() {
        this.setSourceViewerConfiguration(this.createSourceViewerConfiguration());
        this.setRangeIndicator((Annotation)new DefaultRangeIndicator());
        this.setDocumentProvider((IDocumentProvider)CUIPlugin.getDefault().getDocumentProvider());
        IPreferenceStore store = FortranUIPlugin.getDefault().getPreferenceStore();
        IPreferenceStore generalTextStore = EditorsUI.getPreferenceStore();
        this.fCombinedPreferenceStore = new ChainedPreferenceStore(new IPreferenceStore[]{store, generalTextStore, this.getPreferenceStore()});
        this.setPreferenceStore(this.fCombinedPreferenceStore);
        WorkbenchChainedTextFontFieldEditor.startPropagate((IPreferenceStore)store, (String)"org.eclipse.jface.textfont");
        this.setRulerContextMenuId("#CEditorRulerContext");
        this.setEditorContextMenuId(CONTEXT_MENU_ID);
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        IDocument document = this.getDocumentProvider().getDocument((Object)input);
        if (document == null) {
            return;
        }
        this.configurePartitionScanner(document);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        Composite childComp = (Composite)((Composite)parent.getChildren()[0]).getChildren()[0];
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 2;
        childComp.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        childComp.getChildren()[0].setLayoutData((Object)data);
        this.fMainComposite = childComp;
        this.createHorizontalRuler(this.fMainComposite);
        this.createLightGrayLines();
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.eclipse.ui.textEditorScope", FORTRAN_EDITOR_CONTEXT_ID});
    }

    protected void createActions() {
        super.createActions();
        this.createAction((IAction)new FortranBlockCommentActionDelegate(this), BLOCK_COMMENT_COMMAND_ID);
    }

    private void createAction(IAction action, String id) {
        action.setActionDefinitionId(id);
        this.setAction(id, action);
        this.markAsStateDependentAction(id, true);
        this.markAsSelectionDependentAction(id, true);
    }

    private void configurePartitionScanner(IDocument document) {
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new RuleBasedPartitionScanner(), PARTITION_TYPES);
        partitioner.connect(document);
        document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
    }

    private SourceViewerConfiguration createSourceViewerConfiguration() {
        return new SourceViewerConfiguration(){
            private PresentationReconciler reconciler = null;

            public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
                return PARTITION_TYPES;
            }

            public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
                if (this.reconciler == null) {
                    this.reconciler = new PresentationReconciler();
                    DefaultDamagerRepairer dr = new DefaultDamagerRepairer(AbstractFortranEditor.this.getTokenScanner());
                    this.reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
                    this.reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
                }
                return this.reconciler;
            }
        };
    }

    protected abstract ITokenScanner getTokenScanner();

    private void createHorizontalRuler(Composite mainComposite) {
        GC gc = new GC((Drawable)this.getSourceViewer().getTextWidget());
        GridData data = new GridData(768);
        data.heightHint = gc.getFontMetrics().getHeight();
        gc.dispose();
        this.fHRuler = this.getFortranHorizontalRuler(mainComposite);
        this.fHRuler.setFont(this.getSourceViewer().getTextWidget().getFont());
        this.fHRuler.setSourceViewer(this.getSourceViewer());
        this.fHRuler.setLayoutData(data);
        this.fHRuler.moveAbove(null);
    }

    protected abstract FortranHorizontalRuler getFortranHorizontalRuler(Composite var1);

    private void createLightGrayLines() {
        this.verticalLineColor = new Color(null, VERTICAL_LINE_COLOR);
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer instanceof ITextViewerExtension2) {
            ITextViewerExtension2 painter = (ITextViewerExtension2)sourceViewer;
            int[] columns = this.getColumnsToDrawVerticalLinesOn();
            int i = 0;
            while (i < columns.length) {
                MarginPainter p = new MarginPainter((ITextViewer)this.getSourceViewer());
                p.setMarginRulerColumn(columns[i]);
                p.setMarginRulerColor(this.verticalLineColor);
                painter.addPainter((IPainter)p);
                ++i;
            }
        }
    }

    protected abstract int[] getColumnsToDrawVerticalLinesOn();

    protected boolean affectsTextPresentation(PropertyChangeEvent event) {
        return FortranPreferences.respondToPreferenceChange((String)event.getProperty()) || super.affectsTextPresentation(event);
    }

    public Object getAdapter(Class required) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(required)) {
            return this.getOutlinePage();
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ui.part.IShowInTargetList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (required == clazz2) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.cdt.ui.CView", "org.eclipse.ui.views.ContentOutline", "org.eclipse.ui.views.ResourceNavigator"};
                }
            };
        }
        return super.getAdapter(required);
    }

    public CContentOutlinePage getOutlinePage() {
        if (this.fOutlinePage == null) {
            this.fOutlinePage = new CContentOutlinePage(null);
            this.fOutlinePage.addSelectionChangedListener((ISelectionChangedListener)this);
        }
        AbstractFortranEditor.setOutlinePageInput(this.fOutlinePage, this.getEditorInput());
        return this.fOutlinePage;
    }

    public static void setOutlinePageInput(CContentOutlinePage page, IEditorInput input) {
        if (page != null) {
            IWorkingCopyManager manager = CUIPlugin.getDefault().getWorkingCopyManager();
            page.setInput((ITranslationUnit)manager.getWorkingCopy(input));
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection;
        Object obj;
        ISelection sel = event.getSelection();
        if (sel instanceof IStructuredSelection && (obj = (selection = (IStructuredSelection)sel).getFirstElement()) instanceof ISourceReference) {
            try {
                ISourceRange range = ((ISourceReference)obj).getSourceRange();
                if (range != null) {
                    this.setSelection(range, !this.isActivePart());
                }
            }
            catch (CModelException cModelException) {}
        }
    }

    private boolean isActivePart() {
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        IPartService service = window.getPartService();
        return this == service.getActivePart();
    }

    public void setSelection(ISourceRange element, boolean moveCursor) {
        if (element == null) {
            return;
        }
        try {
            IRegion alternateRegion = null;
            int start = element.getStartPos();
            int length = element.getLength();
            if (start < 0 || length < 0) {
                start = 0;
                length = 0;
            }
            if (length == 0 && start == 0 && element.getStartLine() > 0) {
                start = this.getDocumentProvider().getDocument((Object)this.getEditorInput()).getLineOffset(element.getStartLine() - 1);
                length = element.getEndLine() > 0 ? this.getDocumentProvider().getDocument((Object)this.getEditorInput()).getLineOffset(element.getEndLine()) - start : start;
                alternateRegion = this.getDocumentProvider().getDocument((Object)this.getEditorInput()).getLineInformation(element.getStartLine() - 1);
                if ((start == length || length < 0) && alternateRegion != null) {
                    start = alternateRegion.getOffset();
                    length = alternateRegion.getLength();
                }
            }
            this.setHighlightRange(start, length, moveCursor);
            if (moveCursor) {
                start = element.getIdStartPos();
                length = element.getIdLength();
                if (start == 0 && length == 0 && alternateRegion != null) {
                    start = alternateRegion.getOffset();
                    length = alternateRegion.getLength();
                }
                if (start > -1 && this.getSourceViewer() != null) {
                    this.getSourceViewer().revealRange(start, length);
                    this.getSourceViewer().setSelectedRange(start, length);
                }
                this.updateStatusField("CursorPosition");
            }
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (BadLocationException badLocationException) {}
        if (moveCursor) {
            this.resetHighlightRange();
        }
    }

    public abstract boolean isFixedForm();

    public IFile getIFile() {
        IEditorInput input = this.getEditorInput();
        return input != null && input instanceof IFileEditorInput ? ((IFileEditorInput)input).getFile() : null;
    }

    public IDocument getIDocument() {
        IEditorInput input = this.getEditorInput();
        if (input == null) {
            return null;
        }
        IDocumentProvider dp = this.getDocumentProvider();
        if (dp == null) {
            return null;
        }
        return dp.getDocument((Object)input);
    }

    public ITextSelection getSelection() {
        ISelectionProvider provider = this.getSelectionProvider();
        if (provider == null) {
            return null;
        }
        ISelection sel = provider.getSelection();
        if (!(sel instanceof ITextSelection)) {
            return null;
        }
        return (ITextSelection)sel;
    }

    public OffsetLength getSelectionOffsetLength() {
        ITextSelection sel = this.getSelection();
        return sel == null ? null : new OffsetLength(sel.getOffset(), sel.getLength());
    }

    public Shell getShell() {
        return this.getSite().getShell();
    }

    public void forceOutlineViewUpdate() {
        IDocument doc = this.getIDocument();
        if (doc == null) {
            return;
        }
        doc.set(" " + doc.get());
        this.doSave(null);
        doc.set(doc.get().substring(1));
        this.doSave(null);
    }
}

