/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client.listeners;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.client.CommandOutputListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.IMessagePatterns;
import org.eclipse.team.internal.ccvs.core.client.listeners.ServerMessageLineMatcher;

public class RDiffSummaryListener
extends CommandOutputListener {
    private static final String RIGHT_REVISION_VARIABLE_NAME = "rightRevision";
    private static final String LEFT_REVISION_VARIABLE_NAME = "leftRevision";
    private static final String REMOTE_FILE_PATH_VARIABLE_NAME = "remoteFilePath";
    private static final String REMOTE_FOLDER_PATH_VARIABLE_NAME = "remoteFolderPath";
    private IFileDiffListener listener;
    private static ServerMessageLineMatcher DIRECTORY_MATCHER;
    private static ServerMessageLineMatcher FILE_DIFF_MATCHER;
    private static ServerMessageLineMatcher NEW_FILE_MATCHER;
    private static ServerMessageLineMatcher DELETED_FILE_MATCHER;
    private static ServerMessageLineMatcher DELETED_FILE_MATCHER2;

    static {
        RDiffSummaryListener.initializePatterns();
    }

    public static void initializePatterns() {
        try {
            DIRECTORY_MATCHER = new ServerMessageLineMatcher(IMessagePatterns.RDIFF_DIRECTORY, new String[]{REMOTE_FOLDER_PATH_VARIABLE_NAME});
            FILE_DIFF_MATCHER = new ServerMessageLineMatcher(IMessagePatterns.RDIFF_SUMMARY_FILE_DIFF, new String[]{REMOTE_FILE_PATH_VARIABLE_NAME, LEFT_REVISION_VARIABLE_NAME, RIGHT_REVISION_VARIABLE_NAME});
            NEW_FILE_MATCHER = new ServerMessageLineMatcher(IMessagePatterns.RDIFF_SUMMARY_NEW_FILE, new String[]{REMOTE_FILE_PATH_VARIABLE_NAME, RIGHT_REVISION_VARIABLE_NAME});
            DELETED_FILE_MATCHER = new ServerMessageLineMatcher(IMessagePatterns.RDIFF_SUMMARY_DELETED_FILE, new String[]{REMOTE_FILE_PATH_VARIABLE_NAME});
            DELETED_FILE_MATCHER2 = new ServerMessageLineMatcher(IMessagePatterns.RDIFF_SUMMARY_DELETED_FILE2, new String[]{REMOTE_FILE_PATH_VARIABLE_NAME, LEFT_REVISION_VARIABLE_NAME});
        }
        catch (CVSException e) {
            CVSProviderPlugin.log((CoreException)((Object)e));
        }
    }

    public RDiffSummaryListener(IFileDiffListener listener) {
        this.listener = listener;
    }

    public IStatus messageLine(String line, ICVSRepositoryLocation location, ICVSFolder commandRoot, IProgressMonitor monitor) {
        Map variables = FILE_DIFF_MATCHER.processServerMessage(line);
        if (variables != null) {
            this.listener.fileDiff((String)variables.get(REMOTE_FILE_PATH_VARIABLE_NAME), (String)variables.get(LEFT_REVISION_VARIABLE_NAME), (String)variables.get(RIGHT_REVISION_VARIABLE_NAME));
            return OK;
        }
        variables = NEW_FILE_MATCHER.processServerMessage(line);
        if (variables != null) {
            this.listener.newFile((String)variables.get(REMOTE_FILE_PATH_VARIABLE_NAME), (String)variables.get(RIGHT_REVISION_VARIABLE_NAME));
            return OK;
        }
        variables = DELETED_FILE_MATCHER.processServerMessage(line);
        if (variables != null) {
            this.listener.deletedFile((String)variables.get(REMOTE_FILE_PATH_VARIABLE_NAME), null);
            return OK;
        }
        variables = DELETED_FILE_MATCHER2.processServerMessage(line);
        if (variables != null) {
            this.listener.deletedFile((String)variables.get(REMOTE_FILE_PATH_VARIABLE_NAME), (String)variables.get(LEFT_REVISION_VARIABLE_NAME));
            return OK;
        }
        return super.messageLine(line, location, commandRoot, monitor);
    }

    public IStatus errorLine(String line, ICVSRepositoryLocation location, ICVSFolder commandRoot, IProgressMonitor monitor) {
        Map variables = DIRECTORY_MATCHER.processServerMessage(line);
        if (variables != null) {
            this.listener.directory((String)variables.get(REMOTE_FOLDER_PATH_VARIABLE_NAME));
            return OK;
        }
        return super.errorLine(line, location, commandRoot, monitor);
    }

    public static interface IFileDiffListener {
        public void fileDiff(String var1, String var2, String var3);

        public void newFile(String var1, String var2);

        public void deletedFile(String var1, String var2);

        public void directory(String var1);
    }
}

