/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.internal.viewers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.internal.databinding.provisional.observable.Diffs;
import org.eclipse.jface.internal.databinding.provisional.observable.list.IObservableList;
import org.eclipse.jface.internal.databinding.provisional.observable.list.ListDiffEntry;
import org.eclipse.jface.internal.databinding.provisional.observable.list.ObservableList;
import org.eclipse.jface.internal.databinding.provisional.observable.mapping.IMultiMapping;
import org.eclipse.jface.internal.databinding.provisional.observable.set.IObservableSet;
import org.eclipse.jface.internal.databinding.provisional.observable.set.ISetChangeListener;
import org.eclipse.jface.internal.databinding.provisional.observable.set.SetDiff;
import org.eclipse.jface.internal.databinding.provisional.viewers.IObservableCollectionWithLabels;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;

public abstract class StructuredViewerObservableCollectionWithLabels
extends ObservableList
implements IObservableList,
IObservableSet,
IObservableCollectionWithLabels {
    private StructuredViewer structuredViewer;
    private ContentProvider contentProvider;
    private Object setChangeListeners;
    private Set elementsAsSet;
    static /* synthetic */ Class class$0;

    public StructuredViewerObservableCollectionWithLabels(StructuredViewer structuredViewer) {
        ArrayList arrayList = new ArrayList();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(arrayList, clazz);
        this.contentProvider = new ContentProvider();
        this.elementsAsSet = new HashSet();
        this.structuredViewer = structuredViewer;
        structuredViewer.setContentProvider((IContentProvider)this.contentProvider);
        structuredViewer.setInput((Object)this);
    }

    public abstract void init(IMultiMapping var1);

    public abstract void updateElements(Object[] var1);

    public void addSetChangeListener(ISetChangeListener listener) {
        ArrayList<ISetChangeListener> listenerList;
        if (this.setChangeListeners == null) {
            boolean hadListeners = this.hasListeners();
            this.setChangeListeners = listener;
            if (!hadListeners) {
                this.firstListenerAdded();
            }
            return;
        }
        if (this.setChangeListeners instanceof Collection) {
            listenerList = (ArrayList<ISetChangeListener>)this.setChangeListeners;
        } else {
            ISetChangeListener l = (ISetChangeListener)this.setChangeListeners;
            listenerList = new ArrayList<ISetChangeListener>();
            listenerList.add(l);
            this.setChangeListeners = listenerList;
        }
        if (listenerList.size() > 16) {
            HashSet<ISetChangeListener> listenerSet = new HashSet<ISetChangeListener>();
            listenerSet.addAll(listenerList);
            this.setChangeListeners = listenerList;
        }
        listenerList.add(listener);
    }

    public void removeSetChangeListener(ISetChangeListener listener) {
        if (this.setChangeListeners == listener) {
            this.setChangeListeners = null;
            if (!this.hasListeners()) {
                this.lastListenerRemoved();
            }
            return;
        }
        if (this.setChangeListeners instanceof Collection) {
            Collection listenerList = (Collection)this.setChangeListeners;
            listenerList.remove(listener);
            if (listenerList.size() == 0) {
                this.setChangeListeners = null;
                if (!this.hasListeners()) {
                    this.lastListenerRemoved();
                }
            }
        }
    }

    protected boolean hasListeners() {
        return super.hasListeners() || this.setChangeListeners != null;
    }

    protected void fireSetChange(SetDiff diff) {
        if (this.setChangeListeners == null) {
            return;
        }
        if (this.setChangeListeners instanceof ISetChangeListener) {
            ((ISetChangeListener)this.setChangeListeners).handleSetChange(this, diff);
            return;
        }
        Collection changeListenerCollection = (Collection)this.setChangeListeners;
        ISetChangeListener[] listeners = changeListenerCollection.toArray(new ISetChangeListener[changeListenerCollection.size()]);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].handleSetChange(this, diff);
            ++i;
        }
    }

    public boolean add(Object o) {
        boolean added = this.elementsAsSet.add(o);
        if (added) {
            this.wrappedList.add(o);
            this.fireListChange(Diffs.createListDiff(Diffs.createListDiffEntry(this.wrappedList.size() - 1, true, o)));
            this.fireSetChange(Diffs.createSetDiff(Collections.singleton(o), Collections.EMPTY_SET));
            this.addToViewer(o);
        }
        return added;
    }

    public boolean addAll(Collection c) {
        HashSet adds = new HashSet();
        ArrayList<ListDiffEntry> listAdds = new ArrayList<ListDiffEntry>();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            Object element = it.next();
            if (!this.elementsAsSet.add(element)) continue;
            listAdds.add(Diffs.createListDiffEntry(this.wrappedList.size(), true, element));
            this.wrappedList.add(element);
            adds.add(element);
        }
        if (adds.size() > 0) {
            this.fireListChange(Diffs.createListDiff(listAdds.toArray(new ListDiffEntry[listAdds.size()])));
            this.fireSetChange(Diffs.createSetDiff(adds, Collections.EMPTY_SET));
            this.addToViewer(adds.toArray());
            return true;
        }
        return false;
    }

    public boolean remove(Object o) {
        boolean removed = this.elementsAsSet.remove(o);
        if (removed) {
            int indexOfElement = this.wrappedList.indexOf(o);
            this.wrappedList.remove(indexOfElement);
            this.removeFromViewer(o);
            this.fireListChange(Diffs.createListDiff(Diffs.createListDiffEntry(indexOfElement, false, o)));
            this.fireSetChange(Diffs.createSetDiff(Collections.EMPTY_SET, Collections.singleton(o)));
        }
        return removed;
    }

    public boolean removeAll(Collection c) {
        HashSet removes = new HashSet();
        ArrayList<ListDiffEntry> listRemoves = new ArrayList<ListDiffEntry>();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            Object element = it.next();
            if (!this.elementsAsSet.remove(element)) continue;
            int indexOfElement = this.wrappedList.indexOf(element);
            this.wrappedList.remove(indexOfElement);
            listRemoves.add(Diffs.createListDiffEntry(indexOfElement, false, element));
            removes.add(element);
        }
        if (removes.size() > 0) {
            this.removeFromViewer(removes.toArray());
            this.fireListChange(Diffs.createListDiff(listRemoves.toArray(new ListDiffEntry[listRemoves.size()])));
            this.fireSetChange(Diffs.createSetDiff(Collections.EMPTY_SET, removes));
            return true;
        }
        return false;
    }

    public boolean retainAll(Collection c) {
        HashSet removes = new HashSet();
        ArrayList<ListDiffEntry> listRemoves = new ArrayList<ListDiffEntry>();
        Iterator it = this.wrappedList.iterator();
        int index = 0;
        while (it.hasNext()) {
            Object element = it.next();
            if (!c.contains(element)) {
                it.remove();
                this.elementsAsSet.remove(element);
                removes.add(element);
                listRemoves.add(Diffs.createListDiffEntry(index, false, element));
            }
            ++index;
        }
        if (removes.size() > 0) {
            this.removeFromViewer(removes.toArray());
            this.fireListChange(Diffs.createListDiff(listRemoves.toArray(new ListDiffEntry[listRemoves.size()])));
            this.fireSetChange(Diffs.createSetDiff(Collections.EMPTY_SET, removes));
            return true;
        }
        return false;
    }

    public void clear() {
        HashSet removes = new HashSet(this.elementsAsSet);
        ArrayList<ListDiffEntry> listRemoves = new ArrayList<ListDiffEntry>();
        Iterator it = this.wrappedList.iterator();
        int index = 0;
        while (it.hasNext()) {
            Object element = it.next();
            listRemoves.add(Diffs.createListDiffEntry(index, false, element));
            ++index;
        }
        this.wrappedList.clear();
        this.elementsAsSet.clear();
        this.structuredViewer.refresh();
        this.fireListChange(Diffs.createListDiff(listRemoves.toArray(new ListDiffEntry[listRemoves.size()])));
        this.fireSetChange(Diffs.createSetDiff(Collections.EMPTY_SET, removes));
    }

    public Object set(int index, Object element) {
        Object oldObject = this.wrappedList.get(index);
        this.elementsAsSet.remove(oldObject);
        this.removeFromViewer(oldObject);
        this.fireListChange(Diffs.createListDiff(Diffs.createListDiffEntry(index, false, oldObject)));
        this.fireSetChange(Diffs.createSetDiff(Collections.EMPTY_SET, Collections.singleton(oldObject)));
        if (this.elementsAsSet.add(element)) {
            this.wrappedList.add(index, element);
            this.fireListChange(Diffs.createListDiff(Diffs.createListDiffEntry(index, true, element)));
            this.fireSetChange(Diffs.createSetDiff(Collections.singleton(element), Collections.EMPTY_SET));
            this.addToViewer(index, element);
        }
        return oldObject;
    }

    public Object remove(int index) {
        Object oldObject = this.wrappedList.remove(index);
        this.elementsAsSet.remove(oldObject);
        this.removeFromViewer(oldObject);
        this.fireListChange(Diffs.createListDiff(Diffs.createListDiffEntry(index, false, oldObject)));
        this.fireSetChange(Diffs.createSetDiff(Collections.EMPTY_SET, Collections.singleton(oldObject)));
        return oldObject;
    }

    public void add(int index, Object element) {
        if (this.elementsAsSet.add(element)) {
            this.wrappedList.add(index, element);
            this.fireListChange(Diffs.createListDiff(Diffs.createListDiffEntry(index, true, element)));
            this.fireSetChange(Diffs.createSetDiff(Collections.singleton(element), Collections.EMPTY_SET));
            this.addToViewer(index, element);
        }
    }

    public boolean addAll(int index, Collection c) {
        HashSet adds = new HashSet();
        ArrayList<ListDiffEntry> listAdds = new ArrayList<ListDiffEntry>();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            Object element = it.next();
            if (!this.elementsAsSet.add(element)) continue;
            listAdds.add(Diffs.createListDiffEntry(index, true, element));
            this.wrappedList.add(index, element);
            adds.add(element);
            this.addToViewer(index, element);
            ++index;
        }
        if (adds.size() > 0) {
            this.fireListChange(Diffs.createListDiff(listAdds.toArray(new ListDiffEntry[listAdds.size()])));
            this.fireSetChange(Diffs.createSetDiff(adds, Collections.EMPTY_SET));
            return true;
        }
        return false;
    }

    public void dispose() {
        super.dispose();
        this.wrappedList.clear();
        this.structuredViewer = null;
        this.contentProvider = null;
    }

    protected abstract void addToViewer(Object var1);

    protected abstract void addToViewer(Object[] var1);

    protected abstract void addToViewer(int var1, Object var2);

    protected abstract void removeFromViewer(Object var1);

    protected abstract void removeFromViewer(Object[] var1);

    public StructuredViewer getViewer() {
        return this.structuredViewer;
    }

    private class ContentProvider
    implements IStructuredContentProvider {
        private ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return StructuredViewerObservableCollectionWithLabels.this.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

