/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ptp.debug.core.IAbstractDebugger;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIEvent;

public class EventThread {
    private List fEventQueue = new ArrayList();
    private EventDispatchJob dispatchJob = new EventDispatchJob();
    IAbstractDebugger dbg;

    public EventThread(IAbstractDebugger dbg) {
        this.dbg = dbg;
    }

    public void cancelJob() {
        this.dispatchJob.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireDebugEvent(IPCDIEvent event) {
        List list = this.fEventQueue;
        synchronized (list) {
            this.fEventQueue.add(event);
        }
        this.dispatchJob.schedule();
    }

    class EventDispatchJob
    extends Job {
        public EventDispatchJob() {
            super("EventDispatchJob");
            this.setPriority(10);
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            while (!EventThread.this.dbg.isExited() && !EventThread.this.fEventQueue.isEmpty()) {
                IPCDIEvent event = null;
                List list = EventThread.this.fEventQueue;
                synchronized (list) {
                    if (!EventThread.this.fEventQueue.isEmpty()) {
                        event = (IPCDIEvent)EventThread.this.fEventQueue.remove(0);
                    }
                }
                if (event == null) continue;
                EventThread.this.dbg.notifyObservers((Object)event);
            }
            return Status.OK_STATUS;
        }
    }
}

