/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IFlushableStreamMonitor;
import org.eclipse.debug.core.model.IStreamMonitor;

public class POutputStreamMonitor
implements IFlushableStreamMonitor {
    private InputStream fStream;
    private List fListeners = new ArrayList(1);
    private boolean fBuffered = true;
    private StringBuffer fContents;
    private Thread fThread;
    private static final int BUFFER_SIZE = 8192;
    private boolean fKilled = false;
    private long lastSleep;

    public POutputStreamMonitor(InputStream stream) {
        this.fStream = new BufferedInputStream(stream, 8192);
        this.fContents = new StringBuffer();
    }

    public synchronized void addListener(IStreamListener listener) {
        this.fListeners.add(listener);
    }

    protected void close() {
        if (this.fThread != null) {
            Thread thread = this.fThread;
            this.fThread = null;
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {}
            this.fListeners.clear();
        }
    }

    private void fireStreamAppended(String text) {
        this.getNotifier().notifyAppend(text);
    }

    public synchronized String getContents() {
        return this.fContents.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read() {
        long currentTime = this.lastSleep = System.currentTimeMillis();
        byte[] bytes = new byte[8192];
        int read = 0;
        while (read >= 0) {
            block13: {
                try {
                    if (this.fKilled) break;
                    read = this.fStream.read(bytes);
                    if (read <= 0) break block13;
                    String text = new String(bytes, 0, read);
                    POutputStreamMonitor pOutputStreamMonitor = this;
                    synchronized (pOutputStreamMonitor) {
                        if (this.isBuffered()) {
                            this.fContents.append(text);
                        }
                        this.fireStreamAppended(text);
                    }
                }
                catch (IOException ioe) {
                    DebugPlugin.log((Throwable)ioe);
                    return;
                }
                catch (NullPointerException e) {
                    if (!this.fKilled && this.fThread != null) {
                        DebugPlugin.log((Throwable)e);
                    }
                    return;
                }
            }
            if ((currentTime = System.currentTimeMillis()) - this.lastSleep <= 1000L) continue;
            this.lastSleep = currentTime;
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        try {
            this.fStream.close();
        }
        catch (IOException e) {
            DebugPlugin.log((Throwable)e);
        }
    }

    protected void kill() {
        this.fKilled = true;
    }

    public synchronized void removeListener(IStreamListener listener) {
        this.fListeners.remove(listener);
    }

    protected void startMonitoring() {
        if (this.fThread == null) {
            this.fThread = new Thread(new Runnable(){

                public void run() {
                    POutputStreamMonitor.this.read();
                }
            }, "Output Stream Monitor");
            this.fThread.setDaemon(true);
            this.fThread.setPriority(1);
            this.fThread.start();
        }
    }

    public synchronized void setBuffered(boolean buffer) {
        this.fBuffered = buffer;
    }

    public synchronized void flushContents() {
        this.fContents.setLength(0);
    }

    public synchronized boolean isBuffered() {
        return this.fBuffered;
    }

    private ContentNotifier getNotifier() {
        return new ContentNotifier();
    }

    class ContentNotifier
    implements ISafeRunnable {
        private IStreamListener fListener;
        private String fText;

        ContentNotifier() {
        }

        public void handleException(Throwable exception) {
            DebugPlugin.log((Throwable)exception);
        }

        public void run() throws Exception {
            this.fListener.streamAppended(this.fText, (IStreamMonitor)POutputStreamMonitor.this);
        }

        public void notifyAppend(String text) {
            if (text == null) {
                return;
            }
            this.fText = text;
            for (IStreamListener this.fListener : POutputStreamMonitor.this.fListeners) {
                Platform.run((ISafeRunnable)this);
            }
            this.fListener = null;
            this.fText = null;
        }
    }
}

