/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.ptp.core.IPProcess;
import org.eclipse.ptp.core.IProcessListener;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.events.IProcessEvent;
import org.eclipse.ptp.debug.core.IAbstractDebugger;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.core.launch.IPLaunch;
import org.eclipse.ptp.debug.core.model.IPseudoProcess;
import org.eclipse.ptp.debug.external.core.PStreamsProxy;
import org.eclipse.ptp.debug.external.core.PseudoInputStream;
import org.eclipse.ptp.debug.external.core.PseudoOutputStream;

public class PseudoProcess
implements IProcessListener,
IPseudoProcess {
    private final String PROCESS_NAME = "Process ";
    private static final int MAX_WAIT_FOR_DEATH_ATTEMPTS = 10;
    private static final int TIME_TO_WAIT_FOR_THREAD_DEATH = 500;
    private IPLaunch launch;
    private int fExitValue;
    private IStreamsProxy fStreamsProxy;
    private boolean fTerminated;
    private Map fAttributes;
    private boolean finished = false;
    private InputStream err = null;
    private InputStream in = null;
    private OutputStream out = null;
    private IPProcess pproc = null;
    private IAbstractDebugger debugger = null;

    public PseudoProcess(IAbstractDebugger debugger, IPProcess pproc, IPLaunch launch, Map attributes) {
        this.debugger = debugger;
        this.pproc = pproc;
        this.launch = launch;
        this.init(attributes);
    }

    private void init(Map attributes) {
        this.finished = false;
        this.err = null;
        this.in = new PseudoInputStream();
        this.out = new PseudoOutputStream();
        PTPCorePlugin.getDefault().getModelPresentation().addProcessListener((IProcessListener)this);
        this.initializeAttributes(attributes);
        this.fTerminated = true;
        try {
            this.exitValue();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            this.fTerminated = false;
        }
        this.fStreamsProxy = new PStreamsProxy(this.getInputStream(), this.getErrorStream(), this.getOutputStream());
        this.launch.addProcess((IProcess)this);
        this.fireCreationEvent();
    }

    public int exitValue() {
        if (this.finished) {
            return 0;
        }
        throw new IllegalThreadStateException();
    }

    public void destroy() {
        this.finished = true;
        PTPCorePlugin.getDefault().getModelPresentation().removeProcessListener((IProcessListener)this);
        ((PseudoInputStream)this.in).destroy();
        try {
            ((PseudoInputStream)this.in).close();
            ((PseudoOutputStream)this.out).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public InputStream getErrorStream() {
        return this.err;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public void processEvent(IProcessEvent event) {
        if (event.getProcess().equals(this.pproc)) {
            switch (event.getType()) {
                case 1: {
                    this.destroy();
                    break;
                }
                case 3: {
                    ((PseudoInputStream)this.in).printString(event.getInput());
                }
            }
        }
    }

    public void kill() throws DebugException {
    }

    public int getTargetID() {
        return this.pproc.getTaskId();
    }

    private void initializeAttributes(Map attributes) {
        if (attributes != null) {
            for (String key : attributes.keySet()) {
                this.setAttribute(key, (String)attributes.get(key));
            }
        }
    }

    public String getAttribute(String key) {
        if (this.fAttributes == null) {
            return null;
        }
        return (String)this.fAttributes.get(key);
    }

    public int getExitValue() throws DebugException {
        if (this.isTerminated()) {
            return this.fExitValue;
        }
        throw new DebugException((IStatus)new Status(4, PTPDebugCorePlugin.getUniqueIdentifier(), 4, "Exit value not available", null));
    }

    public String getLabel() {
        return "Process " + this.getTargetID();
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public IStreamsProxy getStreamsProxy() {
        return this.fStreamsProxy;
    }

    protected void fireCreationEvent() {
        this.fireEvent(new DebugEvent((Object)this, 4));
    }

    protected void fireEvent(DebugEvent event) {
        DebugPlugin manager = DebugPlugin.getDefault();
        if (manager != null) {
            manager.fireDebugEventSet(new DebugEvent[]{event});
        }
    }

    protected void fireTerminateEvent() {
        this.fireEvent(new DebugEvent((Object)this, 8));
    }

    protected void fireChangeEvent() {
        this.fireEvent(new DebugEvent((Object)this, 16));
    }

    public void setAttribute(String key, String value) {
        Object origVal;
        if (this.fAttributes == null) {
            this.fAttributes = new HashMap(5);
        }
        if ((origVal = this.fAttributes.get(key)) != null && origVal.equals(value)) {
            return;
        }
        this.fAttributes.put(key, value);
        this.fireChangeEvent();
    }

    public boolean canTerminate() {
        return !this.fTerminated;
    }

    public boolean isTerminated() {
        return this.fTerminated;
    }

    public void terminate() throws DebugException {
        if (!this.isTerminated()) {
            if (this.fStreamsProxy instanceof PStreamsProxy) {
                ((PStreamsProxy)this.fStreamsProxy).kill();
            }
            this.kill();
            int attempts = 0;
            while (attempts < 10) {
                try {
                    this.fExitValue = this.exitValue();
                    return;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                    ++attempts;
                }
            }
            throw new DebugException((IStatus)new Status(4, PTPDebugCorePlugin.getUniqueIdentifier(), 4, "Pseudo process termiante failed", null));
        }
    }

    protected void terminated() {
        if (this.fStreamsProxy instanceof PStreamsProxy) {
            ((PStreamsProxy)this.fStreamsProxy).close();
        }
        this.fTerminated = true;
        try {
            this.fExitValue = this.exitValue();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {}
        this.fireTerminateEvent();
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IProcess.class)) {
            return this;
        }
        if (adapter.equals(IDebugTarget.class)) {
            return ((IPLaunch)this.getLaunch()).getDebugTarget(this.getTargetID());
        }
        return null;
    }
}

