/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core.cdi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.core.cdi.IPCDIBreakpointHit;
import org.eclipse.ptp.debug.core.cdi.IPCDIEndSteppingRange;
import org.eclipse.ptp.debug.core.cdi.IPCDIErrorInfo;
import org.eclipse.ptp.debug.core.cdi.IPCDIEventManager;
import org.eclipse.ptp.debug.core.cdi.IPCDIInferiorSignaled;
import org.eclipse.ptp.debug.core.cdi.IPCDILineLocation;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIChangedEvent;
import org.eclipse.ptp.debug.core.cdi.event.IPCDICreatedEvent;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIDebugDestroyedEvent;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIDestroyedEvent;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIErrorEvent;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIEvent;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIEventListener;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIResumedEvent;
import org.eclipse.ptp.debug.core.cdi.event.IPCDISuspendedEvent;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIBreakpoint;
import org.eclipse.ptp.debug.core.cdi.model.IPCDILocationBreakpoint;
import org.eclipse.ptp.debug.core.cdi.model.IPCDILocator;
import org.eclipse.ptp.debug.core.events.IPDebugEvent;
import org.eclipse.ptp.debug.core.events.IPDebugInfo;
import org.eclipse.ptp.debug.core.events.PDebugErrorInfo;
import org.eclipse.ptp.debug.core.events.PDebugEvent;
import org.eclipse.ptp.debug.core.events.PDebugInfo;
import org.eclipse.ptp.debug.core.events.PDebugSuspendInfo;
import org.eclipse.ptp.debug.external.core.PTPDebugExternalPlugin;
import org.eclipse.ptp.debug.external.core.cdi.Session;
import org.eclipse.ptp.debug.external.core.cdi.SessionObject;
import org.eclipse.ptp.debug.external.core.cdi.SignalManager;
import org.eclipse.ptp.debug.external.core.cdi.VariableManager;
import org.eclipse.ptp.debug.external.core.cdi.event.BreakpointHitEvent;
import org.eclipse.ptp.debug.external.core.cdi.event.EndSteppingRangeEvent;
import org.eclipse.ptp.debug.external.core.cdi.model.Target;
import org.eclipse.ptp.debug.external.core.cdi.model.Thread;

public class EventManager
extends SessionObject
implements IPCDIEventManager,
Observer {
    List list = Collections.synchronizedList(new ArrayList());
    protected final Object lock = new Object();

    public EventManager(Session session) {
        super(session);
    }

    public void shutdown() {
        this.list.clear();
    }

    public void update(Observable o, Object arg) {
        IPCDIEvent event = (IPCDIEvent)arg;
        this.fireDebugEvent(event);
        this.fireEventRegistered(event);
    }

    private void fireEventRegistered(final IPCDIEvent event) {
        Job aJob = new Job("Updating registered process..."){

            protected IStatus run(IProgressMonitor monitor) {
                int[] procs = event.getAllRegisteredProcesses().toArray();
                if (procs.length == 0) {
                    monitor.done();
                    return Status.OK_STATUS;
                }
                if (event instanceof IPCDISuspendedEvent) {
                    EventManager.this.processSuspendedEvent((IPCDISuspendedEvent)event, procs, monitor);
                } else if (event instanceof IPCDIResumedEvent) {
                    EventManager.this.processRunningEvent((IPCDIResumedEvent)event, procs, monitor);
                }
                EventManager.this.fireEvents(new IPCDIEvent[]{event});
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        aJob.setSystem(true);
        aJob.setPriority(10);
        aJob.schedule();
    }

    public void addEventListener(IPCDIEventListener listener) {
        this.list.add(listener);
    }

    public void removeEventListener(IPCDIEventListener listener) {
        this.list.remove(listener);
    }

    public void removeEventListeners() {
        this.list.clear();
    }

    public synchronized void fireEvents(IPCDIEvent[] cdiEvents) {
        if (cdiEvents != null && cdiEvents.length > 0) {
            IPCDIEventListener[] listeners = this.list.toArray(new IPCDIEventListener[0]);
            int i = 0;
            while (i < listeners.length) {
                listeners[i].handleDebugEvents(cdiEvents);
                ++i;
            }
        }
    }

    boolean processSuspendedEvent(IPCDISuspendedEvent event, int[] procs, IProgressMonitor monitor) {
        monitor.beginTask("Suspending registered process...", procs.length);
        Session session = (Session)this.getSession();
        SignalManager sigMgr = session.getSignalManager();
        VariableManager varMgr = session.getVariableManager();
        int i = 0;
        while (i < procs.length) {
            try {
                Target currentTarget = (Target)session.getTarget(procs[i]);
                currentTarget.setSupended(true);
                currentTarget.updateState(event.getThreadId());
                try {
                    Thread cthread = (Thread)currentTarget.getCurrentThread();
                    if (cthread != null) {
                        cthread.getCurrentStackFrame();
                    }
                    if (sigMgr.isAutoUpdate()) {
                        sigMgr.update(currentTarget);
                    }
                    if (varMgr.isAutoUpdate()) {
                        varMgr.update(currentTarget, event.getVarChanges());
                    }
                }
                catch (PCDIException e) {
                    PTPDebugExternalPlugin.log(e);
                }
            }
            finally {
                monitor.worked(1);
            }
            ++i;
        }
        monitor.done();
        return true;
    }

    boolean processRunningEvent(IPCDIResumedEvent event, int[] procs, IProgressMonitor monitor) {
        monitor.beginTask("Resuming registered process...", procs.length);
        Session session = (Session)this.getSession();
        int i = 0;
        while (i < procs.length) {
            try {
                Target currentTarget = (Target)session.getTarget(procs[i]);
                currentTarget.setSupended(false);
            }
            finally {
                monitor.worked(1);
            }
            ++i;
        }
        monitor.done();
        return true;
    }

    protected IPDebugInfo getDebugInfo(IPCDIEvent event) {
        return new PDebugInfo(event.getDebugJob(), event.getAllProcesses(), event.getAllRegisteredProcesses(), event.getAllUnregisteredProcesses());
    }

    protected void fireDebugEvent(IPCDIEvent event) {
        if (event instanceof IPCDISuspendedEvent) {
            this.fireSuspendEvent((IPCDISuspendedEvent)event);
        } else if (event instanceof IPCDIResumedEvent) {
            this.fireResumeEvent((IPCDIResumedEvent)event);
        } else if (event instanceof IPCDIDebugDestroyedEvent) {
            this.fireDestroyEvent((IPCDIDestroyedEvent)event, 1024);
            this.getSession().shutdown();
        } else if (event instanceof IPCDIDestroyedEvent) {
            this.fireDestroyEvent((IPCDIDestroyedEvent)event, 0);
        } else if (event instanceof IPCDIErrorEvent) {
            this.fireErrorEvent((IPCDIErrorEvent)event);
        } else if (event instanceof IPCDICreatedEvent) {
            this.fireCreateEvent((IPCDICreatedEvent)event);
        } else if (event instanceof IPCDIChangedEvent) {
            this.fireChangeEvent((IPCDIChangedEvent)event);
        }
    }

    public void fireSuspendEvent(IPCDISuspendedEvent event) {
        IPDebugInfo baseInfo = this.getDebugInfo((IPCDIEvent)event);
        int detail = 0;
        int lineNumber = 0;
        String fileName = "";
        if (event instanceof BreakpointHitEvent) {
            IPCDIBreakpoint bpt = ((IPCDIBreakpointHit)event.getReason()).getBreakpoint();
            if (bpt instanceof IPCDILocationBreakpoint) {
                IPCDILocator locator = ((IPCDILocationBreakpoint)bpt).getLocator();
                lineNumber = locator.getLineNumber();
                fileName = String.valueOf(fileName) + locator.getFile();
            }
            detail = 16;
        } else if (event instanceof EndSteppingRangeEvent) {
            IPCDILineLocation lineLocation = ((IPCDIEndSteppingRange)event.getReason()).getLineLocation();
            if (lineLocation != null) {
                lineNumber = lineLocation.getLineNumber();
                fileName = String.valueOf(fileName) + lineLocation.getFile();
            }
            detail = 8;
        } else {
            IPCDILocator locator = ((IPCDIInferiorSignaled)event.getReason()).getLocator();
            if (locator != null) {
                lineNumber = locator.getLineNumber();
                fileName = String.valueOf(fileName) + locator.getFile();
            }
            detail = 0;
        }
        if (lineNumber == 0) {
            lineNumber = 1;
        }
        PTPDebugCorePlugin.getDefault().fireDebugEvent((IPDebugEvent)new PDebugEvent((Object)this.getSession(), 2, detail, (IPDebugInfo)new PDebugSuspendInfo(baseInfo, fileName, lineNumber)));
    }

    public void fireResumeEvent(IPCDIResumedEvent event) {
        IPDebugInfo baseInfo = this.getDebugInfo((IPCDIEvent)event);
        int detail = 0;
        switch (event.getType()) {
            case 2: 
            case 4: {
                detail = 1;
                break;
            }
            case 1: 
            case 3: {
                detail = 2;
                break;
            }
            case 5: {
                detail = 4;
            }
        }
        PTPDebugCorePlugin.getDefault().fireDebugEvent((IPDebugEvent)new PDebugEvent((Object)this.getSession(), 1, detail, baseInfo));
    }

    public void fireDestroyEvent(IPCDIDestroyedEvent event, int detail) {
        IPDebugInfo baseInfo = this.getDebugInfo((IPCDIEvent)event);
        PTPDebugCorePlugin.getDefault().fireDebugEvent((IPDebugEvent)new PDebugEvent((Object)this.getSession(), 8, detail, baseInfo));
    }

    public void fireErrorEvent(IPCDIErrorEvent event) {
        IPDebugInfo baseInfo = this.getDebugInfo((IPCDIEvent)event);
        int detail = 0;
        switch (event.getErrorCode()) {
            case 0: {
                detail = 1;
                break;
            }
            case 1: {
                detail = 2;
                break;
            }
            case 2: {
                detail = 4;
            }
        }
        IPCDIErrorInfo errInfo = (IPCDIErrorInfo)event.getReason();
        PTPDebugCorePlugin.getDefault().fireDebugEvent((IPDebugEvent)new PDebugEvent((Object)this.getSession(), 64, detail, (IPDebugInfo)new PDebugErrorInfo(baseInfo, errInfo.getMessage(), errInfo.getDetailMessage())));
    }

    public void fireChangeEvent(IPCDIChangedEvent event) {
        IPDebugInfo baseInfo = this.getDebugInfo((IPCDIEvent)event);
        int detail = 0;
        PTPDebugCorePlugin.getDefault().fireDebugEvent((IPDebugEvent)new PDebugEvent((Object)this.getSession(), 16, detail, baseInfo));
    }

    public void fireCreateEvent(IPCDICreatedEvent event) {
        IPDebugInfo baseInfo = this.getDebugInfo((IPCDIEvent)event);
        int detail = 0;
        PTPDebugCorePlugin.getDefault().fireDebugEvent((IPDebugEvent)new PDebugEvent((Object)this.getSession(), 4, detail, baseInfo));
    }
}

