/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core.cdi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.ptp.debug.core.IDebugCommand;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIEvent;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIArgumentDescriptor;
import org.eclipse.ptp.debug.core.cdi.model.IPCDILocalVariableDescriptor;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIStackFrame;
import org.eclipse.ptp.debug.core.cdi.model.IPCDITarget;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIThread;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIThreadStorageDescriptor;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIVariable;
import org.eclipse.ptp.debug.external.core.cdi.Manager;
import org.eclipse.ptp.debug.external.core.cdi.Session;
import org.eclipse.ptp.debug.external.core.cdi.event.VarChangedEvent;
import org.eclipse.ptp.debug.external.core.cdi.model.StackFrame;
import org.eclipse.ptp.debug.external.core.cdi.model.Target;
import org.eclipse.ptp.debug.external.core.cdi.model.Thread;
import org.eclipse.ptp.debug.external.core.cdi.model.variable.Argument;
import org.eclipse.ptp.debug.external.core.cdi.model.variable.ArgumentDescriptor;
import org.eclipse.ptp.debug.external.core.cdi.model.variable.GlobalVariable;
import org.eclipse.ptp.debug.external.core.cdi.model.variable.GlobalVariableDescriptor;
import org.eclipse.ptp.debug.external.core.cdi.model.variable.LocalVariable;
import org.eclipse.ptp.debug.external.core.cdi.model.variable.LocalVariableDescriptor;
import org.eclipse.ptp.debug.external.core.cdi.model.variable.ThreadStorage;
import org.eclipse.ptp.debug.external.core.cdi.model.variable.ThreadStorageDescriptor;
import org.eclipse.ptp.debug.external.core.cdi.model.variable.Variable;
import org.eclipse.ptp.debug.external.core.cdi.model.variable.VariableDescriptor;
import org.eclipse.ptp.debug.external.core.commands.ListArgumentsCommand;
import org.eclipse.ptp.debug.external.core.commands.ListLocalVariablesCommand;
import org.eclipse.ptp.debug.external.core.commands.VariableDeleteCommand;

public class VariableManager
extends Manager {
    static final IPCDIVariable[] EMPTY_VARIABLES = new IPCDIVariable[0];
    int MAX_STACK_DEPTH = 200;
    private Map variablesMap = new Hashtable();

    public VariableManager(Session session) {
        super(session, true);
    }

    public void shutdown() {
        this.variablesMap.clear();
    }

    synchronized List getVariablesList(Target target) {
        List variablesList = (List)this.variablesMap.get(target);
        if (variablesList == null) {
            variablesList = Collections.synchronizedList(new ArrayList());
            this.variablesMap.put(target, variablesList);
        }
        return variablesList;
    }

    public Variable getVariable(int task_id, String name) {
        IPCDITarget target = ((Session)this.getSession()).getTarget(task_id);
        return this.getVariable(target, name);
    }

    public Variable getVariable(IPCDITarget target, String name) {
        Variable[] vars = this.getVariables(target);
        int i = 0;
        while (i < vars.length) {
            Variable var = vars[i];
            try {
                if (name.equals(var.getKeyName())) {
                    return var;
                }
                Variable v = var.getChild(name);
                if (v != null) {
                    return v;
                }
            }
            catch (PCDIException pCDIException) {}
            ++i;
        }
        return null;
    }

    Variable findVariable(VariableDescriptor v) throws PCDIException {
        Target target = (Target)v.getTarget();
        IPCDIStackFrame vstack = v.getStackFrame();
        IPCDIThread vthread = v.getThread();
        String name = v.getName();
        int position = v.getPosition();
        int depth = v.getStackDepth();
        Variable[] vars = this.getVariables(target);
        int i = 0;
        while (i < vars.length) {
            if (vars[i].getName().equals(name) && vars[i].getCastingArrayStart() == v.getCastingArrayStart() && vars[i].getCastingArrayEnd() == v.getCastingArrayEnd() && VariableDescriptor.equalsCasting(vars[i], v)) {
                IPCDIThread thread = vars[i].getThread();
                if (vthread == null && thread == null || vthread != null && thread != null && thread.equals(vthread)) {
                    IPCDIStackFrame frame = vars[i].getStackFrame();
                    if (vstack == null && frame == null) {
                        return vars[i];
                    }
                    if (frame != null && vstack != null && frame.equals(vstack) && vars[i].getPosition() == position && vars[i].getStackDepth() == depth) {
                        return vars[i];
                    }
                }
            }
            ++i;
        }
        return null;
    }

    Variable[] getVariables(IPCDITarget target) {
        List variableList = (List)this.variablesMap.get(target);
        if (variableList != null) {
            return variableList.toArray(new Variable[variableList.size()]);
        }
        return new Variable[0];
    }

    public void checkType(StackFrame frame, String type) throws PCDIException {
        if (type != null && type.length() > 0) {
            Target target = (Target)frame.getTarget();
            Thread currentThread = (Thread)target.getCurrentThread();
            StackFrame currentFrame = currentThread.getCurrentStackFrame();
            target.setCurrentThread(frame.getThread(), false);
            ((Thread)frame.getThread()).setCurrentStackFrame(frame, false);
            try {
                throw new PCDIException("Not implemented yet - VariableManager: checkType");
            }
            catch (Throwable throwable) {
                target.setCurrentThread(currentThread, false);
                currentThread.setCurrentStackFrame(currentFrame, false);
                throw throwable;
            }
        }
        throw new PCDIException("VariableManager Unknown_type");
    }

    void removeKeyVar(Target target, String keyName) throws PCDIException {
        VariableDeleteCommand command = new VariableDeleteCommand(target.getTask(), keyName);
        target.getDebugger().postCommand((IDebugCommand)command);
        command.waitForReturn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Variable removeVariableFromList(Target target, String varName) {
        List varList;
        List list = varList = this.getVariablesList(target);
        synchronized (list) {
            Iterator iterator = varList.iterator();
            while (iterator.hasNext()) {
                Variable variable = (Variable)iterator.next();
                try {
                    if (!variable.getKeyName().equals(varName)) continue;
                    iterator.remove();
                    return variable;
                }
                catch (PCDIException pCDIException) {}
            }
        }
        return null;
    }

    public VariableDescriptor getVariableDescriptorAsArray(VariableDescriptor varDesc, int start, int length) throws PCDIException {
        Target target = (Target)varDesc.getTarget();
        Thread thread = (Thread)varDesc.getThread();
        StackFrame frame = (StackFrame)varDesc.getStackFrame();
        String name = varDesc.getName();
        String fullName = varDesc.getFullName();
        int pos = varDesc.getPosition();
        int depth = varDesc.getStackDepth();
        VariableDescriptor vo = null;
        if (varDesc instanceof ArgumentDescriptor || varDesc instanceof Argument) {
            vo = new ArgumentDescriptor(target, thread, frame, name, fullName, pos, depth);
        } else if (varDesc instanceof LocalVariableDescriptor || varDesc instanceof LocalVariable) {
            vo = new LocalVariableDescriptor(target, thread, frame, name, fullName, pos, depth);
        } else if (varDesc instanceof GlobalVariableDescriptor || varDesc instanceof GlobalVariable) {
            vo = new GlobalVariableDescriptor(target, thread, frame, name, fullName, pos, depth);
        } else if (varDesc instanceof ThreadStorageDescriptor || varDesc instanceof ThreadStorage) {
            vo = new ThreadStorageDescriptor(target, thread, frame, name, fullName, pos, depth);
        } else {
            throw new PCDIException("VariableManager.Unknown_variable_object");
        }
        vo.setCastingArrayStart(varDesc.getCastingArrayStart() + start);
        vo.setCastingArrayEnd(length);
        return vo;
    }

    public VariableDescriptor getVariableDescriptorAsType(VariableDescriptor varDesc, String type) throws PCDIException {
        Target target = (Target)varDesc.getTarget();
        Thread thread = (Thread)varDesc.getThread();
        StackFrame frame = (StackFrame)varDesc.getStackFrame();
        String name = varDesc.getName();
        String fullName = varDesc.getFullName();
        int pos = varDesc.getPosition();
        int depth = varDesc.getStackDepth();
        StackFrame f = frame;
        if (f == null) {
            if (thread != null) {
                f = thread.getCurrentStackFrame();
            } else {
                Thread t = (Thread)target.getCurrentThread();
                f = t.getCurrentStackFrame();
            }
        }
        this.checkType(f, type);
        VariableDescriptor vo = null;
        if (varDesc instanceof ArgumentDescriptor || varDesc instanceof Argument) {
            vo = new ArgumentDescriptor(target, thread, frame, name, fullName, pos, depth);
        } else if (varDesc instanceof LocalVariableDescriptor || varDesc instanceof LocalVariable) {
            vo = new LocalVariableDescriptor(target, thread, frame, name, fullName, pos, depth);
        } else if (varDesc instanceof GlobalVariableDescriptor || varDesc instanceof GlobalVariable) {
            vo = new GlobalVariableDescriptor(target, thread, frame, name, fullName, pos, depth);
        } else if (varDesc instanceof ThreadStorageDescriptor || varDesc instanceof ThreadStorage) {
            vo = new ThreadStorageDescriptor(target, thread, frame, name, fullName, pos, depth);
        } else {
            throw new PCDIException("VariableManager.Unknown_variable_object");
        }
        String[] castings = varDesc.getCastingTypes();
        if (castings == null) {
            castings = new String[]{type};
        } else {
            String[] temp = new String[castings.length + 1];
            System.arraycopy(castings, 0, temp, 0, castings.length);
            temp[castings.length] = type;
            castings = temp;
        }
        vo.setCastingTypes(castings);
        return vo;
    }

    public Variable createVariable(VariableDescriptor varDesc) throws PCDIException {
        if (varDesc instanceof ArgumentDescriptor) {
            return this.createArgument((ArgumentDescriptor)varDesc);
        }
        if (varDesc instanceof LocalVariableDescriptor) {
            return this.createLocalVariable((LocalVariableDescriptor)varDesc);
        }
        if (varDesc instanceof GlobalVariableDescriptor) {
            return this.createGlobalVariable((GlobalVariableDescriptor)varDesc);
        }
        if (varDesc instanceof ThreadStorageDescriptor) {
            return this.createThreadStorage((ThreadStorageDescriptor)varDesc);
        }
        throw new PCDIException("VariableManager.Unknown_variable_object");
    }

    public Argument createArgument(ArgumentDescriptor argDesc) throws PCDIException {
        Variable variable = this.findVariable(argDesc);
        Argument argument = null;
        if (variable != null && variable instanceof Argument) {
            argument = (Argument)variable;
        }
        if (argument == null) {
            StackFrame stack = (StackFrame)argDesc.getStackFrame();
            Target target = (Target)argDesc.getTarget();
            Thread currentThread = (Thread)target.getCurrentThread();
            StackFrame currentFrame = currentThread.getCurrentStackFrame();
            target.setCurrentThread(stack.getThread(), false);
            ((Thread)stack.getThread()).setCurrentStackFrame(stack, false);
            try {
                argument = new Argument(argDesc);
                List variablesList = this.getVariablesList(target);
                if (!variablesList.contains(argument)) {
                    variablesList.add(argument);
                }
            }
            finally {
                target.setCurrentThread(currentThread, false);
                currentThread.setCurrentStackFrame(currentFrame, false);
            }
        }
        return argument;
    }

    public IPCDIArgumentDescriptor[] getArgumentDescriptors(StackFrame frame) throws PCDIException {
        ArrayList<ArgumentDescriptor> argObjects = new ArrayList<ArgumentDescriptor>();
        Target target = (Target)frame.getTarget();
        Thread currentThread = (Thread)target.getCurrentThread();
        StackFrame currentFrame = currentThread.getCurrentStackFrame();
        target.setCurrentThread(frame.getThread(), false);
        ((Thread)frame.getThread()).setCurrentStackFrame(frame, false);
        try {
            int depth = frame.getThread().getStackFrameCount();
            int level = frame.getLevel();
            int diff = depth - level;
            ListArgumentsCommand argCmd = new ListArgumentsCommand(target.getTask(), diff, diff);
            target.getDebugger().postCommand((IDebugCommand)argCmd);
            String[] args = argCmd.getArguments();
            if (args != null) {
                int i = 0;
                while (i < args.length) {
                    ArgumentDescriptor argDesc = new ArgumentDescriptor(target, null, frame, args[i], null, args.length - i, level);
                    argObjects.add(argDesc);
                    ++i;
                }
            }
        }
        finally {
            target.setCurrentThread(currentThread, false);
            currentThread.setCurrentStackFrame(currentFrame, false);
        }
        return argObjects.toArray(new IPCDIArgumentDescriptor[0]);
    }

    public GlobalVariableDescriptor getGlobalVariableDescriptor(Target target, String filename, String function, String name) throws PCDIException {
        if (filename == null) {
            filename = new String();
        }
        if (function == null) {
            function = new String();
        }
        if (name == null) {
            name = new String();
        }
        StringBuffer buffer = new StringBuffer();
        if (filename.length() > 0) {
            buffer.append('\'').append(filename).append('\'').append("::");
        }
        if (function.length() > 0) {
            buffer.append(function).append("::");
        }
        buffer.append(name);
        return new GlobalVariableDescriptor(target, null, null, buffer.toString(), null, 0, 0);
    }

    public GlobalVariable createGlobalVariable(GlobalVariableDescriptor varDesc) throws PCDIException {
        Variable variable = this.findVariable(varDesc);
        GlobalVariable global = null;
        if (variable instanceof GlobalVariable) {
            global = (GlobalVariable)variable;
        }
        if (global == null) {
            Target target = (Target)varDesc.getTarget();
            global = new GlobalVariable(varDesc);
            List variablesList = this.getVariablesList(target);
            variablesList.add(global);
        }
        return global;
    }

    public IPCDILocalVariableDescriptor[] getLocalVariableDescriptors(StackFrame frame) throws PCDIException {
        ArrayList<LocalVariableDescriptor> varObjects = new ArrayList<LocalVariableDescriptor>();
        Target target = (Target)frame.getTarget();
        Thread currentThread = (Thread)target.getCurrentThread();
        StackFrame currentFrame = currentThread.getCurrentStackFrame();
        target.setCurrentThread(frame.getThread(), false);
        ((Thread)frame.getThread()).setCurrentStackFrame(frame, false);
        try {
            int level = frame.getLevel();
            ListLocalVariablesCommand varCmd = new ListLocalVariablesCommand(target.getTask());
            target.getDebugger().postCommand((IDebugCommand)varCmd);
            String[] vars = varCmd.getLocalVariables();
            if (vars != null) {
                int i = 0;
                while (i < vars.length) {
                    LocalVariableDescriptor varDesc = new LocalVariableDescriptor(target, null, frame, vars[i], null, vars.length - i, level);
                    varObjects.add(varDesc);
                    ++i;
                }
            }
        }
        finally {
            target.setCurrentThread(currentThread, false);
            currentThread.setCurrentStackFrame(currentFrame, false);
        }
        return varObjects.toArray(new IPCDILocalVariableDescriptor[0]);
    }

    public LocalVariable createLocalVariable(LocalVariableDescriptor varDesc) throws PCDIException {
        Variable variable = this.findVariable(varDesc);
        LocalVariable local = null;
        if (variable instanceof LocalVariable) {
            local = (LocalVariable)variable;
        }
        if (local == null) {
            StackFrame stack = (StackFrame)varDesc.getStackFrame();
            Target target = (Target)varDesc.getTarget();
            Thread currentThread = (Thread)target.getCurrentThread();
            StackFrame currentFrame = currentThread.getCurrentStackFrame();
            target.setCurrentThread(stack.getThread(), false);
            ((Thread)stack.getThread()).setCurrentStackFrame(stack, false);
            try {
                local = new LocalVariable(varDesc);
                List variablesList = this.getVariablesList(target);
                variablesList.add(local);
            }
            finally {
                target.setCurrentThread(currentThread, false);
                currentThread.setCurrentStackFrame(currentFrame, false);
            }
        }
        return local;
    }

    public IPCDIThreadStorageDescriptor[] getThreadStorageDescriptors(Thread thread) throws PCDIException {
        return new IPCDIThreadStorageDescriptor[0];
    }

    public ThreadStorage createThreadStorage(ThreadStorageDescriptor desc) throws PCDIException {
        throw new PCDIException("VariableManager.Unknown_variable_object: createThreadStorage");
    }

    public void destroyVariable(Variable variable) throws PCDIException {
        Target target = (Target)variable.getTarget();
        List varList = this.getVariablesList(target);
        if (varList.contains(variable)) {
            this.removeKeyVar(target, variable.getKeyName());
            variable.setKeyName(null);
        }
    }

    public void destroyAllVariables(Target target) throws PCDIException {
        Variable[] variables = this.getVariables(target);
        int i = 0;
        while (i < variables.length) {
            this.removeKeyVar(target, variables[i].getKeyName());
            variables[i].setKeyName(null);
            ++i;
        }
    }

    Variable findVariable(Variable parent, String keyname) {
        Variable children = parent.getChild(keyname);
        if (children == null) {
            return parent;
        }
        return children;
    }

    public void update(Target target, String[] varList) throws PCDIException {
        ArrayList<VarChangedEvent> eventList = new ArrayList<VarChangedEvent>();
        int i = 0;
        while (i < varList.length) {
            Variable variable = this.getVariable(target, varList[i]);
            if (variable != null) {
                variable.setUpdated(true);
                eventList.add(new VarChangedEvent(target.getSession(), target.getTask(), variable, varList[i]));
            }
            ++i;
        }
        IPCDIEvent[] events = eventList.toArray(new IPCDIEvent[0]);
        target.getDebugger().fireEvents(events);
    }

    public void update(Target target) throws PCDIException {
        this.update(target, new String[0]);
    }

    boolean isVariableNeedsToBeUpdate(Variable variable, IPCDIStackFrame current, IPCDIStackFrame[] frames, int lowLevel) throws PCDIException {
        IPCDIStackFrame varStack = variable.getStackFrame();
        boolean inScope = false;
        if (current == null || frames == null) {
            return false;
        }
        if (varStack == null) {
            return true;
        }
        if (varStack.equals(current)) {
            return true;
        }
        if (varStack.getLevel() >= lowLevel) {
            int i = 0;
            while (i < frames.length) {
                if (varStack.equals(frames[i])) {
                    inScope = true;
                }
                ++i;
            }
        } else {
            inScope = true;
        }
        return !inScope;
    }
}

