/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code, released March 31, 1998.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by Netscape are Copyright (C) 1998-1999
 * Netscape Communications Corporation.  All Rights Reserved.
 *
 * Contributor(s):
 *
 * IBM
 * -  Binding to permit interfacing between Mozilla and SWT
 * -  Copyright (C) 2004, 2006 IBM Corp.  All Rights Reserved.
 *
 * ***** END LICENSE BLOCK ***** */

#include "swt.h"
#include "xpcom_structs.h"
#include "xpcom_stats.h"

extern "C" {

#define XPCOM_NATIVE(func) Java_org_eclipse_swt_internal_mozilla_XPCOM_##func

#ifndef NO_Call
JNIEXPORT jlong JNICALL XPCOM_NATIVE(Call)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jlong arg2, jbyteArray arg3, jint arg4, jint arg5, jintArray arg6)
{
	jbyte *lparg3=NULL;
	jint *lparg6=NULL;
	jlong rc = 0;
	XPCOM_NATIVE_ENTER(env, that, Call_FUNC);
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetIntArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jlong)((nsWriteSegmentFun)arg0)((nsIInputStream *)arg1, (void *)arg2, (const char *)lparg3, arg4, arg5, (PRUint32 *)lparg6);
fail:
	if (arg6 && lparg6) env->ReleaseIntArrayElements(arg6, lparg6, 0);
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, Call_FUNC);
	return rc;
}
#endif

#ifndef NO_NS_1GetComponentManager
JNIEXPORT jint JNICALL XPCOM_NATIVE(NS_1GetComponentManager)
	(JNIEnv *env, jclass that, jlongArray arg0)
{
	jlong *lparg0=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, NS_1GetComponentManager_FUNC);
	if (arg0) if ((lparg0 = env->GetLongArrayElements(arg0, NULL)) == NULL) goto fail;
	rc = (jint)NS_GetComponentManager((nsIComponentManager**)lparg0);
fail:
	if (arg0 && lparg0) env->ReleaseLongArrayElements(arg0, lparg0, 0);
	XPCOM_NATIVE_EXIT(env, that, NS_1GetComponentManager_FUNC);
	return rc;
}
#endif

#ifndef NO_NS_1GetServiceManager
JNIEXPORT jint JNICALL XPCOM_NATIVE(NS_1GetServiceManager)
	(JNIEnv *env, jclass that, jlongArray arg0)
{
	jlong *lparg0=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, NS_1GetServiceManager_FUNC);
	if (arg0) if ((lparg0 = env->GetLongArrayElements(arg0, NULL)) == NULL) goto fail;
	rc = (jint)NS_GetServiceManager((nsIServiceManager**)lparg0);
fail:
	if (arg0 && lparg0) env->ReleaseLongArrayElements(arg0, lparg0, 0);
	XPCOM_NATIVE_EXIT(env, that, NS_1GetServiceManager_FUNC);
	return rc;
}
#endif

#ifndef NO_NS_1InitEmbedding
JNIEXPORT jint JNICALL XPCOM_NATIVE(NS_1InitEmbedding)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, NS_1InitEmbedding_FUNC);
	rc = (jint)NS_InitEmbedding((nsILocalFile *)arg0, (nsIDirectoryServiceProvider *)arg1);
	XPCOM_NATIVE_EXIT(env, that, NS_1InitEmbedding_FUNC);
	return rc;
}
#endif

#ifndef NO_NS_1NewLocalFile
JNIEXPORT jint JNICALL XPCOM_NATIVE(NS_1NewLocalFile)
	(JNIEnv *env, jclass that, jlong arg0, jboolean arg1, jlongArray arg2)
{
	jlong *lparg2=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, NS_1NewLocalFile_FUNC);
	if (arg2) if ((lparg2 = env->GetLongArrayElements(arg2, NULL)) == NULL) goto fail;
	rc = (jint)NS_NewLocalFile(*(nsAString *)arg0, arg1, (nsILocalFile**)lparg2);
fail:
	if (arg2 && lparg2) env->ReleaseLongArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, NS_1NewLocalFile_FUNC);
	return rc;
}
#endif

#ifndef NO_NS_1TermEmbedding
JNIEXPORT jint JNICALL XPCOM_NATIVE(NS_1TermEmbedding)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, NS_1TermEmbedding_FUNC);
	rc = (jint)NS_TermEmbedding();
	XPCOM_NATIVE_EXIT(env, that, NS_1TermEmbedding_FUNC);
	return rc;
}
#endif

#ifndef NO_PR_1Free
JNIEXPORT void JNICALL XPCOM_NATIVE(PR_1Free)
	(JNIEnv *env, jclass that, jlong arg0)
{
	XPCOM_NATIVE_ENTER(env, that, PR_1Free_FUNC);
	PR_Free((void *)arg0);
	XPCOM_NATIVE_EXIT(env, that, PR_1Free_FUNC);
}
#endif

#ifndef NO_PR_1Malloc
JNIEXPORT jlong JNICALL XPCOM_NATIVE(PR_1Malloc)
	(JNIEnv *env, jclass that, jint arg0)
{
	jlong rc = 0;
	XPCOM_NATIVE_ENTER(env, that, PR_1Malloc_FUNC);
	rc = (jlong)PR_Malloc(arg0);
	XPCOM_NATIVE_EXIT(env, that, PR_1Malloc_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong))(*(jlong **)arg1)[arg0])(arg1);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJF
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJF)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jfloat arg2)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJF_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jfloat))(*(jlong **)arg1)[arg0])(arg1, arg2);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJF_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJI
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJI)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJI_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint))(*(jlong **)arg1)[arg0])(arg1, arg2);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJI_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJII
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJII)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jint arg3)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJII_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jint))(*(jlong **)arg1)[arg0])(arg1, arg2, arg3);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJII_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJIIIII
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJIIIII)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jint arg3, jint arg4, jint arg5, jint arg6)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJIIIII_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jint, jint, jint, jint))(*(jlong **)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJIIIII_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJIIIIZ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJIIIIZ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jint arg3, jint arg4, jint arg5, jboolean arg6)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJIIIIZ_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jint, jint, jint, jboolean))(*(jlong **)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJIIIIZ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJIIZ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJIIZ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jint arg3, jboolean arg4)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJIIZ_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jint, jboolean))(*(jlong **)arg1)[arg0])(arg1, arg2, arg3, arg4);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJIIZ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJII_3C
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJII_3C)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jint arg3, jcharArray arg4)
{
	jchar *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJII_3C_FUNC);
	if (arg4) if ((lparg4 = env->GetCharArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jint, jchar *))(*(jlong **)arg1)[arg0])(arg1, arg2, arg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseCharArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJII_3C_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJII_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJII_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jint arg3, jlongArray arg4)
{
	jlong *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJII_3J_FUNC);
	if (arg4) if ((lparg4 = env->GetLongArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jint, jlong *))(*(jlong **)arg1)[arg0])(arg1, arg2, arg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseLongArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJII_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJIJJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJIJJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jlong arg3, jlong arg4)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJIJJ_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jlong, jlong))(*(jlong **)arg1)[arg0])(arg1, arg2, arg3, arg4);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJIJJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJI_3B_3Z
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJI_3B_3Z)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jbyteArray arg3, jbooleanArray arg4)
{
	jbyte *lparg3=NULL;
	jboolean *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJI_3B_3Z_FUNC);
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetBooleanArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jbyte *, jboolean *))(*(jlong **)arg1)[arg0])(arg1, arg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseBooleanArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJI_3B_3Z_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJI_3C
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJI_3C)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jcharArray arg3)
{
	jchar *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJI_3C_FUNC);
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jchar *))(*(jlong **)arg1)[arg0])(arg1, arg2, lparg3);
fail:
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJI_3C_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJI_3I_3I_3I_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJI_3I_3I_3I_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jintArray arg3, jintArray arg4, jintArray arg5, jintArray arg6)
{
	jint *lparg3=NULL;
	jint *lparg4=NULL;
	jint *lparg5=NULL;
	jint *lparg6=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJI_3I_3I_3I_3I_FUNC);
	if (arg3) if ((lparg3 = env->GetIntArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetIntArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetIntArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetIntArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jint *, jint *, jint *, jint *))(*(jlong **)arg1)[arg0])(arg1, arg2, lparg3, lparg4, lparg5, lparg6);
fail:
	if (arg6 && lparg6) env->ReleaseIntArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseIntArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseIntArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseIntArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJI_3I_3I_3I_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong))(*(jlong **)arg1)[arg0])(arg1, arg2);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJI
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJI)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jint arg3)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJI_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jint))(*(jlong **)arg1)[arg0])(arg1, arg2, arg3);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJI_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJI_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJI_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jint arg3, jlongArray arg4)
{
	jlong *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJI_3J_FUNC);
	if (arg4) if ((lparg4 = env->GetLongArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jint, jlong *))(*(jlong **)arg1)[arg0])(arg1, arg2, arg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseLongArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJI_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJ_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong))(*(jlong **)arg1)[arg0])(arg1, arg2, arg3);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJI
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJI)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jint arg4)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJI_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jint))(*(jlong **)arg1)[arg0])(arg1, arg2, arg3, arg4);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJI_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJII
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJII)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jint arg4, jint arg5)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJII_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jint, jint))(*(jlong **)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJII_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJIIII
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJIIII)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jint arg4, jint arg5, jint arg6, jint arg7)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJIIII_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jint, jint, jint, jint))(*(jlong **)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJIIII_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJIZ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJIZ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jint arg4, jboolean arg5)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJIZ_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jint, jboolean))(*(jlong **)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJIZ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJI_3C
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJI_3C)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jint arg4, jcharArray arg5)
{
	jchar *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJI_3C_FUNC);
	if (arg5) if ((lparg5 = env->GetCharArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jint, jchar *))(*(jlong **)arg1)[arg0])(arg1, arg2, arg3, arg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseCharArrayElements(arg5, lparg5, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJI_3C_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJI_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJI_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jint arg4, jintArray arg5)
{
	jint *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJI_3I_FUNC);
	if (arg5) if ((lparg5 = env->GetIntArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jint, jint *))(*(jlong **)arg1)[arg0])(arg1, arg2, arg3, arg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseIntArrayElements(arg5, lparg5, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJI_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJJ_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong))(*(jlong **)arg1)[arg0])(arg1, arg2, arg3, arg4);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJJJJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJJJJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4, jlong arg5, jlong arg6)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJJJJ_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong, jlong, jlong))(*(jlong **)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJJJJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJJZ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJJZ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4, jboolean arg5)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJJZ_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong, jboolean))(*(jlong **)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJJZ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJJZ_3CJJIJZ_3J_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJJZ_3CJJIJZ_3J_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4, jboolean arg5, jcharArray arg6, jlong arg7, jlong arg8, jint arg9, jlong arg10, jboolean arg11, jlongArray arg12, jlongArray arg13)
{
	jchar *lparg6=NULL;
	jlong *lparg12=NULL;
	jlong *lparg13=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJJZ_3CJJIJZ_3J_3J_FUNC);
	if (arg6) if ((lparg6 = env->GetCharArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg12) if ((lparg12 = env->GetLongArrayElements(arg12, NULL)) == NULL) goto fail;
	if (arg13) if ((lparg13 = env->GetLongArrayElements(arg13, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong, jboolean, jchar *, jlong, jlong, jint, jlong, jboolean, jlong *, jlong *))(*(jlong **)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, lparg6, arg7, arg8, arg9, arg10, arg11, lparg12, lparg13);
fail:
	if (arg13 && lparg13) env->ReleaseLongArrayElements(arg13, lparg13, 0);
	if (arg12 && lparg12) env->ReleaseLongArrayElements(arg12, lparg12, 0);
	if (arg6 && lparg6) env->ReleaseCharArrayElements(arg6, lparg6, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJJZ_3CJJIJZ_3J_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJ_3CJJJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJ_3CJJJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jcharArray arg4, jlong arg5, jlong arg6, jlong arg7)
{
	jchar *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJ_3CJJJ_FUNC);
	if (arg4) if ((lparg4 = env->GetCharArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jchar *, jlong, jlong, jlong))(*(jlong **)arg1)[arg0])(arg1, arg2, arg3, lparg4, arg5, arg6, arg7);
fail:
	if (arg4 && lparg4) env->ReleaseCharArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJ_3CJJJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJLorg_eclipse_swt_internal_mozilla_nsID_2
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJLorg_eclipse_swt_internal_mozilla_nsID_2)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jobject arg3)
{
	nsID _arg3, *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJLorg_eclipse_swt_internal_mozilla_nsID_2_FUNC);
	if (arg3) if ((lparg3 = getnsIDFields(env, arg3, &_arg3)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, nsID *))(*(jlong **)arg1)[arg0])(arg1, arg2, lparg3);
fail:
	if (arg3 && lparg3) setnsIDFields(env, arg3, lparg3);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJLorg_eclipse_swt_internal_mozilla_nsID_2_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJLorg_eclipse_swt_internal_mozilla_nsID_2_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJLorg_eclipse_swt_internal_mozilla_nsID_2_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jobject arg3, jlongArray arg4)
{
	nsID _arg3, *lparg3=NULL;
	jlong *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJLorg_eclipse_swt_internal_mozilla_nsID_2_3J_FUNC);
	if (arg3) if ((lparg3 = getnsIDFields(env, arg3, &_arg3)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetLongArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, nsID *, jlong *))(*(jlong **)arg1)[arg0])(arg1, arg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseLongArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) setnsIDFields(env, arg3, lparg3);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJLorg_eclipse_swt_internal_mozilla_nsID_2_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJZ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJZ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jboolean arg3)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJZ_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jboolean))(*(jlong **)arg1)[arg0])(arg1, arg2, arg3);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJZ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJZZ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJZZ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jboolean arg3, jboolean arg4)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJZZ_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jboolean, jboolean))(*(jlong **)arg1)[arg0])(arg1, arg2, arg3, arg4);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJZZ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJZZJI
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJZZJI)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jboolean arg3, jboolean arg4, jlong arg5, jint arg6)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJZZJI_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jboolean, jboolean, jlong, jint))(*(jlong **)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJZZJI_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJZZJIIIIIZZZZSJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJZZJIIIIIZZZZSJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jboolean arg3, jboolean arg4, jlong arg5, jint arg6, jint arg7, jint arg8, jint arg9, jint arg10, jboolean arg11, jboolean arg12, jboolean arg13, jboolean arg14, jshort arg15, jlong arg16)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJZZJIIIIIZZZZSJ_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jboolean, jboolean, jlong, jint, jint, jint, jint, jint, jboolean, jboolean, jboolean, jboolean, jshort, jlong))(*(jlong **)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJZZJIIIIIZZZZSJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJZ_3Z
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJZ_3Z)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jboolean arg3, jbooleanArray arg4)
{
	jboolean *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJZ_3Z_FUNC);
	if (arg4) if ((lparg4 = env->GetBooleanArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jboolean, jboolean *))(*(jlong **)arg1)[arg0])(arg1, arg2, arg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseBooleanArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJZ_3Z_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3BJ_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3BJ_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jbyteArray arg3, jlong arg4, jlongArray arg5)
{
	jbyte *lparg3=NULL;
	jlong *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3BJ_3J_FUNC);
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetLongArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jbyte *, jlong, jlong *))(*(jlong **)arg1)[arg0])(arg1, arg2, lparg3, arg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseLongArrayElements(arg5, lparg5, 0);
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3BJ_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3B_3B_3BJ_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3B_3B_3BJ_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jbyteArray arg3, jbyteArray arg4, jbyteArray arg5, jlong arg6, jlongArray arg7)
{
	jbyte *lparg3=NULL;
	jbyte *lparg4=NULL;
	jbyte *lparg5=NULL;
	jlong *lparg7=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3B_3B_3BJ_3J_FUNC);
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetByteArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetByteArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetLongArrayElements(arg7, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jbyte *, jbyte *, jbyte *, jlong, jlong *))(*(jlong **)arg1)[arg0])(arg1, arg2, lparg3, lparg4, lparg5, arg6, lparg7);
fail:
	if (arg7 && lparg7) env->ReleaseLongArrayElements(arg7, lparg7, 0);
	if (arg5 && lparg5) env->ReleaseByteArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseByteArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3B_3B_3BJ_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3CI
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3CI)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jcharArray arg3, jint arg4)
{
	jchar *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3CI_FUNC);
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jchar *, jint))(*(jlong **)arg1)[arg0])(arg1, arg2, lparg3, arg4);
fail:
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3CI_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3C_3C
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3C_3C)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jcharArray arg3, jcharArray arg4)
{
	jchar *lparg3=NULL;
	jchar *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3C_3C_FUNC);
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetCharArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jchar *, jchar *))(*(jlong **)arg1)[arg0])(arg1, arg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseCharArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3C_3C_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3C_3CI_3C_3C_3C_3C_3Z_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3C_3CI_3C_3C_3C_3C_3Z_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jcharArray arg3, jcharArray arg4, jint arg5, jcharArray arg6, jcharArray arg7, jcharArray arg8, jcharArray arg9, jbooleanArray arg10, jintArray arg11)
{
	jchar *lparg3=NULL;
	jchar *lparg4=NULL;
	jchar *lparg6=NULL;
	jchar *lparg7=NULL;
	jchar *lparg8=NULL;
	jchar *lparg9=NULL;
	jboolean *lparg10=NULL;
	jint *lparg11=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3C_3CI_3C_3C_3C_3C_3Z_3I_FUNC);
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetCharArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetCharArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetCharArrayElements(arg7, NULL)) == NULL) goto fail;
	if (arg8) if ((lparg8 = env->GetCharArrayElements(arg8, NULL)) == NULL) goto fail;
	if (arg9) if ((lparg9 = env->GetCharArrayElements(arg9, NULL)) == NULL) goto fail;
	if (arg10) if ((lparg10 = env->GetBooleanArrayElements(arg10, NULL)) == NULL) goto fail;
	if (arg11) if ((lparg11 = env->GetIntArrayElements(arg11, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jchar *, jchar *, jint, jchar *, jchar *, jchar *, jchar *, jboolean *, jint *))(*(jlong **)arg1)[arg0])(arg1, arg2, lparg3, lparg4, arg5, lparg6, lparg7, lparg8, lparg9, lparg10, lparg11);
fail:
	if (arg11 && lparg11) env->ReleaseIntArrayElements(arg11, lparg11, 0);
	if (arg10 && lparg10) env->ReleaseBooleanArrayElements(arg10, lparg10, 0);
	if (arg9 && lparg9) env->ReleaseCharArrayElements(arg9, lparg9, 0);
	if (arg8 && lparg8) env->ReleaseCharArrayElements(arg8, lparg8, 0);
	if (arg7 && lparg7) env->ReleaseCharArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseCharArrayElements(arg6, lparg6, 0);
	if (arg4 && lparg4) env->ReleaseCharArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3C_3CI_3C_3C_3C_3C_3Z_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3C_3CI_3J_3I_3Z
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3C_3CI_3J_3I_3Z)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jcharArray arg3, jcharArray arg4, jint arg5, jlongArray arg6, jintArray arg7, jbooleanArray arg8)
{
	jchar *lparg3=NULL;
	jchar *lparg4=NULL;
	jlong *lparg6=NULL;
	jint *lparg7=NULL;
	jboolean *lparg8=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3C_3CI_3J_3I_3Z_FUNC);
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetCharArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetLongArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetIntArrayElements(arg7, NULL)) == NULL) goto fail;
	if (arg8) if ((lparg8 = env->GetBooleanArrayElements(arg8, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jchar *, jchar *, jint, jlong *, jint *, jboolean *))(*(jlong **)arg1)[arg0])(arg1, arg2, lparg3, lparg4, arg5, lparg6, lparg7, lparg8);
fail:
	if (arg8 && lparg8) env->ReleaseBooleanArrayElements(arg8, lparg8, 0);
	if (arg7 && lparg7) env->ReleaseIntArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseLongArrayElements(arg6, lparg6, 0);
	if (arg4 && lparg4) env->ReleaseCharArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3C_3CI_3J_3I_3Z_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3C_3C_3C_3Z
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3C_3C_3C_3Z)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jcharArray arg3, jcharArray arg4, jcharArray arg5, jbooleanArray arg6)
{
	jchar *lparg3=NULL;
	jchar *lparg4=NULL;
	jchar *lparg5=NULL;
	jboolean *lparg6=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3C_3C_3C_3Z_FUNC);
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetCharArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetCharArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetBooleanArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jchar *, jchar *, jchar *, jboolean *))(*(jlong **)arg1)[arg0])(arg1, arg2, lparg3, lparg4, lparg5, lparg6);
fail:
	if (arg6 && lparg6) env->ReleaseBooleanArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseCharArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseCharArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3C_3C_3C_3Z_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3C_3C_3C_3Z_3Z
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3C_3C_3C_3Z_3Z)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jcharArray arg3, jcharArray arg4, jcharArray arg5, jbooleanArray arg6, jbooleanArray arg7)
{
	jchar *lparg3=NULL;
	jchar *lparg4=NULL;
	jchar *lparg5=NULL;
	jboolean *lparg6=NULL;
	jboolean *lparg7=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3C_3C_3C_3Z_3Z_FUNC);
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetCharArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetCharArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetBooleanArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetBooleanArrayElements(arg7, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jchar *, jchar *, jchar *, jboolean *, jboolean *))(*(jlong **)arg1)[arg0])(arg1, arg2, lparg3, lparg4, lparg5, lparg6, lparg7);
fail:
	if (arg7 && lparg7) env->ReleaseBooleanArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseBooleanArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseCharArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseCharArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3C_3C_3C_3Z_3Z_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3C_3C_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3C_3C_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jcharArray arg3, jcharArray arg4, jlongArray arg5)
{
	jchar *lparg3=NULL;
	jchar *lparg4=NULL;
	jlong *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3C_3C_3J_FUNC);
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetCharArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetLongArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jchar *, jchar *, jlong *))(*(jlong **)arg1)[arg0])(arg1, arg2, lparg3, lparg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseLongArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseCharArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3C_3C_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3C_3C_3J_3C_3Z_3Z
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3C_3C_3J_3C_3Z_3Z)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jcharArray arg3, jcharArray arg4, jlongArray arg5, jcharArray arg6, jbooleanArray arg7, jbooleanArray arg8)
{
	jchar *lparg3=NULL;
	jchar *lparg4=NULL;
	jlong *lparg5=NULL;
	jchar *lparg6=NULL;
	jboolean *lparg7=NULL;
	jboolean *lparg8=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3C_3C_3J_3C_3Z_3Z_FUNC);
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetCharArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetLongArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetCharArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetBooleanArrayElements(arg7, NULL)) == NULL) goto fail;
	if (arg8) if ((lparg8 = env->GetBooleanArrayElements(arg8, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jchar *, jchar *, jlong *, jchar *, jboolean *, jboolean *))(*(jlong **)arg1)[arg0])(arg1, arg2, lparg3, lparg4, lparg5, lparg6, lparg7, lparg8);
fail:
	if (arg8 && lparg8) env->ReleaseBooleanArrayElements(arg8, lparg8, 0);
	if (arg7 && lparg7) env->ReleaseBooleanArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseCharArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseLongArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseCharArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3C_3C_3J_3C_3Z_3Z_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3C_3C_3J_3J_3C_3Z_3Z
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3C_3C_3J_3J_3C_3Z_3Z)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jcharArray arg3, jcharArray arg4, jlongArray arg5, jlongArray arg6, jcharArray arg7, jbooleanArray arg8, jbooleanArray arg9)
{
	jchar *lparg3=NULL;
	jchar *lparg4=NULL;
	jlong *lparg5=NULL;
	jlong *lparg6=NULL;
	jchar *lparg7=NULL;
	jboolean *lparg8=NULL;
	jboolean *lparg9=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3C_3C_3J_3J_3C_3Z_3Z_FUNC);
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetCharArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetLongArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetLongArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetCharArrayElements(arg7, NULL)) == NULL) goto fail;
	if (arg8) if ((lparg8 = env->GetBooleanArrayElements(arg8, NULL)) == NULL) goto fail;
	if (arg9) if ((lparg9 = env->GetBooleanArrayElements(arg9, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jchar *, jchar *, jlong *, jlong *, jchar *, jboolean *, jboolean *))(*(jlong **)arg1)[arg0])(arg1, arg2, lparg3, lparg4, lparg5, lparg6, lparg7, lparg8, lparg9);
fail:
	if (arg9 && lparg9) env->ReleaseBooleanArrayElements(arg9, lparg9, 0);
	if (arg8 && lparg8) env->ReleaseBooleanArrayElements(arg8, lparg8, 0);
	if (arg7 && lparg7) env->ReleaseCharArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseLongArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseLongArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseCharArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3C_3C_3J_3J_3C_3Z_3Z_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3C_3C_3Z
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3C_3C_3Z)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jcharArray arg3, jcharArray arg4, jbooleanArray arg5)
{
	jchar *lparg3=NULL;
	jchar *lparg4=NULL;
	jboolean *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3C_3C_3Z_FUNC);
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetCharArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetBooleanArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jchar *, jchar *, jboolean *))(*(jlong **)arg1)[arg0])(arg1, arg2, lparg3, lparg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseBooleanArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseCharArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3C_3C_3Z_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlongArray arg3)
{
	jlong *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3J_FUNC);
	if (arg3) if ((lparg3 = env->GetLongArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong *))(*(jlong **)arg1)[arg0])(arg1, arg2, lparg3);
fail:
	if (arg3 && lparg3) env->ReleaseLongArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3Z
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3Z)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jbooleanArray arg3)
{
	jboolean *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3Z_FUNC);
	if (arg3) if ((lparg3 = env->GetBooleanArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jboolean *))(*(jlong **)arg1)[arg0])(arg1, arg2, lparg3);
fail:
	if (arg3 && lparg3) env->ReleaseBooleanArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3Z_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJLorg_eclipse_swt_internal_mozilla_nsID_2J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJLorg_eclipse_swt_internal_mozilla_nsID_2J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jobject arg2, jlong arg3)
{
	nsID _arg2, *lparg2=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJLorg_eclipse_swt_internal_mozilla_nsID_2J_FUNC);
	if (arg2) if ((lparg2 = getnsIDFields(env, arg2, &_arg2)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, nsID *, jlong))(*(jlong **)arg1)[arg0])(arg1, lparg2, arg3);
fail:
	if (arg2 && lparg2) setnsIDFields(env, arg2, lparg2);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJLorg_eclipse_swt_internal_mozilla_nsID_2J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJLorg_eclipse_swt_internal_mozilla_nsID_2JLorg_eclipse_swt_internal_mozilla_nsID_2_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJLorg_eclipse_swt_internal_mozilla_nsID_2JLorg_eclipse_swt_internal_mozilla_nsID_2_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jobject arg2, jlong arg3, jobject arg4, jlongArray arg5)
{
	nsID _arg2, *lparg2=NULL;
	nsID _arg4, *lparg4=NULL;
	jlong *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJLorg_eclipse_swt_internal_mozilla_nsID_2JLorg_eclipse_swt_internal_mozilla_nsID_2_3J_FUNC);
	if (arg2) if ((lparg2 = getnsIDFields(env, arg2, &_arg2)) == NULL) goto fail;
	if (arg4) if ((lparg4 = getnsIDFields(env, arg4, &_arg4)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetLongArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, nsID *, jlong, nsID *, jlong *))(*(jlong **)arg1)[arg0])(arg1, lparg2, arg3, lparg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseLongArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) setnsIDFields(env, arg4, lparg4);
	if (arg2 && lparg2) setnsIDFields(env, arg2, lparg2);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJLorg_eclipse_swt_internal_mozilla_nsID_2JLorg_eclipse_swt_internal_mozilla_nsID_2_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJLorg_eclipse_swt_internal_mozilla_nsID_2Lorg_eclipse_swt_internal_mozilla_nsID_2_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJLorg_eclipse_swt_internal_mozilla_nsID_2Lorg_eclipse_swt_internal_mozilla_nsID_2_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jobject arg2, jobject arg3, jlongArray arg4)
{
	nsID _arg2, *lparg2=NULL;
	nsID _arg3, *lparg3=NULL;
	jlong *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJLorg_eclipse_swt_internal_mozilla_nsID_2Lorg_eclipse_swt_internal_mozilla_nsID_2_3J_FUNC);
	if (arg2) if ((lparg2 = getnsIDFields(env, arg2, &_arg2)) == NULL) goto fail;
	if (arg3) if ((lparg3 = getnsIDFields(env, arg3, &_arg3)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetLongArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, nsID *, nsID *, jlong *))(*(jlong **)arg1)[arg0])(arg1, lparg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseLongArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) setnsIDFields(env, arg3, lparg3);
	if (arg2 && lparg2) setnsIDFields(env, arg2, lparg2);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJLorg_eclipse_swt_internal_mozilla_nsID_2Lorg_eclipse_swt_internal_mozilla_nsID_2_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJLorg_eclipse_swt_internal_mozilla_nsID_2Lorg_eclipse_swt_internal_mozilla_nsID_2_3Z
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJLorg_eclipse_swt_internal_mozilla_nsID_2Lorg_eclipse_swt_internal_mozilla_nsID_2_3Z)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jobject arg2, jobject arg3, jbooleanArray arg4)
{
	nsID _arg2, *lparg2=NULL;
	nsID _arg3, *lparg3=NULL;
	jboolean *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJLorg_eclipse_swt_internal_mozilla_nsID_2Lorg_eclipse_swt_internal_mozilla_nsID_2_3Z_FUNC);
	if (arg2) if ((lparg2 = getnsIDFields(env, arg2, &_arg2)) == NULL) goto fail;
	if (arg3) if ((lparg3 = getnsIDFields(env, arg3, &_arg3)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetBooleanArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, nsID *, nsID *, jboolean *))(*(jlong **)arg1)[arg0])(arg1, lparg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseBooleanArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) setnsIDFields(env, arg3, lparg3);
	if (arg2 && lparg2) setnsIDFields(env, arg2, lparg2);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJLorg_eclipse_swt_internal_mozilla_nsID_2Lorg_eclipse_swt_internal_mozilla_nsID_2_3Z_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJLorg_eclipse_swt_internal_mozilla_nsID_2_3B_3BJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJLorg_eclipse_swt_internal_mozilla_nsID_2_3B_3BJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jobject arg2, jbyteArray arg3, jbyteArray arg4, jlong arg5)
{
	nsID _arg2, *lparg2=NULL;
	jbyte *lparg3=NULL;
	jbyte *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJLorg_eclipse_swt_internal_mozilla_nsID_2_3B_3BJ_FUNC);
	if (arg2) if ((lparg2 = getnsIDFields(env, arg2, &_arg2)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetByteArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, nsID *, jbyte *, jbyte *, jlong))(*(jlong **)arg1)[arg0])(arg1, lparg2, lparg3, lparg4, arg5);
fail:
	if (arg4 && lparg4) env->ReleaseByteArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) setnsIDFields(env, arg2, lparg2);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJLorg_eclipse_swt_internal_mozilla_nsID_2_3B_3BJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJLorg_eclipse_swt_internal_mozilla_nsID_2_3B_3BJ_3B_3B
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJLorg_eclipse_swt_internal_mozilla_nsID_2_3B_3BJ_3B_3B)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jobject arg2, jbyteArray arg3, jbyteArray arg4, jlong arg5, jbyteArray arg6, jbyteArray arg7)
{
	nsID _arg2, *lparg2=NULL;
	jbyte *lparg3=NULL;
	jbyte *lparg4=NULL;
	jbyte *lparg6=NULL;
	jbyte *lparg7=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJLorg_eclipse_swt_internal_mozilla_nsID_2_3B_3BJ_3B_3B_FUNC);
	if (arg2) if ((lparg2 = getnsIDFields(env, arg2, &_arg2)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetByteArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetByteArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetByteArrayElements(arg7, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, nsID *, jbyte *, jbyte *, jlong, jbyte *, jbyte *))(*(jlong **)arg1)[arg0])(arg1, lparg2, lparg3, lparg4, arg5, lparg6, lparg7);
fail:
	if (arg7 && lparg7) env->ReleaseByteArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseByteArrayElements(arg6, lparg6, 0);
	if (arg4 && lparg4) env->ReleaseByteArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) setnsIDFields(env, arg2, lparg2);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJLorg_eclipse_swt_internal_mozilla_nsID_2_3B_3BJ_3B_3B_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJLorg_eclipse_swt_internal_mozilla_nsID_2_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJLorg_eclipse_swt_internal_mozilla_nsID_2_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jobject arg2, jlongArray arg3)
{
	nsID _arg2, *lparg2=NULL;
	jlong *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJLorg_eclipse_swt_internal_mozilla_nsID_2_3J_FUNC);
	if (arg2) if ((lparg2 = getnsIDFields(env, arg2, &_arg2)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetLongArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, nsID *, jlong *))(*(jlong **)arg1)[arg0])(arg1, lparg2, lparg3);
fail:
	if (arg3 && lparg3) env->ReleaseLongArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) setnsIDFields(env, arg2, lparg2);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJLorg_eclipse_swt_internal_mozilla_nsID_2_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJLorg_eclipse_swt_internal_mozilla_nsID_2_3Z
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJLorg_eclipse_swt_internal_mozilla_nsID_2_3Z)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jobject arg2, jbooleanArray arg3)
{
	nsID _arg2, *lparg2=NULL;
	jboolean *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJLorg_eclipse_swt_internal_mozilla_nsID_2_3Z_FUNC);
	if (arg2) if ((lparg2 = getnsIDFields(env, arg2, &_arg2)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetBooleanArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, nsID *, jboolean *))(*(jlong **)arg1)[arg0])(arg1, lparg2, lparg3);
fail:
	if (arg3 && lparg3) env->ReleaseBooleanArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) setnsIDFields(env, arg2, lparg2);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJLorg_eclipse_swt_internal_mozilla_nsID_2_3Z_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJZ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJZ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jboolean arg2)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJZ_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jboolean))(*(jlong **)arg1)[arg0])(arg1, arg2);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJZ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJZJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJZJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jboolean arg2, jlong arg3)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJZJ_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jboolean, jlong))(*(jlong **)arg1)[arg0])(arg1, arg2, arg3);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJZJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJZ_3Z
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJZ_3Z)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jboolean arg2, jbooleanArray arg3)
{
	jboolean *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJZ_3Z_FUNC);
	if (arg3) if ((lparg3 = env->GetBooleanArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jboolean, jboolean *))(*(jlong **)arg1)[arg0])(arg1, arg2, lparg3);
fail:
	if (arg3 && lparg3) env->ReleaseBooleanArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJZ_3Z_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3B
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3B)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2)
{
	jbyte *lparg2=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3B_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *))(*(jlong **)arg1)[arg0])(arg1, lparg2);
fail:
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3B_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3BI
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3BI)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jint arg3)
{
	jbyte *lparg2=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3BI_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jint))(*(jlong **)arg1)[arg0])(arg1, lparg2, arg3);
fail:
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3BI_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3BI_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3BI_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jint arg3, jintArray arg4)
{
	jbyte *lparg2=NULL;
	jint *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3BI_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetIntArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jint, jint *))(*(jlong **)arg1)[arg0])(arg1, lparg2, arg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseIntArrayElements(arg4, lparg4, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3BI_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3BJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3BJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jlong arg3)
{
	jbyte *lparg2=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3BJ_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jlong))(*(jlong **)arg1)[arg0])(arg1, lparg2, arg3);
fail:
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3BJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3BJLorg_eclipse_swt_internal_mozilla_nsID_2_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3BJLorg_eclipse_swt_internal_mozilla_nsID_2_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jlong arg3, jobject arg4, jlongArray arg5)
{
	jbyte *lparg2=NULL;
	nsID _arg4, *lparg4=NULL;
	jlong *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3BJLorg_eclipse_swt_internal_mozilla_nsID_2_3J_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = getnsIDFields(env, arg4, &_arg4)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetLongArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jlong, nsID *, jlong *))(*(jlong **)arg1)[arg0])(arg1, lparg2, arg3, lparg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseLongArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) setnsIDFields(env, arg4, lparg4);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3BJLorg_eclipse_swt_internal_mozilla_nsID_2_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3BLorg_eclipse_swt_internal_mozilla_nsID_2J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3BLorg_eclipse_swt_internal_mozilla_nsID_2J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jobject arg3, jlong arg4)
{
	jbyte *lparg2=NULL;
	nsID _arg3, *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3BLorg_eclipse_swt_internal_mozilla_nsID_2J_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = getnsIDFields(env, arg3, &_arg3)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, nsID *, jlong))(*(jlong **)arg1)[arg0])(arg1, lparg2, lparg3, arg4);
fail:
	if (arg3 && lparg3) setnsIDFields(env, arg3, lparg3);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3BLorg_eclipse_swt_internal_mozilla_nsID_2J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3BLorg_eclipse_swt_internal_mozilla_nsID_2_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3BLorg_eclipse_swt_internal_mozilla_nsID_2_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jobject arg3, jlongArray arg4)
{
	jbyte *lparg2=NULL;
	nsID _arg3, *lparg3=NULL;
	jlong *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3BLorg_eclipse_swt_internal_mozilla_nsID_2_3J_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = getnsIDFields(env, arg3, &_arg3)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetLongArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, nsID *, jlong *))(*(jlong **)arg1)[arg0])(arg1, lparg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseLongArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) setnsIDFields(env, arg3, lparg3);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3BLorg_eclipse_swt_internal_mozilla_nsID_2_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3BLorg_eclipse_swt_internal_mozilla_nsID_2_3Z
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3BLorg_eclipse_swt_internal_mozilla_nsID_2_3Z)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jobject arg3, jbooleanArray arg4)
{
	jbyte *lparg2=NULL;
	nsID _arg3, *lparg3=NULL;
	jboolean *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3BLorg_eclipse_swt_internal_mozilla_nsID_2_3Z_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = getnsIDFields(env, arg3, &_arg3)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetBooleanArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, nsID *, jboolean *))(*(jlong **)arg1)[arg0])(arg1, lparg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseBooleanArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) setnsIDFields(env, arg3, lparg3);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3BLorg_eclipse_swt_internal_mozilla_nsID_2_3Z_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3BZJ_3J_3Z
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3BZJ_3J_3Z)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jboolean arg3, jlong arg4, jlongArray arg5, jbooleanArray arg6)
{
	jbyte *lparg2=NULL;
	jlong *lparg5=NULL;
	jboolean *lparg6=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3BZJ_3J_3Z_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetLongArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetBooleanArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jboolean, jlong, jlong *, jboolean *))(*(jlong **)arg1)[arg0])(arg1, lparg2, arg3, arg4, lparg5, lparg6);
fail:
	if (arg6 && lparg6) env->ReleaseBooleanArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseLongArrayElements(arg5, lparg5, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3BZJ_3J_3Z_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3BZ_3J_3Z
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3BZ_3J_3Z)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jboolean arg3, jlongArray arg4, jbooleanArray arg5)
{
	jbyte *lparg2=NULL;
	jlong *lparg4=NULL;
	jboolean *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3BZ_3J_3Z_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetLongArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetBooleanArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jboolean, jlong *, jboolean *))(*(jlong **)arg1)[arg0])(arg1, lparg2, arg3, lparg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseBooleanArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseLongArrayElements(arg4, lparg4, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3BZ_3J_3Z_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3B_3B
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3B_3B)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jbyteArray arg3)
{
	jbyte *lparg2=NULL;
	jbyte *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3B_3B_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jbyte *))(*(jlong **)arg1)[arg0])(arg1, lparg2, lparg3);
fail:
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3B_3B_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3B_3BZ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3B_3BZ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jbyteArray arg3, jboolean arg4)
{
	jbyte *lparg2=NULL;
	jbyte *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3B_3BZ_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jbyte *, jboolean))(*(jlong **)arg1)[arg0])(arg1, lparg2, lparg3, arg4);
fail:
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3B_3BZ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3B_3B_3BZZ_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3B_3B_3BZZ_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jbyteArray arg3, jbyteArray arg4, jboolean arg5, jboolean arg6, jlongArray arg7)
{
	jbyte *lparg2=NULL;
	jbyte *lparg3=NULL;
	jbyte *lparg4=NULL;
	jlong *lparg7=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3B_3B_3BZZ_3J_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetByteArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetLongArrayElements(arg7, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jbyte *, jbyte *, jboolean, jboolean, jlong *))(*(jlong **)arg1)[arg0])(arg1, lparg2, lparg3, lparg4, arg5, arg6, lparg7);
fail:
	if (arg7 && lparg7) env->ReleaseLongArrayElements(arg7, lparg7, 0);
	if (arg4 && lparg4) env->ReleaseByteArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3B_3B_3BZZ_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3B_3B_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3B_3B_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jbyteArray arg3, jlongArray arg4)
{
	jbyte *lparg2=NULL;
	jbyte *lparg3=NULL;
	jlong *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3B_3B_3J_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetLongArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jbyte *, jlong *))(*(jlong **)arg1)[arg0])(arg1, lparg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseLongArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3B_3B_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3B_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3B_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jintArray arg3)
{
	jbyte *lparg2=NULL;
	jint *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3B_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetIntArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jint *))(*(jlong **)arg1)[arg0])(arg1, lparg2, lparg3);
fail:
	if (arg3 && lparg3) env->ReleaseIntArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3B_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3B_3I_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3B_3I_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jintArray arg3, jlongArray arg4)
{
	jbyte *lparg2=NULL;
	jint *lparg3=NULL;
	jlong *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3B_3I_3J_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetIntArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetLongArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jint *, jlong *))(*(jlong **)arg1)[arg0])(arg1, lparg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseLongArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseIntArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3B_3I_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3B_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3B_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jlongArray arg3)
{
	jbyte *lparg2=NULL;
	jlong *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3B_3J_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetLongArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jlong *))(*(jlong **)arg1)[arg0])(arg1, lparg2, lparg3);
fail:
	if (arg3 && lparg3) env->ReleaseLongArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3B_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3B_3J_3Z
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3B_3J_3Z)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jlongArray arg3, jbooleanArray arg4)
{
	jbyte *lparg2=NULL;
	jlong *lparg3=NULL;
	jboolean *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3B_3J_3Z_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetLongArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetBooleanArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jlong *, jboolean *))(*(jlong **)arg1)[arg0])(arg1, lparg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseBooleanArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseLongArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3B_3J_3Z_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3B_3Z
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3B_3Z)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jbooleanArray arg3)
{
	jbyte *lparg2=NULL;
	jboolean *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3B_3Z_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetBooleanArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jboolean *))(*(jlong **)arg1)[arg0])(arg1, lparg2, lparg3);
fail:
	if (arg3 && lparg3) env->ReleaseBooleanArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3B_3Z_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3B_3Z_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3B_3Z_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jbooleanArray arg3, jlongArray arg4)
{
	jbyte *lparg2=NULL;
	jboolean *lparg3=NULL;
	jlong *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3B_3Z_3J_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetBooleanArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetLongArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jboolean *, jlong *))(*(jlong **)arg1)[arg0])(arg1, lparg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseLongArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseBooleanArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3B_3Z_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3C
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3C)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jcharArray arg2)
{
	jchar *lparg2=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3C_FUNC);
	if (arg2) if ((lparg2 = env->GetCharArrayElements(arg2, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jchar *))(*(jlong **)arg1)[arg0])(arg1, lparg2);
fail:
	if (arg2 && lparg2) env->ReleaseCharArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3C_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3CIJJJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3CIJJJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jcharArray arg2, jint arg3, jlong arg4, jlong arg5, jlong arg6)
{
	jchar *lparg2=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3CIJJJ_FUNC);
	if (arg2) if ((lparg2 = env->GetCharArrayElements(arg2, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jchar *, jint, jlong, jlong, jlong))(*(jlong **)arg1)[arg0])(arg1, lparg2, arg3, arg4, arg5, arg6);
fail:
	if (arg2 && lparg2) env->ReleaseCharArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3CIJJJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3CJ_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3CJ_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jcharArray arg2, jlong arg3, jlongArray arg4)
{
	jchar *lparg2=NULL;
	jlong *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3CJ_3J_FUNC);
	if (arg2) if ((lparg2 = env->GetCharArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetLongArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jchar *, jlong, jlong *))(*(jlong **)arg1)[arg0])(arg1, lparg2, arg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseLongArrayElements(arg4, lparg4, 0);
	if (arg2 && lparg2) env->ReleaseCharArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3CJ_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3CZ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3CZ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jcharArray arg2, jboolean arg3)
{
	jchar *lparg2=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3CZ_FUNC);
	if (arg2) if ((lparg2 = env->GetCharArrayElements(arg2, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jchar *, jboolean))(*(jlong **)arg1)[arg0])(arg1, lparg2, arg3);
fail:
	if (arg2 && lparg2) env->ReleaseCharArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3CZ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3C_3C
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3C_3C)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jcharArray arg2, jcharArray arg3)
{
	jchar *lparg2=NULL;
	jchar *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3C_3C_FUNC);
	if (arg2) if ((lparg2 = env->GetCharArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jchar *, jchar *))(*(jlong **)arg1)[arg0])(arg1, lparg2, lparg3);
fail:
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseCharArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3C_3C_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3C_3C_3CZ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3C_3C_3CZ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jcharArray arg2, jcharArray arg3, jcharArray arg4, jboolean arg5)
{
	jchar *lparg2=NULL;
	jchar *lparg3=NULL;
	jchar *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3C_3C_3CZ_FUNC);
	if (arg2) if ((lparg2 = env->GetCharArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetCharArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jchar *, jchar *, jchar *, jboolean))(*(jlong **)arg1)[arg0])(arg1, lparg2, lparg3, lparg4, arg5);
fail:
	if (arg4 && lparg4) env->ReleaseCharArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseCharArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3C_3C_3CZ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3C_3Z
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3C_3Z)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jcharArray arg2, jbooleanArray arg3)
{
	jchar *lparg2=NULL;
	jboolean *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3C_3Z_FUNC);
	if (arg2) if ((lparg2 = env->GetCharArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetBooleanArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jchar *, jboolean *))(*(jlong **)arg1)[arg0])(arg1, lparg2, lparg3);
fail:
	if (arg3 && lparg3) env->ReleaseBooleanArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseCharArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3C_3Z_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3F
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3F)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jfloatArray arg2)
{
	jfloat *lparg2=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3F_FUNC);
	if (arg2) if ((lparg2 = env->GetFloatArrayElements(arg2, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jfloat *))(*(jlong **)arg1)[arg0])(arg1, lparg2);
fail:
	if (arg2 && lparg2) env->ReleaseFloatArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3F_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jintArray arg2)
{
	jint *lparg2=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetIntArrayElements(arg2, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint *))(*(jlong **)arg1)[arg0])(arg1, lparg2);
fail:
	if (arg2 && lparg2) env->ReleaseIntArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3I_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3I_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jintArray arg2, jintArray arg3)
{
	jint *lparg2=NULL;
	jint *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3I_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetIntArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetIntArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint *, jint *))(*(jlong **)arg1)[arg0])(arg1, lparg2, lparg3);
fail:
	if (arg3 && lparg3) env->ReleaseIntArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseIntArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3I_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3I_3I_3I_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3I_3I_3I_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jintArray arg2, jintArray arg3, jintArray arg4, jintArray arg5)
{
	jint *lparg2=NULL;
	jint *lparg3=NULL;
	jint *lparg4=NULL;
	jint *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3I_3I_3I_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetIntArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetIntArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetIntArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetIntArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint *, jint *, jint *, jint *))(*(jlong **)arg1)[arg0])(arg1, lparg2, lparg3, lparg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseIntArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseIntArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseIntArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseIntArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3I_3I_3I_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3I_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3I_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jintArray arg2, jlongArray arg3)
{
	jint *lparg2=NULL;
	jlong *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3I_3J_FUNC);
	if (arg2) if ((lparg2 = env->GetIntArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetLongArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint *, jlong *))(*(jlong **)arg1)[arg0])(arg1, lparg2, lparg3);
fail:
	if (arg3 && lparg3) env->ReleaseLongArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseIntArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3I_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3I_3J_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3I_3J_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jintArray arg2, jlongArray arg3, jlongArray arg4)
{
	jint *lparg2=NULL;
	jlong *lparg3=NULL;
	jlong *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3I_3J_3J_FUNC);
	if (arg2) if ((lparg2 = env->GetIntArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetLongArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetLongArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint *, jlong *, jlong *))(*(jlong **)arg1)[arg0])(arg1, lparg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseLongArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseLongArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseIntArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3I_3J_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlongArray arg2)
{
	jlong *lparg2=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3J_FUNC);
	if (arg2) if ((lparg2 = env->GetLongArrayElements(arg2, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong *))(*(jlong **)arg1)[arg0])(arg1, lparg2);
fail:
	if (arg2 && lparg2) env->ReleaseLongArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3J_3J_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3J_3J_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlongArray arg2, jlongArray arg3, jlongArray arg4)
{
	jlong *lparg2=NULL;
	jlong *lparg3=NULL;
	jlong *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3J_3J_3J_FUNC);
	if (arg2) if ((lparg2 = env->GetLongArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetLongArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetLongArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong *, jlong *, jlong *))(*(jlong **)arg1)[arg0])(arg1, lparg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseLongArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseLongArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseLongArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3J_3J_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3S
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3S)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jshortArray arg2)
{
	jshort *lparg2=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3S_FUNC);
	if (arg2) if ((lparg2 = env->GetShortArrayElements(arg2, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jshort *))(*(jlong **)arg1)[arg0])(arg1, lparg2);
fail:
	if (arg2 && lparg2) env->ReleaseShortArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3S_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3Z
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3Z)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbooleanArray arg2)
{
	jboolean *lparg2=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3Z_FUNC);
	if (arg2) if ((lparg2 = env->GetBooleanArrayElements(arg2, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jboolean *))(*(jlong **)arg1)[arg0])(arg1, lparg2);
fail:
	if (arg2 && lparg2) env->ReleaseBooleanArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3Z_FUNC);
	return rc;
}
#endif

#ifndef NO_memmove__JLorg_eclipse_swt_internal_mozilla_nsID_2I
JNIEXPORT void JNICALL XPCOM_NATIVE(memmove__JLorg_eclipse_swt_internal_mozilla_nsID_2I)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1, jint arg2)
{
	nsID _arg1, *lparg1=NULL;
	XPCOM_NATIVE_ENTER(env, that, memmove__JLorg_eclipse_swt_internal_mozilla_nsID_2I_FUNC);
	if (arg1) if ((lparg1 = getnsIDFields(env, arg1, &_arg1)) == NULL) goto fail;
	memmove((void *)arg0, (const void *)lparg1, (size_t)arg2);
fail:
	if (arg1 && lparg1) setnsIDFields(env, arg1, lparg1);
	XPCOM_NATIVE_EXIT(env, that, memmove__JLorg_eclipse_swt_internal_mozilla_nsID_2I_FUNC);
}
#endif

#ifndef NO_memmove__J_3BI
JNIEXPORT void JNICALL XPCOM_NATIVE(memmove__J_3BI)
	(JNIEnv *env, jclass that, jlong arg0, jbyteArray arg1, jint arg2)
{
	jbyte *lparg1=NULL;
	XPCOM_NATIVE_ENTER(env, that, memmove__J_3BI_FUNC);
	if (arg1) if ((lparg1 = env->GetByteArrayElements(arg1, NULL)) == NULL) goto fail;
	memmove((void *)arg0, (const void *)lparg1, (size_t)arg2);
fail:
	if (arg1 && lparg1) env->ReleaseByteArrayElements(arg1, lparg1, 0);
	XPCOM_NATIVE_EXIT(env, that, memmove__J_3BI_FUNC);
}
#endif

#ifndef NO_memmove__J_3CI
JNIEXPORT void JNICALL XPCOM_NATIVE(memmove__J_3CI)
	(JNIEnv *env, jclass that, jlong arg0, jcharArray arg1, jint arg2)
{
	jchar *lparg1=NULL;
	XPCOM_NATIVE_ENTER(env, that, memmove__J_3CI_FUNC);
	if (arg1) if ((lparg1 = env->GetCharArrayElements(arg1, NULL)) == NULL) goto fail;
	memmove((void *)arg0, (const void *)lparg1, (size_t)arg2);
fail:
	if (arg1 && lparg1) env->ReleaseCharArrayElements(arg1, lparg1, 0);
	XPCOM_NATIVE_EXIT(env, that, memmove__J_3CI_FUNC);
}
#endif

#ifndef NO_memmove__J_3II
JNIEXPORT void JNICALL XPCOM_NATIVE(memmove__J_3II)
	(JNIEnv *env, jclass that, jlong arg0, jintArray arg1, jint arg2)
{
	jint *lparg1=NULL;
	XPCOM_NATIVE_ENTER(env, that, memmove__J_3II_FUNC);
	if (arg1) if ((lparg1 = env->GetIntArrayElements(arg1, NULL)) == NULL) goto fail;
	memmove((void *)arg0, (const void *)lparg1, (size_t)arg2);
fail:
	if (arg1 && lparg1) env->ReleaseIntArrayElements(arg1, lparg1, 0);
	XPCOM_NATIVE_EXIT(env, that, memmove__J_3II_FUNC);
}
#endif

#ifndef NO_memmove__J_3JI
JNIEXPORT void JNICALL XPCOM_NATIVE(memmove__J_3JI)
	(JNIEnv *env, jclass that, jlong arg0, jlongArray arg1, jint arg2)
{
	jlong *lparg1=NULL;
	XPCOM_NATIVE_ENTER(env, that, memmove__J_3JI_FUNC);
	if (arg1) if ((lparg1 = env->GetLongArrayElements(arg1, NULL)) == NULL) goto fail;
	memmove((void *)arg0, (const void *)lparg1, (size_t)arg2);
fail:
	if (arg1 && lparg1) env->ReleaseLongArrayElements(arg1, lparg1, 0);
	XPCOM_NATIVE_EXIT(env, that, memmove__J_3JI_FUNC);
}
#endif

#ifndef NO_memmove__Lorg_eclipse_swt_internal_mozilla_nsID_2JI
JNIEXPORT void JNICALL XPCOM_NATIVE(memmove__Lorg_eclipse_swt_internal_mozilla_nsID_2JI)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jint arg2)
{
	nsID _arg0, *lparg0=NULL;
	XPCOM_NATIVE_ENTER(env, that, memmove__Lorg_eclipse_swt_internal_mozilla_nsID_2JI_FUNC);
	if (arg0) if ((lparg0 = getnsIDFields(env, arg0, &_arg0)) == NULL) goto fail;
	memmove((void *)lparg0, (const void *)arg1, (size_t)arg2);
fail:
	if (arg0 && lparg0) setnsIDFields(env, arg0, lparg0);
	XPCOM_NATIVE_EXIT(env, that, memmove__Lorg_eclipse_swt_internal_mozilla_nsID_2JI_FUNC);
}
#endif

#ifndef NO_memmove___3BJI
JNIEXPORT void JNICALL XPCOM_NATIVE(memmove___3BJI)
	(JNIEnv *env, jclass that, jbyteArray arg0, jlong arg1, jint arg2)
{
	jbyte *lparg0=NULL;
	XPCOM_NATIVE_ENTER(env, that, memmove___3BJI_FUNC);
	if (arg0) if ((lparg0 = env->GetByteArrayElements(arg0, NULL)) == NULL) goto fail;
	memmove((void *)lparg0, (const void *)arg1, (size_t)arg2);
fail:
	if (arg0 && lparg0) env->ReleaseByteArrayElements(arg0, lparg0, 0);
	XPCOM_NATIVE_EXIT(env, that, memmove___3BJI_FUNC);
}
#endif

#ifndef NO_memmove___3B_3CI
JNIEXPORT void JNICALL XPCOM_NATIVE(memmove___3B_3CI)
	(JNIEnv *env, jclass that, jbyteArray arg0, jcharArray arg1, jint arg2)
{
	jbyte *lparg0=NULL;
	jchar *lparg1=NULL;
	XPCOM_NATIVE_ENTER(env, that, memmove___3B_3CI_FUNC);
	if (arg0) if ((lparg0 = env->GetByteArrayElements(arg0, NULL)) == NULL) goto fail;
	if (arg1) if ((lparg1 = env->GetCharArrayElements(arg1, NULL)) == NULL) goto fail;
	memmove((void *)lparg0, (const void *)lparg1, (size_t)arg2);
fail:
	if (arg1 && lparg1) env->ReleaseCharArrayElements(arg1, lparg1, 0);
	if (arg0 && lparg0) env->ReleaseByteArrayElements(arg0, lparg0, 0);
	XPCOM_NATIVE_EXIT(env, that, memmove___3B_3CI_FUNC);
}
#endif

#ifndef NO_memmove___3CJI
JNIEXPORT void JNICALL XPCOM_NATIVE(memmove___3CJI)
	(JNIEnv *env, jclass that, jcharArray arg0, jlong arg1, jint arg2)
{
	jchar *lparg0=NULL;
	XPCOM_NATIVE_ENTER(env, that, memmove___3CJI_FUNC);
	if (arg0) if ((lparg0 = env->GetCharArrayElements(arg0, NULL)) == NULL) goto fail;
	memmove((void *)lparg0, (const void *)arg1, (size_t)arg2);
fail:
	if (arg0 && lparg0) env->ReleaseCharArrayElements(arg0, lparg0, 0);
	XPCOM_NATIVE_EXIT(env, that, memmove___3CJI_FUNC);
}
#endif

#ifndef NO_memmove___3IJI
JNIEXPORT void JNICALL XPCOM_NATIVE(memmove___3IJI)
	(JNIEnv *env, jclass that, jintArray arg0, jlong arg1, jint arg2)
{
	jint *lparg0=NULL;
	XPCOM_NATIVE_ENTER(env, that, memmove___3IJI_FUNC);
	if (arg0) if ((lparg0 = env->GetIntArrayElements(arg0, NULL)) == NULL) goto fail;
	memmove((void *)lparg0, (const void *)arg1, (size_t)arg2);
fail:
	if (arg0 && lparg0) env->ReleaseIntArrayElements(arg0, lparg0, 0);
	XPCOM_NATIVE_EXIT(env, that, memmove___3IJI_FUNC);
}
#endif

#ifndef NO_memmove___3JJI
JNIEXPORT void JNICALL XPCOM_NATIVE(memmove___3JJI)
	(JNIEnv *env, jclass that, jlongArray arg0, jlong arg1, jint arg2)
{
	jlong *lparg0=NULL;
	XPCOM_NATIVE_ENTER(env, that, memmove___3JJI_FUNC);
	if (arg0) if ((lparg0 = env->GetLongArrayElements(arg0, NULL)) == NULL) goto fail;
	memmove((void *)lparg0, (const void *)arg1, (size_t)arg2);
fail:
	if (arg0 && lparg0) env->ReleaseLongArrayElements(arg0, lparg0, 0);
	XPCOM_NATIVE_EXIT(env, that, memmove___3JJI_FUNC);
}
#endif

#ifndef NO_nsEmbedCString_1Length
JNIEXPORT jint JNICALL XPCOM_NATIVE(nsEmbedCString_1Length)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, nsEmbedCString_1Length_FUNC);
	rc = (jint)((nsEmbedCString *)arg0)->Length();
	XPCOM_NATIVE_EXIT(env, that, nsEmbedCString_1Length_FUNC);
	return rc;
}
#endif

#ifndef NO_nsEmbedCString_1delete
JNIEXPORT void JNICALL XPCOM_NATIVE(nsEmbedCString_1delete)
	(JNIEnv *env, jclass that, jlong arg0)
{
	XPCOM_NATIVE_ENTER(env, that, nsEmbedCString_1delete_FUNC);
	delete (nsEmbedCString *)arg0;
	XPCOM_NATIVE_EXIT(env, that, nsEmbedCString_1delete_FUNC);
}
#endif

#ifndef NO_nsEmbedCString_1get
JNIEXPORT jlong JNICALL XPCOM_NATIVE(nsEmbedCString_1get)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	XPCOM_NATIVE_ENTER(env, that, nsEmbedCString_1get_FUNC);
	rc = (jlong)((nsEmbedCString *)arg0)->get();
	XPCOM_NATIVE_EXIT(env, that, nsEmbedCString_1get_FUNC);
	return rc;
}
#endif

#ifndef NO_nsEmbedCString_1new__
JNIEXPORT jlong JNICALL XPCOM_NATIVE(nsEmbedCString_1new__)
	(JNIEnv *env, jclass that)
{
	jlong rc = 0;
	XPCOM_NATIVE_ENTER(env, that, nsEmbedCString_1new___FUNC);
	rc = (jlong)new nsEmbedCString();
	XPCOM_NATIVE_EXIT(env, that, nsEmbedCString_1new___FUNC);
	return rc;
}
#endif

#ifndef NO_nsEmbedCString_1new___3BI
JNIEXPORT jlong JNICALL XPCOM_NATIVE(nsEmbedCString_1new___3BI)
	(JNIEnv *env, jclass that, jbyteArray arg0, jint arg1)
{
	jbyte *lparg0=NULL;
	jlong rc = 0;
	XPCOM_NATIVE_ENTER(env, that, nsEmbedCString_1new___3BI_FUNC);
	if (arg0) if ((lparg0 = env->GetByteArrayElements(arg0, NULL)) == NULL) goto fail;
	rc = (jlong)new nsEmbedCString((const char *)lparg0, arg1);
fail:
	if (arg0 && lparg0) env->ReleaseByteArrayElements(arg0, lparg0, 0);
	XPCOM_NATIVE_EXIT(env, that, nsEmbedCString_1new___3BI_FUNC);
	return rc;
}
#endif

#ifndef NO_nsEmbedString_1Length
JNIEXPORT jint JNICALL XPCOM_NATIVE(nsEmbedString_1Length)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, nsEmbedString_1Length_FUNC);
	rc = (jint)((nsEmbedString *)arg0)->Length();
	XPCOM_NATIVE_EXIT(env, that, nsEmbedString_1Length_FUNC);
	return rc;
}
#endif

#ifndef NO_nsEmbedString_1delete
JNIEXPORT void JNICALL XPCOM_NATIVE(nsEmbedString_1delete)
	(JNIEnv *env, jclass that, jlong arg0)
{
	XPCOM_NATIVE_ENTER(env, that, nsEmbedString_1delete_FUNC);
	delete (nsEmbedString *)arg0;
	XPCOM_NATIVE_EXIT(env, that, nsEmbedString_1delete_FUNC);
}
#endif

#ifndef NO_nsEmbedString_1get
JNIEXPORT jlong JNICALL XPCOM_NATIVE(nsEmbedString_1get)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	XPCOM_NATIVE_ENTER(env, that, nsEmbedString_1get_FUNC);
	rc = (jlong)((nsEmbedString *)arg0)->get();
	XPCOM_NATIVE_EXIT(env, that, nsEmbedString_1get_FUNC);
	return rc;
}
#endif

#ifndef NO_nsEmbedString_1new__
JNIEXPORT jlong JNICALL XPCOM_NATIVE(nsEmbedString_1new__)
	(JNIEnv *env, jclass that)
{
	jlong rc = 0;
	XPCOM_NATIVE_ENTER(env, that, nsEmbedString_1new___FUNC);
	rc = (jlong)new nsEmbedString();
	XPCOM_NATIVE_EXIT(env, that, nsEmbedString_1new___FUNC);
	return rc;
}
#endif

#ifndef NO_nsEmbedString_1new___3C
JNIEXPORT jlong JNICALL XPCOM_NATIVE(nsEmbedString_1new___3C)
	(JNIEnv *env, jclass that, jcharArray arg0)
{
	jchar *lparg0=NULL;
	jlong rc = 0;
	XPCOM_NATIVE_ENTER(env, that, nsEmbedString_1new___3C_FUNC);
	if (arg0) if ((lparg0 = env->GetCharArrayElements(arg0, NULL)) == NULL) goto fail;
	rc = (jlong)new nsEmbedString(lparg0);
fail:
	if (arg0 && lparg0) env->ReleaseCharArrayElements(arg0, lparg0, 0);
	XPCOM_NATIVE_EXIT(env, that, nsEmbedString_1new___3C_FUNC);
	return rc;
}
#endif

#ifndef NO_nsID_1Equals
JNIEXPORT jboolean JNICALL XPCOM_NATIVE(nsID_1Equals)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	jboolean rc = 0;
	XPCOM_NATIVE_ENTER(env, that, nsID_1Equals_FUNC);
	rc = (jboolean)((nsID *)arg0)->Equals(*(nsID *)arg1);
	XPCOM_NATIVE_EXIT(env, that, nsID_1Equals_FUNC);
	return rc;
}
#endif

#ifndef NO_nsID_1Parse
JNIEXPORT jboolean JNICALL XPCOM_NATIVE(nsID_1Parse)
	(JNIEnv *env, jclass that, jlong arg0, jstring arg1)
{
	const char *lparg1= NULL;
	jboolean rc = 0;
	XPCOM_NATIVE_ENTER(env, that, nsID_1Parse_FUNC);
	if (arg1) if ((lparg1 = env->GetStringUTFChars(arg1, NULL)) == NULL) goto fail;
	rc = (jboolean)((nsID *)arg0)->Parse((const char *)lparg1);
fail:
	if (arg1 && lparg1) env->ReleaseStringUTFChars(arg1, lparg1);
	XPCOM_NATIVE_EXIT(env, that, nsID_1Parse_FUNC);
	return rc;
}
#endif

#ifndef NO_nsID_1delete
JNIEXPORT void JNICALL XPCOM_NATIVE(nsID_1delete)
	(JNIEnv *env, jclass that, jlong arg0)
{
	XPCOM_NATIVE_ENTER(env, that, nsID_1delete_FUNC);
	delete (nsID *)arg0;
	XPCOM_NATIVE_EXIT(env, that, nsID_1delete_FUNC);
}
#endif

#ifndef NO_nsID_1new
JNIEXPORT jlong JNICALL XPCOM_NATIVE(nsID_1new)
	(JNIEnv *env, jclass that)
{
	jlong rc = 0;
	XPCOM_NATIVE_ENTER(env, that, nsID_1new_FUNC);
	rc = (jlong)new nsID();
	XPCOM_NATIVE_EXIT(env, that, nsID_1new_FUNC);
	return rc;
}
#endif

#ifndef NO_strlen
JNIEXPORT jint JNICALL XPCOM_NATIVE(strlen)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, strlen_FUNC);
	rc = (jint)strlen((char *)arg0);
	XPCOM_NATIVE_EXIT(env, that, strlen_FUNC);
	return rc;
}
#endif

}
