/****************************************************************************
 *			Tuning and Analysis Utilities
 *			http://www.cs.uoregon.edu/research/paracomp/tau
 ****************************************************************************
 * Copyright (c) 1997-2006
 *    Department of Computer and Information Science, University of Oregon
 *    Advanced Computing Laboratory, Los Alamos National Laboratory
 *    Research Center Juelich, ZAM Germany	
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Wyatt Spear - initial API and implementation
 ****************************************************************************/
package org.eclipse.ptp.tau.toolopts;

import java.util.ArrayList;
import java.util.Stack;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/**
 * A sax parser handler implementation that generates a tool-pane from a supplied XML file
 * @author wspear
 *
 */
public class ToolParser extends DefaultHandler{
	/**
	 * Top level element of a single analysis tool
	 */
	private static final String TOOL = "tool";
	
	/**
	 * Top level element of the compilation phase of analysis
	 */
	private static final String COMPILE = "compile";
	
	private static final String CC = "cc";
	private static final String CXX = "cxx";
	private static final String F90 = "f90";
	private static final String ALLCOMP = "allcompilers";
	
	
	
	/**
	 * Top level element of the execution phase of analysis
	 */
	private static final String EXECUTE="execute";
	
	
	/**
	 * Top level element of the analysis phase of analysis
	 */
	private static final String ANALYZE = "analyze";
	
	private static final String PROCESS = "process";
	private static final String VIEW = "view";
	
	/**
	 * Top level element of options pane definition structure
	 */
	private static final String OPTIONS = "options";
	private static final String TOGOPT = "togoption";
	private static final String LABEL = "label";
	private static final String TIP = "tooltip";
	private static final String NAME = "optname";
	private static final String VALUE = "optvalue";
	private static final String DEFAULT = "default";
	
	/**
	 * Command to search for the path to the executables for a given tool (redundant?)
	 */
	private static final String PATHHINT = "pathhint";
	
	//TODO: Support arguments/tool-panes for compilers, exec-utils and analysis tools!
	/**
	 * Element to specify an argument to a compiler, run utility or analysis tool
	 */
	private static final String ARGUMENT="arg";

	

	//private static final String PATHTEXT = "pathtext";
	//private static final String PATHMESSAGE = "pathmessage";
	
	private boolean incomp=false;
	private boolean analysis=false;
	private boolean execution=false;
	private Stack tagStack = new Stack();
	protected ArrayList performanceTools= new ArrayList();
	private PerformanceTool currentTool;
	private ArrayList toolPanes;// = new ArrayList();
	private ArrayList analysisCommands;
	private ArrayList toolOptions;
	private ToolOption actOpt;
	private Stack content = new Stack();
	
	public void characters(char[] chars, int start, int len)
	{
		((StringBuffer)content.peek()).append(chars, start, len);
	}
	
	public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
		name=name.toLowerCase();
		if(name.equals(TOOL))
		{
			//performanceTools.add(new PerformanceTool());
			toolPanes=new ArrayList();
			currentTool=new PerformanceTool();
		}
		else if(name.equals(COMPILE))
		{
			incomp=true;
			if(currentTool!=null)
			{
				currentTool.recompile=true;
				int repdex = atts.getIndex("replace");
				if(repdex>=0)
				{
					if(atts.getValue(repdex).toLowerCase().equals("true"))
						currentTool.replaceCompiler=true;
				}
			}
		}
		else if(name.equals(OPTIONS))
		{
			toolOptions=new ArrayList();
		}
		else if(name.equals(TOGOPT))
		{
			actOpt=new ToolOption();
			int defdex = atts.getIndex("defstate");
			if(defdex>=0)
			{
				if(atts.getValue(defdex).toLowerCase().equals("on"))
					actOpt.defState=true;
			}
		}
		else if(name.equals(NAME))
		{
			if(actOpt!=null&&tagStack.peek().equals(TOGOPT))
			{
				int eqdex = atts.getIndex("equals");
				if(eqdex>=0)
				{
					String useeq = atts.getValue(eqdex).toLowerCase();
					if(useeq.equals("false"))
					{
						actOpt.useEquals=false;
					}
				}
			}
		}
		else if(name.equals(VALUE))
		{
			if(actOpt!=null&&tagStack.peek().equals(TOGOPT))
			{
				int typedex = atts.getIndex("type");
				if(typedex>=0)
				{
					String type = atts.getValue(typedex).toLowerCase();
					if(type.equals("text"))
						actOpt.type=ToolOption.TEXT;
					else if(type.equals("dir"))
						actOpt.type=ToolOption.DIR;
					else if(type.equals("file"))
						actOpt.type=ToolOption.FILE;
					else if(type.equals("number"))
						actOpt.type=ToolOption.NUMBER;
					else if(type.equals("combo"))
						actOpt.type=ToolOption.COMBO;
				}
			}
		}
		else if(name.equals(ANALYZE)&&!analysis)
		{
			analysis=true;
			analysisCommands=new ArrayList();
		}
		else if(name.equals(EXECUTE)&&!execution)
		{
			execution=true;
			//executionUtil=new ArrayList();
		}
		
		tagStack.push(name.toLowerCase());
		content.push(new StringBuffer());
	}
	public void endElement(String uri, String localName, String name) throws SAXException {
		name = name.toLowerCase();
		if(name.equals(TOOL))
		{
			if(toolPanes!=null&&toolPanes.size()>0)
			{
				currentTool.toolPanes=new ToolPane[toolPanes.size()];//toolPanes.toArray(currentTool.toolPanes);
				toolPanes.toArray(currentTool.toolPanes);
			}
			if(analysisCommands!=null&&analysisCommands.size()>0)
			{
				currentTool.analysisCommands=analysisCommands;
			}
			currentTool.toolID=currentTool.toolName=content.peek().toString().trim();
			performanceTools.add(currentTool);
		}//Compilation specific attributes
		else if(name.equals(CC)&&incomp)
		{
			if(currentTool!=null)
				currentTool.ccCompiler=content.peek().toString().trim();
		}
		else if(name.equals(CXX)&&incomp)
		{
			if(currentTool!=null)
				currentTool.cxxCompiler=content.peek().toString().trim();
		}
		else if(name.equals(F90)&&incomp)
		{
			if(currentTool!=null)
				currentTool.f90Compiler=content.peek().toString().trim();
		}
		else if(name.equals(PATHHINT)&&incomp)
		{
			if(currentTool!=null)
				currentTool.pathFinder=content.peek().toString().trim();
		}
		else if(name.equals(ALLCOMP)&&incomp)
		{
			if(currentTool!=null)
			{
				String allcomp=content.peek().toString().trim();
				currentTool.ccCompiler=allcomp;
				currentTool.cxxCompiler=allcomp;
				currentTool.f90Compiler=allcomp;
				currentTool.pathFinder=allcomp;
			}
		}
		else if(name.equals(COMPILE))
		{
			incomp=false;
		}
		else if(name.equals(OPTIONS))
		{
			if(toolOptions!=null)
			{
				toolPanes.add(new ToolPane(((StringBuffer)content.peek()).toString(), toolOptions));

			}
		}
		else if(name.equals(TOGOPT))
		{
			if(actOpt!=null)
			{
				actOpt=ToolMaker.finishToolOption(actOpt);
				toolOptions.add(actOpt);
			}
		}
		else if(name.equals(TIP))
		{
			if(actOpt!=null)
				actOpt.toolTip=content.peek().toString();
		}
		else if(name.equals(LABEL))
		{
			if(actOpt!=null)
				actOpt.optLabel=content.peek().toString();
		}
		else if(name.equals(NAME))
		{
			if(actOpt!=null)
			{
				actOpt.optName=content.peek().toString();
			}
		}
		else if(name.equals(DEFAULT))
		{
			if(actOpt!=null)
				actOpt.optLabel=content.peek().toString();
		}
		else if(name.equals(EXECUTE)&&execution)
		{
			if(currentTool!=null)
			{
				currentTool.prependExecution=true;
				currentTool.prependWith=content.peek().toString().trim();
			}
			execution=false;
		}
		else if(name.equals(PROCESS)||name.equals(VIEW)&&analysis)
		{
			analysisCommands.add(content.peek().toString().trim());
		}
		else if(name.equals(ANALYZE)&&analysis)
		{
			analysis=false;
		}
		
		tagStack.pop();
		content.pop();
	}

}
