/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.mpi.openmpi.ui.wizards;

import org.eclipse.ptp.core.Preferences;
import org.eclipse.ptp.rm.mpi.openmpi.core.OpenMPIPlugin;
import org.eclipse.ptp.rm.mpi.openmpi.core.rmsystem.IOpenMPIResourceManagerConfiguration;
import org.eclipse.ptp.rm.mpi.openmpi.ui.messages.Messages;
import org.eclipse.ptp.rm.ui.utils.DataSource;
import org.eclipse.ptp.rm.ui.wizards.AbstractConfigurationWizardPage;
import org.eclipse.ptp.rm.ui.wizards.AbstractToolRMConfigurationWizardPage;
import org.eclipse.ptp.rm.ui.wizards.WizardPageDataSource;
import org.eclipse.ptp.rm.ui.wizards.WizardPageWidgetListener;
import org.eclipse.ptp.rmsystem.IResourceManagerComponentConfiguration;
import org.eclipse.ptp.ui.wizards.IRMConfigurationWizard;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class OpenMPIConfigurationWizardPage
extends AbstractToolRMConfigurationWizardPage {
    protected final String[] versionIds = new String[]{"auto", "1.2", "1.3", "1.4"};
    private final String[] versionsNames = new String[]{Messages.OpenMPIConfigurationWizardPage_VersionCombo_Auto, Messages.OpenMPIConfigurationWizardPage_VersionCombo_Version12, Messages.OpenMPIConfigurationWizardPage_VersionCombo_Version13, Messages.OpenMPIConfigurationWizardPage_VersionCombo_Version14};
    protected Combo versionCombo;

    protected WizardPageWidgetListener createListener() {
        return new WidgetListener();
    }

    protected WizardPageDataSource createDataSource() {
        return new DataSource((AbstractConfigurationWizardPage)this);
    }

    public OpenMPIConfigurationWizardPage(IRMConfigurationWizard wizard) {
        super(wizard, 19, Messages.OpenMPIConfigurationWizardPage_Name, Messages.OpenMPIConfigurationWizardPage_Title, Messages.OpenMPIConfigurationWizardPage_Description);
    }

    protected Composite doCreateContents(Composite parent) {
        Composite contents = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.marginRight = 0;
        layout.marginLeft = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        contents.setLayout((Layout)layout);
        this.createVersionContents(contents);
        this.createContents(contents);
        return contents;
    }

    protected void createVersionContents(Composite parent) {
        Composite contents = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        contents.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        contents.setLayoutData((Object)gd);
        Label label = new Label(contents, 0);
        label.setText(Messages.OpenMPIConfigurationWizardPage_Label_Version);
        this.versionCombo = new Combo(contents, 12);
        int i = 0;
        while (i < this.versionsNames.length) {
            this.versionCombo.add(this.versionsNames[i]);
            ++i;
        }
        this.versionCombo.addSelectionListener((SelectionListener)this.getWidgetListener());
    }

    public void handleVersionSelected() {
        this.getWidgetListener().disable();
        DataSource dataSource = (DataSource)this.getDataSource();
        dataSource.justValidate();
        this.resetErrorMessages();
        this.setToolCommandDefaults();
        this.setInstallPathDefaults();
        dataSource.copyToFields();
        this.getWidgetListener().enable();
    }

    protected void setToolCommandDefaults() {
        DataSource dataSource = (DataSource)this.getDataSource();
        String launchCmd = null;
        String debugCmd = null;
        String discoverCmd = null;
        boolean enabled = true;
        if (dataSource.getVersionId().equals("auto")) {
            launchCmd = Preferences.getString((String)OpenMPIPlugin.getUniqueIdentifier(), (String)"openmpi-auto-launchCmd");
            debugCmd = Preferences.getString((String)OpenMPIPlugin.getUniqueIdentifier(), (String)"openmpi-auto-debugCmd");
            discoverCmd = Preferences.getString((String)OpenMPIPlugin.getUniqueIdentifier(), (String)"openmpi-auto-discoverCmd");
            enabled = false;
        } else if (dataSource.getVersionId().equals("1.2")) {
            launchCmd = Preferences.getString((String)OpenMPIPlugin.getUniqueIdentifier(), (String)"openmpi-1.2-launchCmd");
            debugCmd = Preferences.getString((String)OpenMPIPlugin.getUniqueIdentifier(), (String)"openmpi-1.2-debugCmd");
            discoverCmd = Preferences.getString((String)OpenMPIPlugin.getUniqueIdentifier(), (String)"openmpi-1.2-discoverCmd");
        } else if (dataSource.getVersionId().equals("1.3")) {
            launchCmd = Preferences.getString((String)OpenMPIPlugin.getUniqueIdentifier(), (String)"openmpi-1.3-launchCmd");
            debugCmd = Preferences.getString((String)OpenMPIPlugin.getUniqueIdentifier(), (String)"openmpi-1.3-debugCmd");
            discoverCmd = Preferences.getString((String)OpenMPIPlugin.getUniqueIdentifier(), (String)"openmpi-1.3-discoverCmd");
        } else if (dataSource.getVersionId().equals("1.4")) {
            launchCmd = Preferences.getString((String)OpenMPIPlugin.getUniqueIdentifier(), (String)"openmpi-1.4-launchCmd");
            debugCmd = Preferences.getString((String)OpenMPIPlugin.getUniqueIdentifier(), (String)"openmpi-1.4-debugCmd");
            discoverCmd = Preferences.getString((String)OpenMPIPlugin.getUniqueIdentifier(), (String)"openmpi-1.4-discoverCmd");
        } else assert (false);
        dataSource.setCommands(launchCmd, debugCmd, discoverCmd, null, 0, null);
        dataSource.setCommandsEnabled(enabled);
        dataSource.setUseDefaults(true);
    }

    protected void setInstallPathDefaults() {
        DataSource dataSource = (DataSource)this.getDataSource();
        String remoteInstallPath = null;
        if (dataSource.getVersionId().equals("auto")) {
            remoteInstallPath = Preferences.getString((String)OpenMPIPlugin.getUniqueIdentifier(), (String)"openmpi-auto-remoteInstallPath");
        } else if (dataSource.getVersionId().equals("1.2")) {
            remoteInstallPath = Preferences.getString((String)OpenMPIPlugin.getUniqueIdentifier(), (String)"openmpi-1.2-remoteInstallPath");
        } else if (dataSource.getVersionId().equals("1.3")) {
            remoteInstallPath = Preferences.getString((String)OpenMPIPlugin.getUniqueIdentifier(), (String)"openmpi-1.3-remoteInstallPath");
        } else if (dataSource.getVersionId().equals("1.4")) {
            remoteInstallPath = Preferences.getString((String)OpenMPIPlugin.getUniqueIdentifier(), (String)"openmpi-1.4-remoteInstallPath");
        } else assert (false);
        dataSource.setInstallPath(remoteInstallPath);
        dataSource.setInstallDefaults(true);
    }

    protected class DataSource
    extends AbstractToolRMConfigurationWizardPage.DataSource {
        private IOpenMPIResourceManagerConfiguration config;
        private String versionId;

        protected DataSource(AbstractConfigurationWizardPage page) {
            super((AbstractToolRMConfigurationWizardPage)OpenMPIConfigurationWizardPage.this, page);
            this.versionId = null;
        }

        public String getVersionId() {
            return this.versionId;
        }

        protected void copyFromFields() throws DataSource.ValidationException {
            this.versionId = OpenMPIConfigurationWizardPage.this.versionCombo.getSelectionIndex() == -1 ? null : OpenMPIConfigurationWizardPage.this.versionIds[OpenMPIConfigurationWizardPage.this.versionCombo.getSelectionIndex()];
            super.copyFromFields();
        }

        protected void copyToFields() {
            if (this.versionId == null) {
                OpenMPIConfigurationWizardPage.this.versionCombo.select(-1);
            } else {
                int i = 0;
                while (i < OpenMPIConfigurationWizardPage.this.versionIds.length) {
                    if (this.versionId.equals(OpenMPIConfigurationWizardPage.this.versionIds[i])) {
                        OpenMPIConfigurationWizardPage.this.versionCombo.select(i);
                    }
                    ++i;
                }
            }
            super.copyToFields();
        }

        protected void loadFromStorage() {
            this.versionId = this.config.getVersionId();
            super.loadFromStorage();
        }

        protected void copyToStorage() {
            this.config.setVersionId(this.versionId);
            super.copyToStorage();
        }

        protected void validateLocal() throws DataSource.ValidationException {
            if (this.versionId == null) {
                throw new DataSource.ValidationException((org.eclipse.ptp.rm.ui.utils.DataSource)this, Messages.OpenMPIConfigurationWizardPage_Validation_NoVersionSelected);
            }
            super.validateLocal();
        }

        public void setConfiguration(IResourceManagerComponentConfiguration configuration) {
            this.config = (IOpenMPIResourceManagerConfiguration)configuration;
            super.setConfiguration(configuration);
        }
    }

    protected class WidgetListener
    extends AbstractToolRMConfigurationWizardPage.WidgetListener {
        protected WidgetListener() {
            super((AbstractToolRMConfigurationWizardPage)OpenMPIConfigurationWizardPage.this);
        }

        protected void doModifyText(ModifyEvent evt) {
            super.doModifyText(evt);
        }

        public void doWidgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == OpenMPIConfigurationWizardPage.this.versionCombo) {
                OpenMPIConfigurationWizardPage.this.handleVersionSelected();
                OpenMPIConfigurationWizardPage.this.updateControls();
                OpenMPIConfigurationWizardPage.this.getDataSource().storeAndValidate();
            } else {
                super.doWidgetSelected(e);
            }
        }
    }
}

