/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.op.RemoveFromIndexOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.jgit.lib.Repository;

public class RemoveFromIndexActionHandler
extends RepositoryActionHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IResource[] sel = this.getSelectedResources(event);
        if (sel.length == 0) {
            return null;
        }
        Repository repo = this.getRepository();
        final RemoveFromIndexOperation removeOperation = new RemoveFromIndexOperation(repo, sel);
        Job job = new Job(UIText.RemoveFromIndexAction_removingFiles){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        removeOperation.execute(monitor);
                    }
                    catch (CoreException e) {
                        IStatus iStatus = Activator.createErrorStatus(e.getStatus().getMessage(), e);
                        monitor.done();
                        return iStatus;
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (JobFamilies.REMOVE_FROM_INDEX.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        job.setUser(true);
        job.setRule(removeOperation.getSchedulingRule());
        job.schedule();
        return null;
    }

    public boolean isEnabled() {
        return this.getProjectsInRepositoryOfSelectedResources().length > 0;
    }
}

