/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import java.io.IOException;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.ValidationUtils;
import org.eclipse.egit.ui.internal.dialogs.AbstractBranchSelectionDialog;
import org.eclipse.egit.ui.internal.repository.CreateBranchWizard;
import org.eclipse.egit.ui.internal.repository.tree.RefNode;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class CheckoutDialog
extends AbstractBranchSelectionDialog {
    private String currentBranch;
    private Button deleteteButton;
    private Button renameButton;
    private Button newButton;

    public CheckoutDialog(Shell parentShell, Repository repo) {
        super(parentShell, repo, 350);
        try {
            this.currentBranch = repo.getFullBranch();
        }
        catch (IOException iOException) {
            this.currentBranch = null;
        }
    }

    protected String getMessageText() {
        return UIText.CheckoutDialog_Message;
    }

    protected String getTitle() {
        return UIText.CheckoutDialog_Title;
    }

    protected String getWindowTitle() {
        return UIText.CheckoutDialog_WindowTitle;
    }

    protected void refNameSelected(String refName) {
        boolean branchSelected;
        boolean tagSelected = refName != null && refName.startsWith("refs/tags/");
        boolean bl = branchSelected = refName != null && (refName.startsWith("refs/heads/") || refName.startsWith("refs/remotes/"));
        if (((TreeSelection)this.branchTree.getSelection()).size() > 1) {
            TreeSelection selection = (TreeSelection)this.branchTree.getSelection();
            boolean onlyBranchesAreSelected = this.onlyBranchesAreSelected(selection);
            this.deleteteButton.setEnabled(onlyBranchesAreSelected);
            this.renameButton.setEnabled(false);
            this.newButton.setEnabled(false);
        } else {
            this.getButton(0).setEnabled(branchSelected || tagSelected);
            this.renameButton.setEnabled(branchSelected && !tagSelected);
            this.deleteteButton.setEnabled(branchSelected && !tagSelected);
            this.newButton.setEnabled(true);
        }
        this.getButton(0).setEnabled(refName != null && !refName.equals(this.currentBranch));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.newButton = new Button(parent, 8);
        this.newButton.setFont(JFaceResources.getDialogFont());
        this.newButton.setText(UIText.CheckoutDialog_NewBranch);
        this.setButtonLayoutData(this.newButton);
        ++((GridLayout)parent.getLayout()).numColumns;
        this.renameButton = new Button(parent, 8);
        this.renameButton.setFont(JFaceResources.getDialogFont());
        this.renameButton.setText(UIText.CheckoutDialog_Rename);
        this.setButtonLayoutData(this.renameButton);
        ++((GridLayout)parent.getLayout()).numColumns;
        this.deleteteButton = new Button(parent, 8);
        this.deleteteButton.setFont(JFaceResources.getDialogFont());
        this.deleteteButton.setText(UIText.CheckoutDialog_Delete);
        this.setButtonLayoutData(this.deleteteButton);
        ++((GridLayout)parent.getLayout()).numColumns;
        this.renameButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String refPrefix;
                String refName = CheckoutDialog.this.refNameFromDialog();
                if (refName.startsWith("refs/heads/")) {
                    refPrefix = "refs/heads/";
                } else if (refName.startsWith("refs/remotes/")) {
                    refPrefix = "refs/remotes/";
                } else if (refName.startsWith("refs/tags/")) {
                    refPrefix = "refs/tags/";
                } else {
                    return;
                }
                String branchName = refName.substring(refPrefix.length());
                InputDialog labelDialog = CheckoutDialog.this.getRefNameInputDialog(NLS.bind((String)UIText.CheckoutDialog_QuestionNewBranchNameMessage, (Object)branchName, (Object)refPrefix), refPrefix, branchName);
                if (labelDialog.open() == 0) {
                    String newRefName = String.valueOf(refPrefix) + labelDialog.getValue();
                    try {
                        new Git(CheckoutDialog.this.repo).branchRename().setOldName(refName).setNewName(labelDialog.getValue()).call();
                        CheckoutDialog.this.branchTree.refresh();
                        CheckoutDialog.this.markRef(newRefName);
                    }
                    catch (Throwable e1) {
                        CheckoutDialog.this.reportError(e1, UIText.CheckoutDialog_ErrorCouldNotRenameRef, new Object[]{refName, newRefName, e1.getMessage()});
                    }
                }
            }
        });
        this.newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateBranchWizard wiz = new CreateBranchWizard(CheckoutDialog.this.repo, CheckoutDialog.this.refNameFromDialog());
                if (new WizardDialog(CheckoutDialog.this.getShell(), (IWizard)wiz).open() == 0) {
                    String newRefName = wiz.getNewBranchName();
                    try {
                        CheckoutDialog.this.branchTree.refresh();
                        CheckoutDialog.this.markRef("refs/heads/" + newRefName);
                        if (CheckoutDialog.this.repo.getBranch().equals(newRefName)) {
                            CheckoutDialog.this.okPressed();
                        }
                    }
                    catch (Throwable e1) {
                        CheckoutDialog.this.reportError(e1, UIText.CheckoutDialog_ErrorCouldNotCreateNewRef, new Object[]{newRefName});
                    }
                }
            }
        });
        this.deleteteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                try {
                    CommonUtils.runCommand("org.eclipse.ui.edit.delete", (IStructuredSelection)CheckoutDialog.this.branchTree.getSelection());
                    CheckoutDialog.this.branchTree.refresh();
                }
                catch (Throwable e) {
                    CheckoutDialog.this.reportError(e, UIText.CheckoutDialog_ErrorCouldNotDeleteRef, new Object[]{CheckoutDialog.this.refNameFromDialog()});
                }
            }
        });
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setText(UIText.CheckoutDialog_OkCheckout);
        this.getButton(0).setEnabled(!this.branchTree.getSelection().isEmpty());
    }

    private InputDialog getRefNameInputDialog(String prompt, String refPrefix, String initialValue) {
        InputDialog labelDialog = new InputDialog(this.getShell(), UIText.CheckoutDialog_QuestionNewBranchTitle, prompt, initialValue, ValidationUtils.getRefNameInputValidator(this.repo, refPrefix, true));
        labelDialog.setBlockOnOpen(true);
        return labelDialog;
    }

    private void reportError(Throwable e, String message, Object ... args) {
        String msg = NLS.bind((String)message, (Object[])args);
        Activator.handleError(msg, e, true);
    }

    private boolean onlyBranchesAreSelected(TreeSelection selection) {
        for (Object sel : selection) {
            if (sel instanceof RefNode) {
                RefNode node = (RefNode)sel;
                String refName = ((Ref)node.getObject()).getName();
                if (refName.startsWith("refs/heads/") || refName.startsWith("refs/remotes/")) continue;
                return false;
            }
            return false;
        }
        return true;
    }
}

