/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.util.GitDateFormatter;
import org.eclipse.swt.graphics.Image;

class GraphLabelProvider
extends BaseLabelProvider
implements ITableLabelProvider {
    private GitDateFormatter dateFormatter;
    private RevCommit lastCommit;
    private PersonIdent lastAuthor;
    private PersonIdent lastCommitter;
    private GitDateFormatter.Format format = GitDateFormatter.Format.LOCALE;

    GraphLabelProvider() {
    }

    public String getColumnText(Object element, int columnIndex) {
        PersonIdent committer;
        PersonIdent author;
        RevCommit c = (RevCommit)element;
        if (columnIndex == 0) {
            return c.getShortMessage();
        }
        if (columnIndex == 3) {
            return String.valueOf(c.getId().abbreviate(8).name()) + "...";
        }
        if ((columnIndex == 1 || columnIndex == 2) && (author = this.authorOf(c)) != null) {
            switch (columnIndex) {
                case 1: {
                    return String.valueOf(author.getName()) + " <" + author.getEmailAddress() + ">";
                }
                case 2: {
                    return this.getDateFormatter().formatDate(author);
                }
            }
        }
        if (columnIndex == 4 && (committer = this.committerOf(c)) != null) {
            return String.valueOf(committer.getName()) + " <" + committer.getEmailAddress() + ">";
        }
        return "";
    }

    private GitDateFormatter getDateFormatter() {
        if (this.dateFormatter == null) {
            this.dateFormatter = new GitDateFormatter(this.format);
        }
        return this.dateFormatter;
    }

    private PersonIdent authorOf(RevCommit c) {
        if (this.lastCommit != c) {
            this.lastCommit = c;
            this.lastAuthor = c.getAuthorIdent();
            this.lastCommitter = c.getCommitterIdent();
        }
        return this.lastAuthor;
    }

    private PersonIdent committerOf(RevCommit c) {
        if (this.lastCommit != c) {
            this.lastCommit = c;
            this.lastAuthor = c.getAuthorIdent();
            this.lastCommitter = c.getCommitterIdent();
        }
        return this.lastCommitter;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public void setRelativeDate(boolean relative) {
        this.dateFormatter = null;
        this.format = relative ? GitDateFormatter.Format.RELATIVE : GitDateFormatter.Format.LOCALE;
    }
}

