/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.preferences;

import java.util.StringTokenizer;
import org.eclipse.egit.ui.UIText;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jgit.lib.Config;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddConfigEntryDialog
extends TitleAreaDialog {
    private Text keyText;
    private Text valueText;
    private String key;
    private String value;
    private final Config currentConfig;
    private final String suggestedKey;

    public AddConfigEntryDialog(Shell parentShell, Config config, String suggestedKey) {
        super(parentShell);
        this.setHelpAvailable(false);
        this.currentConfig = config;
        this.suggestedKey = suggestedKey;
        this.setHelpAvailable(false);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(UIText.AddConfigEntryDialog_AddConfigTitle);
        this.setTitle(UIText.AddConfigEntryDialog_AddConfigTitle);
        this.setMessage(UIText.AddConfigEntryDialog_DialogMessage);
        Composite titleParent = (Composite)super.createDialogArea(parent);
        Composite main = new Composite(titleParent, 0);
        main.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)main);
        Label keylLabel = new Label(main, 0);
        keylLabel.setText(UIText.AddConfigEntryDialog_KeyLabel);
        keylLabel.setToolTipText(UIText.AddConfigEntryDialog_ConfigKeyTooltip);
        this.keyText = new Text(main, 2048);
        if (this.suggestedKey != null) {
            this.keyText.setText(this.suggestedKey);
            this.keyText.selectAll();
        }
        this.keyText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddConfigEntryDialog.this.check();
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.keyText);
        new Label(main, 0).setText(UIText.AddConfigEntryDialog_ValueLabel);
        this.valueText = new Text(main, 2048);
        this.valueText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddConfigEntryDialog.this.check();
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.valueText);
        AddConfigEntryDialog.applyDialogFont((Control)main);
        return main;
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(false);
    }

    private void check() {
        boolean hasError;
        block10: {
            block9: {
                StringTokenizer st;
                block8: {
                    block7: {
                        this.setErrorMessage(null);
                        hasError = false;
                        try {
                            if (this.keyText.getText().length() != 0) break block7;
                            this.setErrorMessage(UIText.AddConfigEntryDialog_MustEnterKeyMessage);
                            hasError = true;
                        }
                        catch (Throwable throwable) {
                            this.getButton(0).setEnabled(!hasError);
                            throw throwable;
                        }
                        this.getButton(0).setEnabled(!hasError);
                        return;
                    }
                    st = new StringTokenizer(this.keyText.getText(), ".");
                    if (st.countTokens() >= 2 && st.countTokens() <= 3) break block8;
                    this.setErrorMessage(UIText.AddConfigEntryDialog_KeyComponentsMessage);
                    hasError = true;
                    this.getButton(0).setEnabled(!hasError);
                    return;
                }
                boolean exists = false;
                if (st.countTokens() == 2) {
                    boolean bl = exists = this.currentConfig.getString(st.nextToken(), null, st.nextToken()) != null;
                }
                if (st.countTokens() == 3) {
                    boolean bl = exists = this.currentConfig.getString(st.nextToken(), st.nextToken(), st.nextToken()) != null;
                }
                if (!exists) break block9;
                this.setErrorMessage(NLS.bind((String)UIText.AddConfigEntryDialog_EntryExistsMessage, (Object)this.keyText.getText()));
                hasError = true;
                this.getButton(0).setEnabled(!hasError);
                return;
            }
            if (this.valueText.getText().length() != 0) break block10;
            this.setErrorMessage(UIText.AddConfigEntryDialog_EnterValueMessage);
            hasError = true;
            this.getButton(0).setEnabled(!hasError);
            return;
        }
        this.getButton(0).setEnabled(!hasError);
    }

    protected void okPressed() {
        this.key = this.keyText.getText();
        this.value = this.valueText.getText();
        super.okPressed();
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }
}

