/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize;

import java.io.File;
import java.util.List;
import org.eclipse.egit.ui.UIIcons;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.synchronize.RemoteSelectionCombo;
import org.eclipse.egit.ui.internal.synchronize.SyncRepoEntity;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectSynchronizeResourceDialog
extends TitleAreaDialog {
    private String dstRef;
    private String srcRef;
    private final String repoName;
    private boolean shouldIncludeLocal = true;
    private final List<SyncRepoEntity> syncRepos;
    private RemoteSelectionCombo dstRefCombo;
    private RemoteSelectionCombo srcRefCombo;
    private Button shouldIncludeLocalButton;

    public SelectSynchronizeResourceDialog(Shell parent, File repoDirectory, List<SyncRepoEntity> syncRepos) {
        super(parent);
        this.repoName = String.valueOf(repoDirectory.getParentFile().getName()) + File.separator + repoDirectory.getName();
        this.syncRepos = syncRepos;
        this.setHelpAvailable(false);
    }

    public String getValue() {
        return this.dstRef;
    }

    public String getDstRef() {
        return this.dstRef;
    }

    public String getSrcRef() {
        return this.srcRef;
    }

    public boolean shouldIncludeLocal() {
        return this.shouldIncludeLocal;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        GridData data = new GridData(772);
        data.widthHint = this.convertHorizontalDLUsToPixels(150);
        this.shouldIncludeLocalButton = new Button(composite, 96);
        this.shouldIncludeLocalButton.setText(UIText.SelectSynchronizeResourceDialog_includeUncommitedChanges);
        this.shouldIncludeLocalButton.setSelection(true);
        final Label srcRefLabel = new Label(composite, 64);
        srcRefLabel.setText(UIText.SelectSynchronizeResourceDialog_srcRef);
        srcRefLabel.setEnabled(false);
        this.shouldIncludeLocalButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean includeLocal = SelectSynchronizeResourceDialog.this.shouldIncludeLocalButton.getSelection();
                SelectSynchronizeResourceDialog.this.srcRefCombo.setEnabled(!includeLocal);
                srcRefLabel.setEnabled(!includeLocal);
                if (includeLocal) {
                    SelectSynchronizeResourceDialog.this.srcRefCombo.setDefaultValue(UIText.SynchronizeWithAction_localRepoName, "HEAD");
                }
            }
        });
        this.srcRefCombo = new RemoteSelectionCombo(composite, this.syncRepos, UIText.RemoteSelectionCombo_sourceName, UIText.RemoteSelectionCombo_sourceRef);
        this.srcRefCombo.setDefaultValue(UIText.SynchronizeWithAction_localRepoName, "HEAD");
        this.srcRefCombo.setLayoutData(data);
        this.srcRefCombo.setLayoutData(GridDataFactory.fillDefaults().grab(true, false).create());
        this.srcRefCombo.setEnabled(false);
        new Label(composite, 64).setText(UIText.SelectSynchronizeResourceDialog_dstRef);
        this.dstRefCombo = new RemoteSelectionCombo(composite, this.syncRepos, UIText.RemoteSelectionCombo_destinationName, UIText.RemoteSelectionCombo_destinationRef);
        if (!this.dstRefCombo.setDefaultValue(this.getDefaultRemoteName(), "master")) {
            this.dstRefCombo.setDefaultValue(UIText.SynchronizeWithAction_localRepoName, "HEAD");
        }
        this.dstRefCombo.setLayoutData(data);
        this.dstRefCombo.setLayoutData(GridDataFactory.fillDefaults().grab(true, false).create());
        this.setTitle(NLS.bind((String)UIText.SelectSynchronizeResourceDialog_selectProject, (Object)this.repoName));
        this.setMessage(UIText.SelectSynchronizeResourceDialog_header);
        this.setTitleImage(UIIcons.WIZBAN_CONNECT_REPO.createImage());
        return composite;
    }

    private String getDefaultRemoteName() {
        boolean onlyOneRemote;
        int syncReposSize = this.syncRepos.size();
        boolean bl = onlyOneRemote = syncReposSize == 3 || syncReposSize == 2 && !UIText.SynchronizeWithAction_tagsName.equals(this.syncRepos.get(1).getName());
        if (onlyOneRemote) {
            return this.syncRepos.get(syncReposSize - 1).getName();
        }
        for (SyncRepoEntity repo : this.syncRepos) {
            if (!repo.getName().equals("origin")) continue;
            return "origin";
        }
        return "";
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.dstRef = this.dstRefCombo.getValue();
            this.srcRef = this.srcRefCombo.getValue();
            this.shouldIncludeLocal = this.shouldIncludeLocalButton.getSelection();
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(NLS.bind((String)UIText.SelectSynchronizeResourceDialog_selectProject, (Object)this.repoName));
        newShell.setMinimumSize(600, 180);
    }

    protected boolean isResizable() {
        return true;
    }
}

