/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.xlc.core.scannerconfig;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector2;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoConsoleParser;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.TraceUtil;
import org.eclipse.cdt.make.internal.core.scannerconfig2.SCProfileInstance;
import org.eclipse.cdt.make.internal.core.scannerconfig2.ScannerConfigProfile;
import org.eclipse.cdt.make.internal.core.scannerconfig2.ScannerConfigProfileManager;
import org.eclipse.cdt.make.xlc.core.activator.Activator;
import org.eclipse.cdt.make.xlc.core.scannerconfig.XLCBuildOutputParserUtility;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractXLCBuildOutputParser
implements IScannerInfoConsoleParser {
    protected static final String[] COMPILER_INVOCATION = new String[]{"xlc", "xlC"};
    protected static final String DASHIDASH = "-I-";
    protected static final String DASHI = "-I";
    protected static final String DASHD = "-D";
    protected IProject fProject;
    protected IScannerInfoCollector fCollector;
    protected IPath fWorkingDir;
    protected IMarkerGenerator fMarkerGenerator;
    protected XLCBuildOutputParserUtility fUtility;
    protected boolean fBMultiline = false;
    protected String fSMultiline = "";
    protected String[] fCompilerCommands = new String[]{"xlc", "xlC"};

    protected IProject getProject() {
        return this.fProject;
    }

    protected IScannerInfoCollector getCollector() {
        return this.fCollector;
    }

    public void startup(IProject project, IScannerInfoCollector collector) {
        this.fProject = project;
        this.fCollector = collector;
        this.fCompilerCommands = this.computeCompilerCommands();
    }

    protected String[] computeCompilerCommands() {
        String[] compilerCommands;
        String compilerCommandsString;
        SCProfileInstance profileInstance;
        ScannerConfigProfile.BuildOutputProvider boProvider;
        if (this.fProject != null && (boProvider = (profileInstance = ScannerConfigProfileManager.getInstance().getSCProfileInstance(this.fProject, "")).getProfile().getBuildOutputProviderElement()) != null && (compilerCommandsString = boProvider.getScannerInfoConsoleParser().getCompilerCommands()) != null && compilerCommandsString.length() > 0 && (compilerCommands = compilerCommandsString.split(",\\s*")).length > 0) {
            String[] compilerInvocation = new String[COMPILER_INVOCATION.length + compilerCommands.length];
            System.arraycopy(COMPILER_INVOCATION, 0, compilerInvocation, 0, COMPILER_INVOCATION.length);
            System.arraycopy(compilerCommands, 0, compilerInvocation, COMPILER_INVOCATION.length, compilerCommands.length);
            return compilerInvocation;
        }
        return COMPILER_INVOCATION;
    }

    public boolean processLine(String line) {
        boolean rc = false;
        int lineBreakPos = line.length() - 1;
        char[] lineChars = line.toCharArray();
        while (lineBreakPos >= 0 && Character.isWhitespace(lineChars[lineBreakPos])) {
            --lineBreakPos;
        }
        if (lineBreakPos >= 0 && (lineChars[lineBreakPos] != '\\' || lineBreakPos > 0 && lineChars[lineBreakPos - 1] == '\\')) {
            lineBreakPos = -1;
        }
        if (lineBreakPos >= 0) {
            this.fSMultiline = String.valueOf(this.fSMultiline) + line.substring(0, lineBreakPos);
            this.fBMultiline = true;
            return rc;
        }
        if (this.fBMultiline) {
            line = String.valueOf(this.fSMultiline) + line;
            this.fBMultiline = false;
            this.fSMultiline = "";
        }
        line = line.trim();
        try {
            TraceUtil.outputTrace((String)"XLCBuildOutputParser parsing line: [", (String)line, (String)"]");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {}
        int firstColon = line.indexOf(58);
        String make = line.substring(0, firstColon + 1);
        if (firstColon != -1 && make.indexOf("make") != -1) {
            boolean enter = false;
            String msg = line.substring(firstColon + 1).trim();
            enter = msg.startsWith("Entering directory");
            if (enter || msg.startsWith("Leaving directory")) {
                int s = msg.indexOf(96);
                int e = msg.indexOf(39);
                if (s != -1 && e != -1) {
                    String dir = msg.substring(s + 1, e);
                    if (this.getUtility() != null) {
                        this.getUtility().changeMakeDirectory(dir, this.getDirectoryLevel(line), enter);
                    }
                    return rc;
                }
            }
        }
        return this.processSingleLine(line.trim());
    }

    protected synchronized XLCBuildOutputParserUtility getUtility() {
        if (this.fUtility == null) {
            this.fUtility = new XLCBuildOutputParserUtility(this.fProject, this.fWorkingDir, this.fMarkerGenerator);
        }
        return this.fUtility;
    }

    protected int getDirectoryLevel(String line) {
        int s = line.indexOf(91);
        int num = 0;
        if (s != -1) {
            int e = line.indexOf(93);
            String number = line.substring(s + 1, e).trim();
            try {
                num = Integer.parseInt(number);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return num;
    }

    public void shutdown() {
        if (this.getUtility() != null) {
            this.getUtility().reportProblems();
        }
        if (this.fCollector != null && this.fCollector instanceof IScannerInfoCollector2) {
            IScannerInfoCollector2 collector = (IScannerInfoCollector2)this.fCollector;
            try {
                collector.updateScannerConfiguration(null);
            }
            catch (CoreException e) {
                Activator.log(e);
            }
        }
    }

    protected String[][] tokenize(String line, boolean escapeInsideDoubleQuotes) {
        ArrayList<String[]> commands = new ArrayList<String[]>();
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuffer token = new StringBuffer();
        char[] input = line.toCharArray();
        boolean nextEscaped = false;
        char currentQuote = '\u0000';
        int i = 0;
        while (i < input.length) {
            char c = input[i];
            boolean escaped = nextEscaped;
            nextEscaped = false;
            if (currentQuote != '\u0000') {
                if (c == currentQuote) {
                    if (escaped) {
                        token.append(c);
                    } else {
                        if (c == '`') {
                            token.append(c);
                        }
                        currentQuote = '\u0000';
                    }
                } else if (escapeInsideDoubleQuotes && currentQuote == '\"' && c == '\\') {
                    boolean bl = nextEscaped = !escaped;
                    if (escaped) {
                        token.append(c);
                    }
                } else {
                    if (escaped) {
                        token.append('\\');
                    }
                    token.append(c);
                }
            } else {
                switch (c) {
                    case '\\': {
                        if (escaped) {
                            token.append(c);
                            break;
                        }
                        nextEscaped = true;
                        break;
                    }
                    case '\"': 
                    case '\'': 
                    case '`': {
                        if (escaped) {
                            token.append(c);
                            break;
                        }
                        if (c == '`') {
                            token.append(c);
                        }
                        currentQuote = c;
                        break;
                    }
                    case ';': {
                        if (escaped) {
                            token.append(c);
                            break;
                        }
                        this.endCommand(token, tokens, commands);
                        break;
                    }
                    case '&': 
                    case '|': {
                        if (escaped || i + 1 >= input.length || input[i + 1] != c) {
                            token.append(c);
                            break;
                        }
                        ++i;
                        this.endCommand(token, tokens, commands);
                        break;
                    }
                    default: {
                        if (Character.isWhitespace(c)) {
                            if (escaped) {
                                token.append(c);
                                break;
                            }
                            this.endToken(token, tokens);
                            break;
                        }
                        if (escaped) {
                            token.append('\\');
                        }
                        token.append(c);
                    }
                }
            }
            ++i;
        }
        this.endCommand(token, tokens, commands);
        return (String[][])commands.toArray((T[])new String[commands.size()][]);
    }

    protected void endCommand(StringBuffer token, ArrayList<String> tokens, ArrayList<String[]> commands) {
        this.endToken(token, tokens);
        if (!tokens.isEmpty()) {
            commands.add(tokens.toArray(new String[tokens.size()]));
            tokens.clear();
        }
    }

    protected void endToken(StringBuffer token, ArrayList<String> tokens) {
        if (token.length() > 0) {
            tokens.add(token.toString());
            token.setLength(0);
        }
    }

    protected boolean processSingleLine(String line) {
        boolean rc = false;
        String[][] tokens = this.tokenize(line, true);
        int i = 0;
        while (i < tokens.length) {
            String[] command = tokens[i];
            if (this.processCommand(command)) {
                rc = true;
            } else {
                int j = 0;
                while (j < command.length) {
                    String[][] subtokens = this.tokenize(command[j], true);
                    int k = 0;
                    while (k < subtokens.length) {
                        String[] subcommand = subtokens[k];
                        if (subcommand.length > 1 && this.processCommand(subcommand)) {
                            rc = true;
                        }
                        ++k;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return rc;
    }

    protected int findCompilerInvocation(String[] tokens) {
        int i = 0;
        while (i < tokens.length) {
            String token = tokens[i].toLowerCase();
            int searchFromOffset = Math.max(token.lastIndexOf(47), token.lastIndexOf(92)) + 1;
            int j = 0;
            while (j < this.fCompilerCommands.length) {
                if (token.indexOf(this.fCompilerCommands[j], searchFromOffset) != -1) {
                    return i;
                }
                ++j;
            }
            ++i;
        }
        return -1;
    }

    public void startup(IProject project, IPath workingDirectory, IScannerInfoCollector collector, IMarkerGenerator markerGenerator) {
        this.fProject = project;
        this.fWorkingDir = workingDirectory;
        this.fCollector = collector;
        this.fMarkerGenerator = markerGenerator;
    }

    protected abstract boolean processCommand(String[] var1);

    protected List<String> getFileExtensionsList() {
        IContentTypeManager manager = Platform.getContentTypeManager();
        LinkedList<String> extensions = new LinkedList<String>();
        IContentType cSource = manager.getContentType("org.eclipse.cdt.core.cSource");
        IContentType cppSource = manager.getContentType("org.eclipse.cdt.core.cxxSource");
        String[] cExtensions = cSource.getFileSpecs(8);
        String[] cppExtensions = cppSource.getFileSpecs(8);
        int k = 0;
        while (k < cExtensions.length) {
            extensions.add("." + cExtensions[k]);
            ++k;
        }
        k = 0;
        while (k < cppExtensions.length) {
            extensions.add("." + cppExtensions[k]);
            ++k;
        }
        return extensions;
    }

    protected String[] getFileExtensions() {
        IContentTypeManager manager = Platform.getContentTypeManager();
        LinkedList<String> extensions = new LinkedList<String>();
        IContentType cSource = manager.getContentType("org.eclipse.cdt.core.cSource");
        IContentType cppSource = manager.getContentType("org.eclipse.cdt.core.cxxSource");
        String[] cExtensions = cSource.getFileSpecs(8);
        String[] cppExtensions = cppSource.getFileSpecs(8);
        int k = 0;
        while (k < cExtensions.length) {
            extensions.add("." + cExtensions[k]);
            ++k;
        }
        k = 0;
        while (k < cppExtensions.length) {
            extensions.add("." + cppExtensions[k]);
            ++k;
        }
        return extensions.toArray(new String[0]);
    }
}

