/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.util.HashMap;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDIThread;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.Manager;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.cdi.model.Thread;
import org.eclipse.cdt.debug.mi.core.command.CLIInfoThreads;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.output.CLIInfoThreadsInfo;

public class ThreadManager
extends Manager {
    static final Thread[] noThreads = new Thread[0];
    HashMap threadMap = new HashMap();

    public ThreadManager(Session session) {
        super(session, true);
    }

    public ICDIThread[] getThreads() throws CDIException {
        return new ICDIThread[0];
    }

    public ICDIThread[] getThreads(Target process) throws CDIException {
        ThreadSet set = (ThreadSet)this.threadMap.get(process);
        if (set == null) {
            set = this.getCThreads(process);
            this.threadMap.put(process, set);
        }
        return set.currentThreads;
    }

    public ThreadSet getCThreads(Target process) throws CDIException {
        ICDIThread[] cthreads = noThreads;
        int currentThreadId = 0;
        MISession mi = process.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        try {
            CLIInfoThreads tids = factory.createCLIInfoThreads();
            mi.postCommand(tids);
            CLIInfoThreadsInfo info = tids.getMIInfoThreadsInfo();
            int[] ids = info == null ? new int[]{} : info.getThreadIds();
            if (ids != null && ids.length > 0) {
                cthreads = new Thread[ids.length];
                int i = 0;
                while (i < ids.length) {
                    cthreads[i] = new Thread(process, ids[i]);
                    ++i;
                }
            } else {
                cthreads = new Thread[]{new Thread(process, 0)};
            }
            currentThreadId = info.getCurrentThread();
            if (currentThreadId == 0 && cthreads.length > 0) {
                currentThreadId = cthreads[0].getId();
            }
        }
        catch (MIException e) {
            throw new CDIException(e.getMessage());
        }
        return new ThreadSet(cthreads, currentThreadId);
    }

    public void update(Target target) throws CDIException {
    }

    class ThreadSet {
        ICDIThread[] currentThreads;
        int currentThreadId;

        ThreadSet(ICDIThread[] threads, int id) {
            this.currentThreads = threads;
            this.currentThreadId = id;
        }
    }
}

