/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FortranCorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.photran.core";
    public static final String FORTRAN_CONTENT_TYPE = "org.eclipse.photran.core.fortranSource";
    private static FortranCorePlugin plugin;

    public static final IContentType fortranContentType() {
        return Platform.getContentTypeManager().getContentType(FORTRAN_CONTENT_TYPE);
    }

    public static boolean hasFortranContentType(IFile file) {
        return FortranCorePlugin.hasFortranContentType(FortranCorePlugin.getFilenameForIFile(file));
    }

    public static boolean hasFortranContentType(String filename) {
        IContentType ct = FortranCorePlugin.getContentTypeOf(filename);
        return ct != null && ct.isKindOf(FortranCorePlugin.fortranContentType());
    }

    protected static final IContentType getContentTypeOf(String filename) {
        return FortranCorePlugin.findContentType(filename);
    }

    private static String getFilenameForIFile(IFile file) {
        return file == null ? null : file.getFullPath().toString();
    }

    public static final String[] getAllFortranContentTypes() {
        return new String[]{FORTRAN_CONTENT_TYPE};
    }

    public static IContentType findContentType(String filename) {
        IContentType[] cts = Platform.getContentTypeManager().findContentTypesFor(filename);
        if (cts.length == 0) {
            return null;
        }
        if (cts.length == 1) {
            return cts[0];
        }
        ArrayList<IContentType> possibilities = new ArrayList<IContentType>(cts.length);
        String ext = filename.substring(filename.lastIndexOf(46) + 1);
        IContentType[] iContentTypeArray = cts;
        int n = cts.length;
        int n2 = 0;
        while (n2 < n) {
            IContentType ct = iContentTypeArray[n2];
            if (FortranCorePlugin.getFilenameExtensions(ct.getId()).contains(ext)) {
                possibilities.add(ct);
            }
            ++n2;
        }
        if (possibilities.isEmpty()) {
            return cts[0];
        }
        IContentType result = null;
        for (IContentType ct : possibilities) {
            if (result == null) {
                result = ct;
                continue;
            }
            if (!ct.isKindOf(result)) continue;
            result = ct;
        }
        return result;
    }

    private static Set<String> getFilenameExtensions(String contentType) {
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.core.contenttype.contentTypes");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elt = iConfigurationElementArray[n2];
            if (elt.getName().equals("file-association") && elt.getAttribute("content-type").equals(contentType)) {
                HashSet<String> result = new HashSet<String>();
                String fileExts = elt.getAttribute("file-extensions");
                if (fileExts != null) {
                    String[] stringArray = fileExts.split(",");
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String ext = stringArray[n4];
                        result.add(ext.trim());
                        ++n4;
                    }
                    return result;
                }
            }
            ++n2;
        }
        return Collections.emptySet();
    }

    public static boolean inTestingMode() {
        String app = System.getProperty("eclipse.application");
        return app != null && app.toLowerCase().contains("junit");
    }

    public FortranCorePlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static FortranCorePlugin getDefault() {
        return plugin;
    }

    public static void log(Throwable e) {
        FortranCorePlugin.log("Error", e);
    }

    public static void log(String message, Throwable e) {
        FortranCorePlugin.log((IStatus)new Status(4, PLUGIN_ID, 4, message, e));
    }

    public static void log(IStatus status) {
        FortranCorePlugin.getDefault().getLog().log(status);
    }
}

