/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.errorparsers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IErrorParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public final class PGIErrorParser
implements IErrorParser {
    private Pattern lineError = Pattern.compile("PGF\\w\\w-S-\\d+-(.+):* [(](\\S+): (\\d+)[)]$");
    private Pattern nolineError = Pattern.compile("PGF\\w\\w-S-\\d+-(.+)[(](\\S+)[)]$");

    public boolean processLine(String thisLine, ErrorParserManager eoParser) {
        String errorMessage = null;
        String filename = null;
        boolean errorFound = false;
        int lineNum = 0;
        Matcher m = this.lineError.matcher(thisLine);
        if (m.matches()) {
            errorMessage = m.group(1);
            filename = m.group(2);
            lineNum = Integer.parseInt(m.group(3));
            errorFound = true;
        } else {
            m = this.nolineError.matcher(thisLine);
            if (m.matches()) {
                errorMessage = m.group(1);
                filename = m.group(2);
                lineNum = 1;
                errorFound = true;
            }
        }
        if (errorFound) {
            IFile file = eoParser.findFilePath(filename);
            eoParser.generateMarker((IResource)file, lineNum, errorMessage, 2, null);
        }
        return errorFound;
    }
}

