/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.intrinsics;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IntrinsicProcDescription
implements Comparable<IntrinsicProcDescription> {
    public final String moduleName;
    public final String genericName;
    public final String args;
    public final String description;

    IntrinsicProcDescription(String moduleName, String name, String args, String description) {
        this.moduleName = moduleName;
        this.genericName = name;
        this.args = args;
        this.description = description;
    }

    public boolean isFromIntrinsicModule() {
        return this.moduleName != null;
    }

    @Override
    public int compareTo(IntrinsicProcDescription that) {
        return this.genericName.compareTo(that.genericName);
    }

    public int hashCode() {
        return this.genericName.hashCode();
    }

    public boolean equals(Object that) {
        if (that == null || !this.getClass().equals(that.getClass())) {
            return false;
        }
        return ((IntrinsicProcDescription)that).genericName.equals(this.genericName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("! ");
        sb.append(this.description);
        sb.append("\n");
        sb.append("!\n");
        sb.append("! Usage: ");
        sb.append(this.genericName);
        sb.append(this.args);
        sb.append("\n");
        sb.append("!\n");
        sb.append("INTRINSIC ");
        sb.append(this.genericName);
        sb.append("\n");
        return sb.toString();
    }

    public List<String> getAllForms() {
        int orIndex = this.args.indexOf(" or ");
        if (orIndex > 0) {
            String args1 = this.args.substring(0, orIndex);
            String args2 = this.args.substring(orIndex + " or ".length());
            ArrayList<String> result = new ArrayList<String>();
            result.addAll(this.getAllForms(args1));
            result.addAll(this.getAllForms(args2));
            return result;
        }
        return this.getAllForms(this.args);
    }

    private List<String> getAllForms(String args) {
        args = this.removeParensAndRBracket(args);
        int lbracket = this.findLBracket(args);
        String requiredArgs = args.substring(0, lbracket).trim();
        String allOptionalArgs = args.substring(Math.min(lbracket + 1, args.length())).trim();
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.proposalFor(requiredArgs));
        if (allOptionalArgs.length() > 0) {
            int comma = allOptionalArgs.indexOf(44, 1);
            while (comma >= 0) {
                result.add(this.proposalFor(String.valueOf(requiredArgs) + allOptionalArgs.substring(0, comma).trim()));
                comma = allOptionalArgs.indexOf(44, comma + 1);
            }
            result.add(this.proposalFor(String.valueOf(requiredArgs) + allOptionalArgs));
        }
        return result;
    }

    private String removeParensAndRBracket(String args) {
        return args.replaceAll("[(\\])]", "");
    }

    private int findLBracket(String args) {
        int lbracket = args.indexOf(91);
        if (lbracket >= 0) {
            return lbracket;
        }
        return args.length();
    }

    private String proposalFor(String args) {
        if (args.equals("")) {
            return this.genericName;
        }
        return String.valueOf(this.genericName) + "(" + args + ")";
    }
}

