/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.intrinsics;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.photran.internal.core.FortranCorePlugin;
import org.eclipse.photran.internal.core.intrinsics.IntrinsicProcDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Intrinsics {
    private static final String INTRINSIC_PROCEDURE_LIST = "org/eclipse/photran/internal/core/intrinsics/intrinsic-procedures.txt";
    private static final String ISO_C_BINDING_LIST = "org/eclipse/photran/internal/core/intrinsics/iso_c_binding.txt";
    private static final String ISO_FORTRAN_ENV_LIST = "org/eclipse/photran/internal/core/intrinsics/iso_fortran_env.txt";
    private static TreeSet<IntrinsicProcDescription> intrinsicProcedures = null;

    private Intrinsics() {
    }

    public static IntrinsicProcDescription get(String identifier) {
        String target = identifier.toUpperCase();
        for (IntrinsicProcDescription proc : intrinsicProcedures) {
            if (!proc.genericName.toUpperCase().equals(target)) continue;
            return proc;
        }
        return null;
    }

    public static TreeSet<IntrinsicProcDescription> getAllIntrinsicProcedures() {
        if (intrinsicProcedures == null) {
            Intrinsics.loadData();
        }
        return intrinsicProcedures;
    }

    private static void loadData() {
        intrinsicProcedures = new TreeSet();
        Intrinsics.addIntrinsicsFrom(INTRINSIC_PROCEDURE_LIST, null);
        Intrinsics.addIntrinsicsFrom(ISO_C_BINDING_LIST, "ISO_C_BINDING");
        Intrinsics.addIntrinsicsFrom(ISO_FORTRAN_ENV_LIST, "ISO_FORTRAN_ENV");
    }

    private static void addIntrinsicsFrom(String file, String moduleName) throws Error {
        for (String line : Intrinsics.readIntrinsicProceduresFile(file)) {
            String[] fields = line.split("\t");
            if (fields.length != 3) {
                throw new Error("Malformed input");
            }
            String name = fields[0].replace(' ', '_');
            String args = fields[1];
            String description = fields[2];
            intrinsicProcedures.add(new IntrinsicProcDescription(moduleName, name, args, description));
        }
    }

    private static List<String> readIntrinsicProceduresFile(String file) {
        URL url = FortranCorePlugin.getDefault().getBundle().getResource(file);
        if (url == null) {
            throw new Error("Unable to locate " + file);
        }
        return Intrinsics.readLinesFrom(url);
    }

    private static List<String> readLinesFrom(URL url) throws Error {
        ArrayList<String> result = new ArrayList<String>(128);
        BufferedReader in = null;
        try {
            try {
                in = new BufferedReader(new InputStreamReader(url.openStream()));
                String line = in.readLine();
                while (line != null) {
                    result.add(line);
                    line = in.readLine();
                }
            }
            catch (IOException e) {
                throw new Error(e);
            }
        }
        catch (Throwable throwable) {
            Intrinsics.close(in);
            throw throwable;
        }
        Intrinsics.close(in);
        return result;
    }

    private static void close(BufferedReader in) throws Error {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                throw new Error(e);
            }
        }
    }
}

