/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.preferences;

import org.eclipse.photran.internal.core.preferences.FortranPreference;

public class FortranIntegerPreference
extends FortranPreference {
    private int defaultValue;
    private int upperLimit;
    private int lowerLimit;
    public static final int NO_LIMIT = -1;

    public FortranIntegerPreference(String name, int defaultValue) {
        super("integer", name);
        this.defaultValue = defaultValue;
        this.upperLimit = -1;
        this.lowerLimit = -1;
    }

    public FortranIntegerPreference(String name, int defaultValue, int upperLimit, int lowerLimit) {
        super("integer", name);
        this.defaultValue = defaultValue;
        this.upperLimit = upperLimit;
        this.lowerLimit = lowerLimit;
    }

    public void setDefault() {
        this.getPreferenceStore().setDefault(this.getName(), this.defaultValue);
    }

    public void setValue(int value) {
        if (this.upperLimit != -1 && value > this.upperLimit) {
            return;
        }
        if (this.lowerLimit != -1 && value < this.lowerLimit) {
            return;
        }
        this.getPreferenceStore().setValue(this.getName(), String.valueOf(value));
        this.savePreferenceStore();
    }

    public void setUpperLimit(int value) {
        this.upperLimit = value;
    }

    public void setLowerLimit(int value) {
        this.lowerLimit = value;
    }

    public int getUpperLimit() {
        return this.upperLimit;
    }

    public int getLowerLimit() {
        return this.lowerLimit;
    }

    public int getValue() {
        String val = this.getPreferenceStore().getString(this.getName());
        if (val == "") {
            this.setValue(this.defaultValue);
            return this.defaultValue;
        }
        return Integer.parseInt(val);
    }
}

