/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.preferences;

import org.eclipse.photran.internal.core.preferences.FortranIntegerPreference;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;

public class FortranTabWidthPreference
extends FortranIntegerPreference {
    public FortranTabWidthPreference(String name, int defaultValue, int upperLimit, int lowerLimit) {
        super(name, defaultValue, upperLimit, lowerLimit);
    }

    public static String spaces(int count) {
        if (count < 0) {
            throw new IllegalArgumentException();
        }
        switch (count) {
            case 0: {
                return "";
            }
            case 1: {
                return " ";
            }
            case 2: {
                return "  ";
            }
            case 3: {
                return "   ";
            }
            case 4: {
                return "    ";
            }
            case 5: {
                return "     ";
            }
            case 6: {
                return "      ";
            }
            case 7: {
                return "       ";
            }
            case 8: {
                return "        ";
            }
            case 9: {
                return "         ";
            }
            case 10: {
                return "          ";
            }
            case 11: {
                return "           ";
            }
            case 12: {
                return "            ";
            }
            case 13: {
                return "             ";
            }
            case 14: {
                return "              ";
            }
            case 15: {
                return "               ";
            }
            case 16: {
                return "                ";
            }
        }
        return "                " + FortranTabWidthPreference.spaces(count - 16);
    }

    public int getValue() {
        int customValue = super.getValue();
        if (customValue > 0) {
            return customValue;
        }
        return EditorsPlugin.getDefault().getPreferenceStore().getInt("tabWidth");
    }

    public String getStringOfSpaces() {
        return FortranTabWidthPreference.spaces(this.getValue());
    }
}

