/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.sourceform;

import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.photran.internal.core.properties.AbstractProperties;
import org.eclipse.photran.internal.core.sourceform.SourceForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceFormProperties
extends AbstractProperties {
    public static final String SOURCE_FORMS_PROPERTY_NAME = "SourceForms";

    public SourceFormProperties(IProject proj) {
        this.setProject(proj);
    }

    @Override
    protected void initializeDefaults(IProject proj, IPreferenceStore properties) {
        ArrayList<String> defaults = new ArrayList<String>();
        for (String spec : SourceForm.allConfiguredContentTypeAssociations()) {
            defaults.add(String.valueOf(spec) + "=" + SourceForm.descriptionForContentType(spec));
        }
        properties.setDefault(SOURCE_FORMS_PROPERTY_NAME, SourceFormProperties.createList(defaults.toArray(new String[defaults.size()])));
    }

    public String sourceFormForExtension(String extension) {
        Map<String, String> parsedValue = this.parseValue();
        return this.ifNull(parsedValue.get("*." + extension), "");
    }

    public String sourceFormForFilename(String filenameWithoutPath) {
        Map<String, String> parsedValue = this.parseValue();
        return this.ifNull(parsedValue.get(filenameWithoutPath), "");
    }

    private String ifNull(String value, String defaultValue) {
        return value != null ? value : defaultValue;
    }

    private Map<String, String> parseValue() {
        if (this.getPropertyStore() == null) {
            throw new IllegalArgumentException("This method cannot be called unless the explicit-value constructor was called");
        }
        return SourceFormProperties.parseValue(this.getPropertyStore().getString(SOURCE_FORMS_PROPERTY_NAME));
    }

    public static Map<String, String> parseValue(String propertyValue) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        String[] stringArray = SourceFormProperties.parseString(propertyValue);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String kvPair = stringArray[n2];
            int equals = kvPair.indexOf(61);
            if (equals > 0) {
                String key = kvPair.substring(0, equals);
                String value = kvPair.substring(equals + 1);
                result.put(key, value);
            }
            ++n2;
        }
        return result;
    }

    public static String unparseValue(Map<String, String> map) {
        ArrayList<String> values = new ArrayList<String>(map.size());
        for (String spec : map.keySet()) {
            values.add(String.valueOf(spec) + "=" + map.get(spec));
        }
        return SourceFormProperties.createList(values.toArray(new String[values.size()]));
    }
}

