/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.ui.team;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.databinding.dialog.DialogPageSupport;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.commons.repositories.RepositoryLocation;
import org.eclipse.mylyn.commons.repositories.RepositoryValidator;
import org.eclipse.mylyn.commons.repositories.auth.AuthenticationCredentials;
import org.eclipse.mylyn.commons.repositories.auth.AuthenticationType;
import org.eclipse.mylyn.commons.repositories.auth.UsernamePasswordCredentials;
import org.eclipse.mylyn.commons.ui.team.IPartContainer;
import org.eclipse.mylyn.commons.ui.team.Messages;
import org.eclipse.mylyn.internal.commons.ui.SectionComposite;
import org.eclipse.mylyn.internal.commons.ui.team.RepositoryLocationValueProperty;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.statushandlers.StatusManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryLocationPart {
    protected static final String PREFS_PAGE_ID_NET_PROXY = "org.eclipse.ui.net.NetPreferences";
    private DataBindingContext bindingContext;
    private boolean needsAdditionalSections;
    private boolean needsAnonymousLogin;
    private boolean needsHttpAuth;
    private boolean needsProxy;
    private boolean needsValidation;
    private IAdaptable serviceLocator;
    private final RepositoryLocation workingCopy;

    public RepositoryLocationPart(RepositoryLocation workingCopy) {
        this.workingCopy = workingCopy;
        this.setNeedsProxy(false);
        this.setNeedsHttpAuth(false);
        this.setNeedsValidation(true);
    }

    protected void applyValidatorResult(RepositoryValidator validator) {
        IStatus status = validator.getResult();
        String message = status.getMessage();
        if (message == null || message.length() == 0) {
            message = null;
        }
        switch (status.getSeverity()) {
            case 0: {
                if (status == Status.OK_STATUS) {
                    message = Messages.RepositoryLocationPart_Repository_is_valid;
                }
                this.getPartContainer().setMessage(message, 1);
                break;
            }
            case 1: {
                this.getPartContainer().setMessage(message, 1);
                break;
            }
            case 2: {
                this.getPartContainer().setMessage(message, 2);
                break;
            }
            default: {
                this.getPartContainer().setMessage(message, 3);
            }
        }
    }

    private void bind(AuthenticationType authType, Button anonymousButton, Text userText, Text passwordText, Button savePasswordButton, boolean reverseEnablement) {
        UsernamePasswordListener listener = new UsernamePasswordListener(authType, anonymousButton, userText, passwordText, savePasswordButton);
        listener.setEnablementReversed(reverseEnablement);
        listener.restore();
    }

    protected void bind(Button button, String property) {
        ISWTObservableValue uiElement = SWTObservables.observeSelection((Control)button);
        IObservableValue modelElement = new RepositoryLocationValueProperty(property, Boolean.FALSE.toString()).observe(this.workingCopy);
        this.bindingContext.bindValue((IObservableValue)uiElement, modelElement, null, null);
    }

    protected void bind(Text text, String property) {
        this.bind(text, property, null, null);
    }

    protected void bind(Text text, String property, UpdateValueStrategy targetObservableValue, UpdateValueStrategy modelObservableValue) {
        ISWTObservableValue uiElement = SWTObservables.observeText((Control)text, (int)24);
        IObservableValue modelElement = new RepositoryLocationValueProperty(property, null).observe(this.workingCopy);
        this.bindingContext.bindValue((IObservableValue)uiElement, modelElement, targetObservableValue, modelObservableValue);
    }

    public boolean canValidate() {
        return this.getValidator() != null;
    }

    protected Control createAdditionalContents(Composite composite) {
        return null;
    }

    public Control createContents(Composite parent) {
        this.bindingContext = new DataBindingContext();
        WizardPage wizardPage = this.getContainer(WizardPage.class);
        if (wizardPage != null) {
            WizardPageSupport.create((WizardPage)wizardPage, (DataBindingContext)this.bindingContext);
        } else {
            DialogPage page = this.getContainer(DialogPage.class);
            if (page != null) {
                DialogPageSupport.create((DialogPage)page, (DataBindingContext)this.bindingContext);
            }
        }
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo(composite);
        this.createServerSection(composite);
        this.createUserSection(composite);
        Control control = this.createAdditionalContents(composite);
        if (control != null) {
            GridDataFactory.fillDefaults().grab(true, true).span(3, 1).applyTo(control);
        }
        if (this.needsHttpAuth() || this.needsProxy() || this.needsAdditionalSections()) {
            SectionComposite sectionComposite = new SectionComposite(composite, 0);
            GridDataFactory.fillDefaults().grab(true, true).span(3, 1).applyTo((Control)sectionComposite);
            if (this.needsHttpAuth()) {
                this.createHttpAuthSection(sectionComposite);
            }
            if (this.needsProxy()) {
                this.createProxySection(sectionComposite);
            }
            this.createSections(sectionComposite);
        }
        return composite;
    }

    private void createHttpAuthSection(SectionComposite parent) {
        int style = 0;
        if (this.getWorkingCopy().getCredentials(AuthenticationType.HTTP, UsernamePasswordCredentials.class) != null) {
            style |= 0x40;
        }
        ExpandableComposite section = parent.createSection(Messages.RepositoryLocationPart_HTTP_Authentication, style);
        section.clientVerticalSpacing = 5;
        Composite composite = new Composite((Composite)section, 0);
        section.setClient((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(composite);
        Button enableButton = new Button(composite, 32);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)enableButton);
        enableButton.setText(Messages.RepositoryLocationPart_Enable_HTTP_Authentication);
        Label label = new Label(composite, 0);
        label.setText(Messages.RepositoryLocationPart_User);
        Text userText = new Text(composite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)userText);
        label = new Label(composite, 0);
        label.setText(Messages.RepositoryLocationPart_Password);
        Text passwordText = new Text(composite, 0x400800);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)passwordText);
        Button savePasswordButton = new Button(composite, 32);
        savePasswordButton.setText(Messages.RepositoryLocationPart_Save_Password);
        this.bind(AuthenticationType.HTTP, enableButton, userText, passwordText, savePasswordButton, false);
    }

    private void createProxySection(final SectionComposite parent) {
        ExpandableComposite section = parent.createSection(Messages.RepositoryLocationPart_Proxy_Server_Configuration);
        Composite composite = new Composite((Composite)section, 0);
        section.setClient((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(composite);
        Button systemProxyButton = new Button(composite, 32);
        GridDataFactory.fillDefaults().span(2, -1).applyTo((Control)systemProxyButton);
        systemProxyButton.setText(Messages.RepositoryLocationPart_Use_global_Network_Connections_preferences);
        this.bind(systemProxyButton, "org.eclipse.mylyn.repositories.proxy.usedefault");
        Link changeProxySettingsLink = new Link(composite, 0);
        changeProxySettingsLink.setText(Messages.RepositoryLocationPart_Change_Settings);
        changeProxySettingsLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceDialog dlg = PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), (String)RepositoryLocationPart.PREFS_PAGE_ID_NET_PROXY, (String[])new String[]{RepositoryLocationPart.PREFS_PAGE_ID_NET_PROXY}, null);
                dlg.open();
            }
        });
        Label label = new Label(composite, 0);
        label.setText(Messages.RepositoryLocationPart_Proxy_Host);
        Text proxyHostText = new Text(composite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)proxyHostText);
        this.bind(proxyHostText, "org.eclipse.mylyn.repositories.proxy.host");
        label = new Label(composite, 0);
        label.setText(Messages.RepositoryLocationPart_Proxy_Port);
        Text proxyPortText = new Text(composite, 0x400800);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)proxyPortText);
        this.bind(proxyPortText, "org.eclipse.mylyn.repositories.proxy.port");
        Button enableButton = new Button(composite, 32);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)enableButton);
        enableButton.setText(Messages.RepositoryLocationPart_Enable_Proxy_Authentication);
        label = new Label(composite, 0);
        label.setText(Messages.RepositoryLocationPart_User);
        Text userText = new Text(composite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)userText);
        label = new Label(composite, 0);
        label.setText(Messages.RepositoryLocationPart_Password);
        Text passwordText = new Text(composite, 0x400800);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)passwordText);
        Button savePasswordButton = new Button(composite, 32);
        savePasswordButton.setText(Messages.RepositoryLocationPart_Save_Password);
        this.bind(AuthenticationType.PROXY, enableButton, userText, passwordText, savePasswordButton, false);
    }

    protected void createSections(SectionComposite sectionComposite) {
    }

    private void createServerSection(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.RepositoryLocationPart_Server);
        Text urlText = new Text(parent, 2048);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)urlText);
        this.bind(urlText, "url", this.getUrlUpdateValueStrategy(), null);
        label = new Label(parent, 0);
        label.setText(Messages.RepositoryLocationPart_Label);
        Text labelText = new Text(parent, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)labelText);
        this.bind(labelText, "label");
        Button disconnectedButton = new Button(parent, 32);
        disconnectedButton.setText(Messages.RepositoryLocationPart_Disconnected);
        this.bind(disconnectedButton, "org.eclipse.mylyn.tasklist.repositories.offline");
    }

    protected UpdateValueStrategy getUrlUpdateValueStrategy() {
        return new UpdateValueStrategy().setAfterConvertValidator((IValidator)new UrlValidator());
    }

    private void createUserSection(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.RepositoryLocationPart_User);
        Text userText = new Text(parent, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)userText);
        this.bind(userText, "org.eclipse.mylyn.repositories.username");
        Button anonymousButton = new Button(parent, 32);
        anonymousButton.setText(Messages.RepositoryLocationPart_Anonymous);
        label = new Label(parent, 0);
        label.setText(Messages.RepositoryLocationPart_Password);
        Text passwordText = new Text(parent, 0x400800);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)passwordText);
        Button savePasswordButton = new Button(parent, 32);
        savePasswordButton.setText(Messages.RepositoryLocationPart_Save_Password);
        this.bind(AuthenticationType.REPOSITORY, anonymousButton, userText, passwordText, savePasswordButton, true);
    }

    public <T> T getContainer(Class<T> clazz) {
        return (T)this.getServiceLocator().getAdapter(clazz);
    }

    public IPartContainer getPartContainer() {
        return this.getContainer(IPartContainer.class);
    }

    private IAdaptable getServiceLocator() {
        return this.serviceLocator;
    }

    protected RepositoryValidator getValidator() {
        return null;
    }

    protected RepositoryLocation getWorkingCopy() {
        return this.workingCopy;
    }

    public boolean isValidUrl(String url) {
        if (url.startsWith("https://") || url.startsWith("http://")) {
            try {
                new URI(url);
                return true;
            }
            catch (Exception exception) {}
        }
        return false;
    }

    public boolean needsAdditionalSections() {
        return this.needsAdditionalSections;
    }

    public boolean needsAnonymousLogin() {
        return this.needsAnonymousLogin;
    }

    public boolean needsHttpAuth() {
        return this.needsHttpAuth;
    }

    public boolean needsProxy() {
        return this.needsProxy;
    }

    public boolean needsValidation() {
        return this.needsValidation;
    }

    public void setNeedsAdditionalSections(boolean needsAdditionalSections) {
        this.needsAdditionalSections = needsAdditionalSections;
    }

    public void setNeedsAnonymousLogin(boolean needsAnonymousLogin) {
        this.needsAnonymousLogin = needsAnonymousLogin;
    }

    public void setNeedsHttpAuth(boolean needsHttpAuth) {
        this.needsHttpAuth = needsHttpAuth;
    }

    public void setNeedsProxy(boolean needsProxy) {
        this.needsProxy = needsProxy;
    }

    public void setNeedsValidation(boolean needsValidation) {
        this.needsValidation = needsValidation;
    }

    public void setServiceLocator(IAdaptable container) {
        this.serviceLocator = container;
    }

    public void validate() {
        final RepositoryValidator validator = this.getValidator();
        if (validator == null) {
            return;
        }
        final AtomicReference result = new AtomicReference();
        try {
            this.getContainer(IPartContainer.class).run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(Messages.RepositoryLocationPart_Validating_repository, -1);
                    try {
                        try {
                            result.set(validator.run(monitor));
                        }
                        catch (OperationCanceledException operationCanceledException) {
                            result.set(Status.CANCEL_STATUS);
                            throw new InterruptedException();
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.mylyn.commons.team", Messages.RepositoryLocationPart_Unexpected_error_during_repository_validation, (Throwable)e), 7);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        if (result.get() == null) {
            validator.setResult(Status.OK_STATUS);
        } else {
            validator.setResult((IStatus)result.get());
        }
        this.getPartContainer().updateButtons();
        this.applyValidatorResult(validator);
    }

    public class UrlValidator
    implements IValidator {
        public IStatus validate(Object value) {
            if (!RepositoryLocationPart.this.isValidUrl(value.toString())) {
                return new Status(4, "org.eclipse.mylyn.commons.team", Messages.RepositoryLocationPart_Enter_a_valid_server_url);
            }
            return Status.OK_STATUS;
        }
    }

    private class UsernamePasswordListener
    implements ModifyListener,
    SelectionListener {
        private final AuthenticationType authenticationType;
        private final Button enabledButton;
        private boolean enablementReversed;
        private final Text passwordText;
        private final Button savePasswordButton;
        private boolean updating;
        private final Text userText;

        public UsernamePasswordListener(AuthenticationType authenticationType, Button enabledButton, Text userText, Text passwordText, Button savePasswordButton) {
            this.authenticationType = authenticationType;
            this.enabledButton = enabledButton;
            this.userText = userText;
            this.passwordText = passwordText;
            this.savePasswordButton = savePasswordButton;
            this.init();
        }

        private void apply() {
            if (this.updating) {
                return;
            }
            if (this.isEnabled()) {
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.userText.getText(), this.passwordText.getText());
                RepositoryLocationPart.this.getWorkingCopy().setCredentials(this.authenticationType, (AuthenticationCredentials)credentials);
            } else {
                RepositoryLocationPart.this.getWorkingCopy().setCredentials(this.authenticationType, null);
            }
        }

        protected void init() {
            this.enabledButton.addSelectionListener((SelectionListener)this);
            this.userText.addModifyListener((ModifyListener)this);
            this.passwordText.addModifyListener((ModifyListener)this);
            this.savePasswordButton.addSelectionListener((SelectionListener)this);
        }

        protected boolean isEnabled() {
            return this.enabledButton.getSelection() ^ this.isEnablementReversed();
        }

        public boolean isEnablementReversed() {
            return this.enablementReversed;
        }

        public void modifyText(ModifyEvent event) {
            this.apply();
        }

        private void restore() {
            try {
                this.updating = true;
                UsernamePasswordCredentials credentials = (UsernamePasswordCredentials)RepositoryLocationPart.this.getWorkingCopy().getCredentials(this.authenticationType, UsernamePasswordCredentials.class);
                if (credentials != null) {
                    this.enabledButton.setSelection(!this.isEnablementReversed());
                    this.userText.setText(credentials.getUserName());
                    this.passwordText.setText(credentials.getUserName());
                    this.savePasswordButton.setSelection(true);
                } else {
                    this.enabledButton.setSelection(this.isEnablementReversed());
                    this.userText.setText("");
                    this.passwordText.setText("");
                    this.savePasswordButton.setSelection(true);
                }
            }
            finally {
                this.updating = false;
            }
            this.updateWidgetEnablement();
        }

        public void setEnablementReversed(boolean enablementReversed) {
            this.enablementReversed = enablementReversed;
        }

        private void updateWidgetEnablement() {
            boolean enabled = this.isEnabled();
            this.userText.setEnabled(enabled);
            this.passwordText.setEnabled(enabled);
            this.savePasswordButton.setEnabled(enabled);
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            this.apply();
        }

        public void widgetSelected(SelectionEvent event) {
            this.apply();
            if (event.widget == this.enabledButton) {
                this.updateWidgetEnablement();
            }
        }
    }
}

