/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.etfw.internal;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.eclipse.cdt.make.core.IMakeBuilderInfo;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.internal.core.MakeTargetManager;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ptp.etfw.IBuildLaunchUtils;
import org.eclipse.ptp.etfw.IToolLaunchConfigurationConstants;
import org.eclipse.ptp.etfw.internal.ToolStep;
import org.eclipse.ptp.etfw.messages.Messages;
import org.eclipse.ptp.etfw.toolopts.BuildTool;
import org.eclipse.ptp.rdt.sync.core.BuildConfigurationManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuilderTool
extends ToolStep
implements IToolLaunchConfigurationConstants {
    private String progPath = null;
    private boolean runbuilt = false;
    private IConfiguration newBuildConfig = null;
    private String buildConf = null;
    private IConfiguration olddefbuildconf = null;
    private IManagedBuildInfo buildInfo = null;
    private Map<String, String> buildMods = null;
    private String newname = null;
    private String binary = null;
    private BuildTool tool = null;
    private IBuildLaunchUtils utilBlob = null;
    private boolean isManaged;
    public IConfiguration selectedconf = null;
    private static final String CComp = "CC=";
    private static final String CxxComp = "CXX=";
    private static final String FComp = "F90=";
    private static final String UPCComp = "UPCC=";

    public BuilderTool(ILaunchConfiguration conf, BuildTool btool, Map<String, String> buildMods, IBuildLaunchUtils utilBlob) throws CoreException {
        super(conf, Messages.BuilderTool_InstrumentingBuilding, utilBlob);
        this.buildMods = buildMods;
        this.utilBlob = utilBlob;
        this.tool = btool;
        this.initBuild(conf);
    }

    public BuilderTool(ILaunchConfiguration conf, BuildTool btool, IBuildLaunchUtils utilBlob) throws CoreException {
        super(conf, Messages.BuilderTool_InstrumentingBuilding, utilBlob);
        this.utilBlob = utilBlob;
        this.tool = btool;
        this.initBuild(conf);
    }

    private void initBuild(ILaunchConfiguration conf) throws CoreException {
        this.buildConf = this.configuration.getAttribute("ATTR_PERFORMANCEBUILD_CONFIGURATION_NAME", null);
        if (this.tool == null) {
            return;
        }
        this.buildInfo = ManagedBuildManager.getBuildInfo((IResource)this.thisCProject.getResource());
        this.olddefbuildconf = this.buildInfo.getDefaultConfiguration();
        this.isManaged = this.olddefbuildconf.isManagedBuildOn();
        this.runbuilt = this.isManaged ? this.initMMBuild() : this.initSMBuild();
    }

    public boolean getBuildSuccessful() {
        return this.runbuilt;
    }

    public String getOutputLocation() {
        return this.outputLocation;
    }

    public String getProgramPath() {
        return this.progPath;
    }

    public void buildIndstrumented(IProgressMonitor monitor) throws Exception {
        if (this.tool != null) {
            if (!this.isManaged) {
                this.standardMakeBuild(monitor);
            } else if (this.runbuilt) {
                this.runbuilt = this.initMMBuildConf();
                if (this.runbuilt) {
                    this.runbuilt = this.managedMakeBuild(monitor);
                }
            }
        }
    }

    public void standardMakeBuild(IProgressMonitor monitor) throws CoreException {
        IFileStore projectFileStore = this.utilBlob.getFile(this.projectLocation);
        IFileStore compilerInclude = projectFileStore.getChild("eclipse.inc");
        try {
            BufferedOutputStream makeOut = new BufferedOutputStream(compilerInclude.openOutputStream(0, null));
            String allargs = this.getToolArguments(this.tool.getGlobalCompiler(), this.configuration);
            String ops = this.getStandardMakeBuildOps(this.tool, this.configuration, allargs);
            makeOut.write(ops.getBytes());
            makeOut.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        MakeTargetManager targetMan = new MakeTargetManager();
        targetMan.startup();
        IMakeTarget[] targs = targetMan.getTargets((IContainer)this.thisProject);
        IMakeTarget select = null;
        int i = 0;
        while (i < targs.length) {
            if (targs[i].getName().equals(Messages.BuilderTool_all)) {
                select = targs[i];
                break;
            }
            ++i;
        }
        if (select == null) {
            if (this.isSyncProject) {
                if (!BuildConfigurationManager.getInstance().isInitialized(this.thisProject)) {
                    System.out.println("Sync project not initialized");
                    return;
                }
            } else {
                IMakeBuilderInfo info = MakeCorePlugin.createBuildInfo((IProject)this.thisProject, (String)"org.eclipse.ptp.rdt.core.remoteMakeBuilder");
                if (info == null || !info.isFullBuildEnabled()) {
                    System.out.println(Messages.BuilderTool_NoMakeTargetAll);
                    this.runbuilt = false;
                    return;
                }
            }
            this.thisProject.build(15, monitor);
            this.thisProject.build(6, monitor);
        } else {
            select.build(monitor);
        }
        targetMan.shutdown();
        try {
            BufferedOutputStream out = new BufferedOutputStream(compilerInclude.openOutputStream(0, null));
            byte[] buf = new byte[1024];
            ((OutputStream)out).write(buf, 0, 0);
            ((OutputStream)out).close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.runbuilt = true;
    }

    private boolean initSMBuild() throws CoreException {
        if (this.buildInfo == null || !this.buildInfo.isValid()) {
            System.out.println(Messages.BuilderTool_NoInfo);
            return false;
        }
        IConfiguration[] buildconfigs = this.buildInfo.getManagedProject().getConfigurations();
        int i = 0;
        while (i < buildconfigs.length) {
            if (buildconfigs[i].getName().equals(this.buildConf)) {
                this.selectedconf = buildconfigs[i];
                break;
            }
            ++i;
        }
        this.newname = this.progPath = this.olddefbuildconf.getEditableBuilder().getBuildLocation().toOSString();
        if (this.configuration.getAttribute("perf_executable_path_tag_for_path_value", null) != null) {
            IFileStore newFile;
            this.outputLocation = this.newname == null ? "" : ((newFile = this.utilBlob.getFile(this.newname)).fetchInfo().exists() ? newFile.toURI().getPath() : "");
        }
        return true;
    }

    private boolean initMMBuild() throws CoreException {
        String bextension;
        if (this.buildInfo == null || !this.buildInfo.isValid()) {
            System.out.println(Messages.BuilderTool_NoInfo);
            return false;
        }
        IManagedProject managedBuildProj = this.buildInfo.getManagedProject();
        if (managedBuildProj == null) {
            System.out.println(Messages.BuilderTool_NoManagedProject);
            return false;
        }
        this.binary = this.buildInfo.getBuildArtifactName();
        if (this.binary.equals("${ProjName}")) {
            this.binary = this.thisProject.getName();
        }
        if ((bextension = this.buildInfo.getBuildArtifactExtension()).length() > 0) {
            this.binary = String.valueOf(this.binary) + "." + bextension;
        }
        IConfiguration[] buildconfigs = this.buildInfo.getManagedProject().getConfigurations();
        int i = 0;
        while (i < buildconfigs.length) {
            if (buildconfigs[i].getName().equals(this.buildConf)) {
                this.selectedconf = buildconfigs[i];
                break;
            }
            ++i;
        }
        if (this.selectedconf == null) {
            System.out.println(Messages.BuilderTool_NoConfSelected);
            return false;
        }
        if (this.selectedconf.getName() == null) {
            System.out.println(Messages.BuilderTool_SelConfHasNoName);
            return false;
        }
        String basename = this.selectedconf.getName();
        this.newname = null;
        String addname = this.configuration.getAttribute("performance_tool_build_configuration_name_modifier." + this.tool.toolID, "PerformanceAnalysis");
        this.newname = String.valueOf(basename) + "_" + addname;
        if (addname.equals("PerformanceAnalysis")) {
            String nameMod = this.tool.toolName;
            if (nameMod == null) {
                nameMod = this.tool.toolID;
            }
            this.newname = String.valueOf(this.newname) + "_" + nameMod;
        }
        this.progPath = String.valueOf(this.newname) + File.separator + this.binary;
        if (!this.isSyncProject && this.configuration.getAttribute("perf_executable_path_tag_for_path_value", null) != null) {
            this.outputLocation = this.thisProject.getFile(this.newname).getLocationURI().getPath();
        }
        boolean confExists = false;
        IConfiguration[] confs = managedBuildProj.getConfigurations();
        int i2 = 0;
        while (i2 < confs.length) {
            if (confs[i2].getName().equals(this.newname) || confs[i2].getName().indexOf(this.newname) >= 0) {
                confExists = true;
                this.newBuildConfig = confs[i2];
                break;
            }
            ++i2;
        }
        if (!confExists) {
            this.newBuildConfig = managedBuildProj.createConfigurationClone(this.selectedconf, String.valueOf(this.selectedconf.getId()) + "." + ManagedBuildManager.getRandomNumber());
        }
        if (this.newBuildConfig == null) {
            System.out.println(Messages.BuilderTool_NoConfig);
            return false;
        }
        return true;
    }

    public boolean initMMBuildConf() throws CoreException, FileNotFoundException {
        int n;
        ITool[] tools;
        if (!this.newBuildConfig.getName().equals(this.newname)) {
            this.newBuildConfig.setName(this.newname);
        }
        IToolChain chain = this.newBuildConfig.getToolChain();
        ITool[] iToolArray = tools = chain.getTools();
        int n2 = tools.length;
        int n3 = 0;
        while (n3 < n2) {
            ITool it = iToolArray[n3];
            IOption[] iOptionArray = it.getOptions();
            n = iOptionArray.length;
            int n4 = 0;
            while (n4 < n) {
                IOption op = iOptionArray[n4];
                if (op == null || op.getName() == null) {
                    // empty if block
                }
                ++n4;
            }
            ++n3;
        }
        String allargs = "";
        if (this.tool.getGlobalCompiler() != null && !this.tool.getGlobalCompiler().equals(this.tool.getCcCompiler())) {
            allargs = this.getToolArguments(this.tool.getGlobalCompiler(), this.configuration);
        }
        int numChanges = 0;
        int i = 0;
        while (i < tools.length) {
            String toolid;
            if (this.buildMods != null) {
                for (String opName : this.buildMods.keySet()) {
                    IOption[] iOptionArray = tools[i].getOptions();
                    int n5 = iOptionArray.length;
                    n = 0;
                    while (n < n5) {
                        IOption op = iOptionArray[n];
                        if (op.getName().equals(opName)) {
                            try {
                                op.setValue(this.buildMods.get(opName));
                            }
                            catch (BuildException e) {
                                e.printStackTrace();
                            }
                        }
                        ++n;
                    }
                }
            }
            if ((toolid = tools[i].getId()).indexOf(".c.") >= 0) {
                numChanges += BuilderTool.modifyCommand(tools[i], this.getToolCommand(this.tool.getCcCompiler(), this.configuration), allargs, this.tool.replaceCompiler);
            }
            if (toolid.indexOf(".cpp.") >= 0) {
                numChanges += BuilderTool.modifyCommand(tools[i], this.getToolCommand(this.tool.getCxxCompiler(), this.configuration), allargs, this.tool.replaceCompiler);
            }
            if (toolid.indexOf(".fortran.") >= 0) {
                numChanges += BuilderTool.modifyCommand(tools[i], this.getToolCommand(this.tool.getF90Compiler(), this.configuration), allargs, this.tool.replaceCompiler);
            }
            if (toolid.indexOf(".upc.") >= 0 || toolid.indexOf(".bupc.") >= 0 || toolid.indexOf(".xlupc.") >= 0) {
                numChanges += BuilderTool.modifyCommand(tools[i], this.getToolCommand(this.tool.getUPCCompiler(), this.configuration), allargs, this.tool.replaceCompiler);
            }
            ++i;
        }
        if (numChanges > 0) {
            ManagedBuildManager.saveBuildInfo((IProject)this.thisCProject.getProject(), (boolean)true);
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private boolean managedMakeBuild(IProgressMonitor monitor) {
        programPath = null;
        pathStore = null;
        if (this.isSyncProject) {
            pathStore = this.utilBlob.getFile(this.outputLocation);
            pathStore = pathStore.getChild(this.progPath);
        } else {
            programPath = this.thisProject.getFile(this.progPath);
            pathStore = this.utilBlob.getFile(programPath.getLocationURI().getPath());
        }
        ManagedBuildManager.setDefaultConfiguration((IProject)this.thisCProject.getProject(), (IConfiguration)this.newBuildConfig);
        try {
            this.thisProject.build(6, monitor);
            if (true) ** GOTO lbl27
        }
        catch (Exception v0) {
            return false;
        }
        do {
            if (monitor != null && monitor.isCanceled()) {
                this.restoreBuild();
                this.runbuilt = false;
                throw new OperationCanceledException();
            }
            numMillisecondsToSleep = 1000L;
            try {
                Thread.sleep(numMillisecondsToSleep);
            }
            catch (InterruptedException v1) {}
            if (this.isSyncProject) continue;
            programPath = this.thisProject.getFile(this.progPath);
lbl27:
            // 3 sources

        } while (this.waitForBuild(-1L, programPath, pathStore.fetchInfo()));
        this.restoreBuild();
        return true;
    }

    private boolean waitForBuild(long lastBuilt, IFile programPath, IFileInfo progInfo) {
        return programPath != null && !programPath.exists() && !progInfo.exists();
    }

    private static int modifyCommand(ITool tool, String command, String args, boolean replace) {
        int didChange = 0;
        String toolCommand = tool.getToolCommand();
        if (replace) {
            String newcom = String.valueOf(command) + " " + args;
            if (!newcom.equals(toolCommand)) {
                tool.setToolCommand(String.valueOf(command) + " " + args);
                didChange = 1;
            }
        } else {
            String newcom;
            String oldcom = toolCommand.trim();
            int lastspc = oldcom.lastIndexOf(32);
            if (lastspc >= 0) {
                oldcom = toolCommand.substring(lastspc).trim();
            }
            if (!(newcom = String.valueOf(command) + " " + args + " " + oldcom).equals(toolCommand)) {
                tool.setToolCommand(newcom);
                didChange = 1;
            }
        }
        return didChange;
    }

    private String getStandardMakeBuildOps(BuildTool tool, ILaunchConfiguration configuration, String allargs) throws CoreException {
        String ops = "";
        if (tool.getCcCompiler() != null) {
            ops = String.valueOf(ops) + this.getStandardMakeOp(CComp, this.getToolCommand(tool.getCcCompiler(), configuration), allargs);
        }
        if (tool.getCxxCompiler() != null) {
            ops = String.valueOf(ops) + this.getStandardMakeOp(CxxComp, this.getToolCommand(tool.getCxxCompiler(), configuration), allargs);
        }
        if (tool.getF90Compiler() != null) {
            ops = String.valueOf(ops) + this.getStandardMakeOp(FComp, this.getToolCommand(tool.getF90Compiler(), configuration), allargs);
        }
        if (tool.getUPCCompiler() != null) {
            ops = String.valueOf(ops) + this.getStandardMakeOp(UPCComp, this.getToolCommand(tool.getUPCCompiler(), configuration), allargs);
        }
        return ops;
    }

    private String getStandardMakeOp(String var, String command, String args) {
        String op = "";
        if (command != null) {
            op = String.valueOf(var) + command + " " + args + "\n";
        }
        return op;
    }

    public void restoreBuild() {
        if (this.isManaged) {
            ManagedBuildManager.setDefaultConfiguration((IProject)this.thisCProject.getProject(), (IConfiguration)this.olddefbuildconf);
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.buildIndstrumented(monitor);
        }
        catch (Exception e) {
            return new Status(4, "com.ibm.jdg2e.concurrency", 4, Messages.BuilderTool_BuildIncomplete, (Throwable)e);
        }
        return new Status(0, "com.ibm.jdg2e.concurrency", 0, Messages.BuilderTool_BuildSuccessful, null);
    }
}

