/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.etfw.internal;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ptp.etfw.AbstractToolDataManager;
import org.eclipse.ptp.etfw.Activator;
import org.eclipse.ptp.etfw.IBuildLaunchUtils;
import org.eclipse.ptp.etfw.IToolLaunchConfigurationConstants;
import org.eclipse.ptp.etfw.internal.ToolStep;
import org.eclipse.ptp.etfw.messages.Messages;
import org.eclipse.ptp.etfw.toolopts.PostProcTool;
import org.eclipse.ptp.etfw.toolopts.ToolApp;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostlaunchTool
extends ToolStep
implements IToolLaunchConfigurationConstants {
    String currentFile;
    private PostProcTool tool = null;
    boolean externalTarget = false;
    String projName = null;
    private IBuildLaunchUtils utilBLob;
    private String syncProjectLocation = null;

    public PostlaunchTool(ILaunchConfiguration conf, PostProcTool ppTool, String outLoc, IBuildLaunchUtils utilBlob) throws CoreException {
        super(conf, Messages.PostlaunchTool_Analysis, utilBlob);
        this.tool = ppTool;
        this.utilBLob = utilBlob;
        if (outLoc.equals("")) {
            this.syncProjectLocation = this.projectLocation;
        }
        this.projectLocation = this.outputLocation = outLoc;
    }

    public void postlaunch(IProgressMonitor monitor) throws CoreException {
        if (this.tool.analysisCommands == null || this.tool.analysisCommands.length <= 0) {
            return;
        }
        ToolApp[] toolAppArray = this.tool.analysisCommands;
        int n = this.tool.analysisCommands.length;
        int n2 = 0;
        while (n2 < n) {
            ToolApp anap = toolAppArray[n2];
            if (anap.toolGroup == null || !anap.toolGroup.equals("internal")) {
                List<String> runTool = this.getToolCommandList(anap, this.configuration);
                if (this.tool.forAllLike != null) {
                    IFileStore getname = this.utilBlob.getFile(this.currentFile);
                    String name = getname.getName();
                    if (name.contains(".")) {
                        name = name.substring(0, name.lastIndexOf("."));
                    }
                    int runDex = 0;
                    while (runDex < runTool.size()) {
                        String s = runTool.get(runDex);
                        s = s.replace("%%FILE%%", this.currentFile);
                        s = s.replace("%%FILENAME%%", name);
                        runTool.set(runDex, s);
                        ++runDex;
                    }
                }
                if (runTool != null) {
                    if (anap.isVisualizer) {
                        this.utilBLob.runVis(runTool, null, this.outputLocation);
                    } else {
                        this.utilBLob.runTool(runTool, null, this.outputLocation, anap.outToFile);
                    }
                } else {
                    System.out.println(String.valueOf(Messages.PostlaunchTool_TheCommand) + anap.toolCommand + Messages.PostlaunchTool_CouldNotRun);
                }
            } else {
                AbstractToolDataManager manager = Activator.getPerfDataManager(anap.toolCommand);
                if (manager != null) {
                    if (this.externalTarget) {
                        manager.setExternalTarget(true);
                    } else {
                        this.projName = this.thisCProject.getElementName();
                    }
                    String outdir = this.outputLocation;
                    if (this.syncProjectLocation != null) {
                        outdir = this.syncProjectLocation;
                    }
                    manager.process(this.projName, this.configuration, outdir);
                    manager.cleanup();
                }
            }
            ++n2;
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (this.tool == null) {
            return new Status(2, "com.ibm.jdg2e.concurrency", 0, Messages.PostlaunchTool_NoToolNoData, null);
        }
        if (this.outputLocation == null) {
            if (this.tool.useDefaultLocation) {
                this.outputLocation = System.getProperty("user.home");
            } else {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        Shell s = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                        if (s == null) {
                            s = PlatformUI.getWorkbench().getDisplay().getShells()[0];
                        }
                        DirectoryDialog dl = new DirectoryDialog(s);
                        dl.setText(Messages.PostlaunchTool_SelectPerfDir);
                        PostlaunchTool.this.outputLocation = dl.open();
                    }
                });
                if (this.outputLocation == null) {
                    return new Status(0, "com.ibm.jdg2e.concurrency", 0, Messages.PostlaunchTool_NoData, null);
                }
                this.externalTarget = true;
            }
        }
        try {
            if (this.tool.forAllLike != null) {
                IFileStore workDir = this.utilBlob.getFile(this.outputLocation);
                LinkedHashSet<IFileStore> fileSet = new LinkedHashSet<IFileStore>();
                this.findFiles(fileSet, workDir, this.tool.depth, this.tool.forAllLike, this.tool.useLatestFileOnly);
                if (fileSet.size() <= 0) {
                    return new Status(4, "com.ibm.jdg2e.concurrency", 4, Messages.PostlaunchTool_NoValidFiles, null);
                }
                for (IFileStore f : fileSet) {
                    this.currentFile = f.toURI().getPath();
                    this.postlaunch(monitor);
                }
            } else {
                this.postlaunch(monitor);
            }
        }
        catch (Exception e) {
            return new Status(4, "com.ibm.jdg2e.concurrency", 4, Messages.PostlaunchTool_DataCollectError, (Throwable)e);
        }
        return new Status(0, "com.ibm.jdg2e.concurrency", 0, Messages.PostlaunchTool_DataCollected, null);
    }

    private List<IFileStore> listFiles(IFileStore root, String matchSuffix) {
        ArrayList<IFileStore> files = new ArrayList<IFileStore>();
        IFileStore[] filea = null;
        try {
            filea = root.childStores(0, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        String test = matchSuffix.toLowerCase();
        IFileStore[] iFileStoreArray = filea;
        int n = filea.length;
        int n2 = 0;
        while (n2 < n) {
            IFileStore f = iFileStoreArray[n2];
            if (f.getName().endsWith(test)) {
                files.add(f);
            }
            ++n2;
        }
        return files;
    }

    private List<IFileStore> listDirectories(IFileStore root) {
        ArrayList<IFileStore> files = new ArrayList<IFileStore>();
        IFileStore[] filea = null;
        try {
            filea = root.childStores(0, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        IFileStore[] iFileStoreArray = filea;
        int n = filea.length;
        int n2 = 0;
        while (n2 < n) {
            IFileStore f = iFileStoreArray[n2];
            if (f.fetchInfo().isDirectory()) {
                files.add(f);
            }
            ++n2;
        }
        return files;
    }

    private void findFiles(Set<IFileStore> fileSet, IFileStore root, int depth, String matchSuffix, boolean latestOnly) {
        List<IFileStore> files = this.listFiles(root, matchSuffix);
        for (IFileStore f : files) {
            if (latestOnly) {
                if (fileSet.size() == 0) {
                    fileSet.add(f);
                    continue;
                }
                if (fileSet.iterator().next().fetchInfo().getLastModified() >= f.fetchInfo().getLastModified()) continue;
                fileSet.clear();
                fileSet.add(f);
                continue;
            }
            fileSet.add(f);
        }
        if (depth > 0 || depth < 0) {
            List<IFileStore> roots = this.listDirectories(root);
            for (IFileStore r : roots) {
                this.findFiles(fileSet, r, depth - 1, matchSuffix, latestOnly);
            }
        }
    }
}

