/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.sync.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.WriteAccessException;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.rdt.core.serviceproviders.IRemoteExecutionServiceProvider;
import org.eclipse.ptp.rdt.sync.core.BuildScenario;
import org.eclipse.ptp.rdt.sync.core.RDTSyncCorePlugin;
import org.eclipse.ptp.rdt.sync.core.messages.Messages;
import org.eclipse.ptp.rdt.sync.core.serviceproviders.ISyncServiceProvider;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.services.core.IService;
import org.eclipse.ptp.services.core.IServiceConfiguration;
import org.eclipse.ptp.services.core.IServiceProvider;
import org.eclipse.ptp.services.core.IServiceProviderDescriptor;
import org.eclipse.ptp.services.core.ServiceModelManager;
import org.eclipse.ptp.services.core.ServiceProvider;
import org.eclipse.ptp.services.core.ServicesCorePlugin;
import org.eclipse.ptp.services.internal.core.ServiceConfiguration;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class BuildConfigurationManager {
    private static final String DEFAULT_SAVE_FILE_NAME = "BuildConfigurationData.xml";
    private static final String BUILD_CONFIGURATION_ELEMENT_NAME = "build-configuration-data";
    private static final String SERVICE_ELEMENT_NAME = "service";
    private static final String PROVIDER_ELEMENT_NAME = "provider";
    private static final String DISABLED_PROVIDERS_ELEMENT_NAME = "disabledProviders";
    private static final String ATTR_ID = "id";
    private static final String ATTR_BUILD_SCENARIO_ID = "build-id";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_PROJECT = "project";
    private static final String ATTR_SERVICE_ID = "serviceId";
    private static final String PROVIDER_CONFIGURATION_ELEMENT_NAME = "provider-configuration";
    private static final String ATTR_PROVIDER_ID = "provider-id";
    private static final String BUILD_SCENARIO_ELEMENT_NAME = "build-scenario";
    private static final String CONFIG_ID_ELEMENT_NAME = "config-id-to-build-scenario";
    private static final String TEMPLATE_SERVICE_CONFIGURATION_ELEMENT_NAME = "template-service-configuration-element-name";
    private final Map<IProject, IServiceConfiguration> fProjectToTemplateConfigurationMap = Collections.synchronizedMap(new HashMap());
    private final Map<IServiceConfiguration, IProject> fTemplateToProjectMap = Collections.synchronizedMap(new HashMap());
    private final Map<String, BuildScenario> fBuildConfigToBuildScenarioMap = Collections.synchronizedMap(new HashMap());
    private final Map<BuildScenario, IServiceConfiguration> fBuildScenarioToSConfigMap = Collections.synchronizedMap(new HashMap());
    private static BuildConfigurationManager fInstance = null;

    private static String getParentId(String configId) {
        String parentConfigId;
        String idRegEx = "\\.\\d+$";
        Pattern idPattern = Pattern.compile(idRegEx);
        if (idPattern.matcher(parentConfigId = configId.replaceFirst(idRegEx, "")).find()) {
            return parentConfigId;
        }
        return null;
    }

    private static IServiceProvider loadServiceProvider(IMemento providerMemento, IService service) {
        IServiceProvider provider;
        if (service == null) {
            return null;
        }
        String providerId = providerMemento.getString(ATTR_PROVIDER_ID);
        IServiceProviderDescriptor descriptor = service.getProviderDescriptor(providerId);
        if (descriptor != null && (provider = ServiceModelManager.getInstance().getServiceProvider(descriptor)) != null) {
            if (provider instanceof ServiceProvider) {
                IMemento providerConfigMemento = providerMemento.getChild(PROVIDER_CONFIGURATION_ELEMENT_NAME);
                ((ServiceProvider)provider).restoreState(providerConfigMemento);
            }
            return provider;
        }
        return null;
    }

    private static void saveProviderState(IServiceProvider provider, IMemento parentMemento) {
        if (provider instanceof ServiceProvider) {
            IMemento providerConfigMemento = parentMemento.createChild(PROVIDER_CONFIGURATION_ELEMENT_NAME);
            ((ServiceProvider)provider).saveState(providerConfigMemento);
        }
    }

    public static synchronized BuildConfigurationManager getInstance() {
        if (fInstance == null) {
            fInstance = new BuildConfigurationManager();
        }
        return fInstance;
    }

    private BuildConfigurationManager() {
        try {
            this.loadConfigurationData();
        }
        catch (WorkbenchException e) {
            this.handleInitError(e);
        }
        catch (IOException e) {
            this.handleInitError(e);
        }
    }

    public BuildScenario createLocalBuildScenario(IProject project) throws CoreException {
        IRemoteServices localService = PTPRemoteCorePlugin.getDefault().getRemoteServices("org.eclipse.ptp.remote.LocalServices", null);
        if (localService != null) {
            IRemoteConnection localConnection = localService.getConnectionManager().getConnection("Local");
            if (localConnection != null) {
                return new BuildScenario(null, localConnection, project.getLocation().toString());
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.rdt.sync.core", Messages.BCM_LocalConnectionError));
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.rdt.sync.core", Messages.BCM_LocalServiceError));
    }

    public IConfiguration createLocalConfiguration(IProject project) {
        try {
            BuildScenario localBuildScenario = this.createLocalBuildScenario(project);
            if (localBuildScenario != null) {
                return this.createConfiguration(project, localBuildScenario, Messages.WorkspaceConfigName, Messages.BCM_WorkspaceConfigDes);
            }
        }
        catch (CoreException e) {
            RDTSyncCorePlugin.log(String.valueOf(Messages.BCM_CreateConfigFailure) + e.getMessage(), e);
        }
        return null;
    }

    public IConfiguration createRemoteConfiguration(IProject project, BuildScenario remoteBuildScenario, String configName, String configDesc) {
        return this.createConfiguration(project, remoteBuildScenario, configName, configDesc);
    }

    public URI getActiveSyncLocationURI(IResource resource) throws CoreException {
        if (resource.getProject().hasNature("org.eclipse.ptp.rdt.sync.core.remoteSyncNature")) {
            IConfiguration configuration = ManagedBuildManager.getBuildInfo((IResource)resource.getProject()).getDefaultConfiguration();
            return this.getSyncLocationURI(configuration, resource);
        }
        return null;
    }

    public BuildScenario getBuildScenarioForBuildConfiguration(IConfiguration bconf) {
        String parentConfigId;
        if (bconf == null) {
            throw new NullPointerException();
        }
        if (!this.fProjectToTemplateConfigurationMap.containsKey(bconf.getOwner().getProject())) {
            throw new RuntimeException(Messages.BCM_InitError);
        }
        this.initializeOrUpdateConfigurations(bconf.getOwner().getProject(), null);
        BuildScenario buildScenario = this.fBuildConfigToBuildScenarioMap.get(bconf.getId());
        if (buildScenario == null && (parentConfigId = this.findAncestorConfig(bconf.getId())) != null) {
            buildScenario = this.fBuildConfigToBuildScenarioMap.get(parentConfigId);
        }
        return buildScenario;
    }

    public IServiceConfiguration getConfigurationForBuildConfiguration(IConfiguration bconf) {
        if (bconf == null) {
            throw new NullPointerException();
        }
        if (!this.fProjectToTemplateConfigurationMap.containsKey(bconf.getOwner().getProject())) {
            throw new RuntimeException(Messages.BCM_InitError);
        }
        this.initializeOrUpdateConfigurations(bconf.getOwner().getProject(), null);
        BuildScenario bs = this.fBuildConfigToBuildScenarioMap.get(bconf.getId());
        if (bs == null) {
            return null;
        }
        IServiceConfiguration conf = this.fBuildScenarioToSConfigMap.get(bs);
        if (conf == null) {
            throw new RuntimeException(Messages.BCM_ScenarioToServiceConfigError);
        }
        return conf;
    }

    public String getProjectSyncProvider(IProject project) {
        IServiceConfiguration serviceConfig = this.fProjectToTemplateConfigurationMap.get(project);
        if (serviceConfig == null) {
            return null;
        }
        IService syncService = ServiceModelManager.getInstance().getService("org.eclipse.ptp.rdt.sync.core.SyncService");
        return serviceConfig.getServiceProvider(syncService).getName();
    }

    public URI getSyncLocationURI(IConfiguration configuration, IResource resource) throws CoreException {
        BuildScenario scenario = this.getBuildScenarioForBuildConfiguration(configuration);
        if (scenario != null) {
            IPath path = new Path(scenario.location).append(resource.getProjectRelativePath());
            IRemoteConnection conn = scenario.getRemoteConnection();
            if (conn != null) {
                IRemoteFileManager fileMgr = scenario.getRemoteConnection().getRemoteServices().getFileManager(conn);
                return fileMgr.toURI(path);
            }
        }
        return null;
    }

    public void initProject(IProject project, IServiceConfiguration sc, BuildScenario bs) {
        if (project == null || sc == null || bs == null) {
            throw new NullPointerException();
        }
        this.fProjectToTemplateConfigurationMap.put(project, sc);
        this.fTemplateToProjectMap.put(sc, project);
        this.initializeOrUpdateConfigurations(project, bs);
    }

    public boolean isInitialized(IProject project) {
        if (project == null) {
            throw new NullPointerException();
        }
        return this.fProjectToTemplateConfigurationMap.containsKey(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void saveConfigurationData() throws IOException {
        XMLMemento rootMemento = XMLMemento.createWriteRoot((String)BUILD_CONFIGURATION_ELEMENT_NAME);
        IServiceConfiguration[] templateServiceConfigurationArray = this.fProjectToTemplateConfigurationMap.values().toArray(new IServiceConfiguration[0]);
        this.saveServiceConfigurations((IMemento)rootMemento, templateServiceConfigurationArray, TEMPLATE_SERVICE_CONFIGURATION_ELEMENT_NAME);
        HashMap<BuildScenario, Integer> buildScenarioToIdMap = new HashMap<BuildScenario, Integer>();
        int idNumber = 0;
        Map<Object, Object> map = this.fBuildScenarioToSConfigMap;
        synchronized (map) {
            for (BuildScenario bs : this.fBuildScenarioToSConfigMap.keySet()) {
                IMemento bsMemento = rootMemento.createChild(BUILD_SCENARIO_ELEMENT_NAME);
                bs.saveScenario(bsMemento);
                bsMemento.putString(ATTR_SERVICE_ID, this.fBuildScenarioToSConfigMap.get(bs).getId());
                bsMemento.putInteger(ATTR_ID, idNumber);
                buildScenarioToIdMap.put(bs, idNumber);
                ++idNumber;
            }
        }
        map = this.fBuildConfigToBuildScenarioMap;
        synchronized (map) {
            for (String configId : this.fBuildConfigToBuildScenarioMap.keySet()) {
                IMemento configMemento = rootMemento.createChild(CONFIG_ID_ELEMENT_NAME);
                configMemento.putString(ATTR_ID, configId);
                configMemento.putInteger(ATTR_BUILD_SCENARIO_ID, ((Integer)buildScenarioToIdMap.get(this.fBuildConfigToBuildScenarioMap.get(configId))).intValue());
            }
        }
        IPath savePath = ServicesCorePlugin.getDefault().getStateLocation().append(DEFAULT_SAVE_FILE_NAME);
        File saveFile = savePath.toFile();
        rootMemento.save((Writer)new FileWriter(saveFile));
    }

    public void setBuildScenarioForBuildConfiguration(BuildScenario bs, IConfiguration bconf) {
        if (bs == null || bconf == null) {
            throw new NullPointerException();
        }
        if (!this.fProjectToTemplateConfigurationMap.containsKey(bconf.getOwner().getProject())) {
            throw new RuntimeException(Messages.BCM_InitError);
        }
        this.initializeOrUpdateConfigurations(bconf.getOwner().getProject(), null);
        this.setBuildScenarioForBuildConfigurationInternal(bs, bconf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBuildScenario(IProject project, BuildScenario buildScenario) {
        Map<BuildScenario, IServiceConfiguration> map = this.fBuildScenarioToSConfigMap;
        synchronized (map) {
            if (this.fBuildScenarioToSConfigMap.containsKey(buildScenario)) {
                return;
            }
            IServiceConfiguration sConfig = this.copyTemplateServiceConfiguration(project);
            this.modifyServiceConfigurationForBuildScenario(sConfig, buildScenario);
            this.fBuildScenarioToSConfigMap.put(buildScenario, sConfig);
        }
    }

    private IServiceConfiguration copyTemplateServiceConfiguration(IProject project) {
        IServiceConfiguration newConfig = ServiceModelManager.getInstance().newServiceConfiguration("");
        IServiceConfiguration oldConfig = this.fProjectToTemplateConfigurationMap.get(project);
        if (oldConfig == null) {
            throw new RuntimeException(String.valueOf(Messages.BCM_TemplateError) + project.getName());
        }
        for (IService service : oldConfig.getServices()) {
            ServiceProvider oldProvider = (ServiceProvider)oldConfig.getServiceProvider(service);
            try {
                ServiceProvider newProvider = (ServiceProvider)oldProvider.getClass().newInstance();
                XMLMemento oldProviderState = XMLMemento.createWriteRoot((String)PROVIDER_ELEMENT_NAME);
                oldProvider.saveState((IMemento)oldProviderState);
                newProvider.restoreState((IMemento)oldProviderState);
                newConfig.setServiceProvider(service, (IServiceProvider)newProvider);
            }
            catch (InstantiationException instantiationException) {
                throw new RuntimeException(String.valueOf(Messages.BCM_ProviderError) + oldProvider.getClass());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(String.valueOf(Messages.BCM_ProviderError) + oldProvider.getClass());
            }
        }
        return newConfig;
    }

    private IConfiguration createConfiguration(IProject project, BuildScenario buildScenario, String configName, String configDesc) {
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        if (buildInfo == null) {
            return null;
        }
        Throwable creationException = null;
        String creationError = null;
        boolean configAdded = false;
        ManagedProject managedProject = (ManagedProject)buildInfo.getManagedProject();
        Configuration configParent = (Configuration)buildInfo.getDefaultConfiguration();
        String configId = ManagedBuildManager.calculateChildId((String)configParent.getId(), null);
        Configuration config = new Configuration(managedProject, configParent, configId, true, false);
        CConfigurationData configData = config.getConfigurationData();
        ICProjectDescription projectDes = CoreModel.getDefault().getProjectDescription(project);
        ICConfigurationDescription configDes = null;
        try {
            configDes = projectDes.createConfiguration(ManagedBuildManager.CFG_DATA_PROVIDER_ID, configData);
        }
        catch (WriteAccessException e) {
            creationException = e;
        }
        catch (CoreException e) {
            creationException = e;
        }
        if (configDes != null) {
            config.setConfigurationDescription(configDes);
            configDes.setName(configName);
            configDes.setDescription(configDesc);
            config.getToolChain().getBuilder().setBuildPath(project.getLocation().toString());
            this.setBuildScenarioForBuildConfigurationInternal(buildScenario, (IConfiguration)config);
            configAdded = true;
            try {
                CoreModel.getDefault().setProjectDescription(project, projectDes, true, null);
            }
            catch (CoreException e) {
                projectDes.removeConfiguration(configDes);
                configAdded = false;
                creationException = e;
                creationError = Messages.BCM_SetConfigDescriptionError;
            }
            if (configAdded) {
                try {
                    this.saveConfigurationData();
                }
                catch (IOException iOException) {
                    projectDes.removeConfiguration(configDes);
                }
            }
        } else {
            creationError = Messages.BCM_CreateConfigError;
        }
        if (!configAdded) {
            if (creationError == null && creationException != null) {
                creationError = creationException.getMessage();
            }
            RDTSyncCorePlugin.log(String.valueOf(Messages.BCM_CreateConfigFailure) + creationError, creationException);
            return null;
        }
        return config;
    }

    private void deleteBuildScenario(IProject project, BuildScenario buildScenario) {
        IServiceConfiguration oldConfig = this.fBuildScenarioToSConfigMap.get(buildScenario);
        if (oldConfig == null) {
            throw new RuntimeException(Messages.BCM_ScenarioToServiceConfigError);
        }
        this.fBuildScenarioToSConfigMap.remove(buildScenario);
    }

    private void doLoadConfigurations(IMemento rootMemento, String mementoChildName) {
        ServiceModelManager smm = ServiceModelManager.getInstance();
        HashSet<ServiceConfiguration> configs = new HashSet<ServiceConfiguration>();
        IMemento[] iMementoArray = rootMemento.getChildren(mementoChildName);
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IService service;
            String serviceId;
            IMemento configMemento = iMementoArray[n2];
            String configName = configMemento.getString(ATTR_NAME);
            String projectName = configMemento.getString(ATTR_PROJECT);
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (project == null) {
                throw new RuntimeException(String.valueOf(Messages.BCM_ProjectError) + project);
            }
            ServiceConfiguration config = (ServiceConfiguration)smm.newServiceConfiguration(configName);
            IMemento[] iMementoArray2 = configMemento.getChildren(SERVICE_ELEMENT_NAME);
            int n3 = iMementoArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                IMemento serviceMemento = iMementoArray2[n4];
                serviceId = serviceMemento.getString(ATTR_ID);
                service = smm.getService(serviceId);
                IServiceProvider provider = BuildConfigurationManager.loadServiceProvider(serviceMemento, service);
                config.setServiceProvider(service, provider);
                ++n4;
            }
            iMementoArray2 = configMemento.getChildren(DISABLED_PROVIDERS_ELEMENT_NAME);
            n3 = iMementoArray2.length;
            n4 = 0;
            while (n4 < n3) {
                IMemento disabledMemento = iMementoArray2[n4];
                serviceId = disabledMemento.getString(ATTR_ID);
                service = smm.getService(serviceId);
                IMemento[] iMementoArray3 = disabledMemento.getChildren(PROVIDER_ELEMENT_NAME);
                int n5 = iMementoArray3.length;
                int n6 = 0;
                while (n6 < n5) {
                    IMemento providerMemento = iMementoArray3[n6];
                    IServiceProvider provider = BuildConfigurationManager.loadServiceProvider(providerMemento, service);
                    config.addFormerServiceProvider(service, provider);
                    ++n6;
                }
                ++n4;
            }
            configs.add(config);
            this.fProjectToTemplateConfigurationMap.put(project, (IServiceConfiguration)config);
            this.fTemplateToProjectMap.put((IServiceConfiguration)config, project);
            ++n2;
        }
    }

    private String findAncestorConfig(String configId) {
        while ((configId = BuildConfigurationManager.getParentId(configId)) != null) {
            if (!this.fBuildConfigToBuildScenarioMap.containsKey(configId)) continue;
            return configId;
        }
        return null;
    }

    private void handleInitError(Throwable e) {
        fInstance = null;
        RDTSyncCorePlugin.log(Messages.BCM_InitializationError, e);
    }

    private void initializeOrUpdateConfigurations(IProject project, BuildScenario bs) {
        IConfiguration[] allConfigs;
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        if (buildInfo == null) {
            throw new RuntimeException(String.valueOf(Messages.BCM_BuildInfoError) + project.getName());
        }
        IConfiguration[] iConfigurationArray = allConfigs = buildInfo.getManagedProject().getConfigurations();
        int n = allConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration config = iConfigurationArray[n2];
            if (bs == null) {
                if (!this.fBuildConfigToBuildScenarioMap.containsKey(config.getId())) {
                    String parentConfig = this.findAncestorConfig(config.getId());
                    if (parentConfig == null) {
                        throw new RuntimeException(String.valueOf(Messages.BCM_AncestorError) + config.getId());
                    }
                    this.setBuildScenarioForBuildConfigurationInternal(this.fBuildConfigToBuildScenarioMap.get(parentConfig), config);
                }
            } else {
                this.setBuildScenarioForBuildConfigurationInternal(bs, config);
            }
            ++n2;
        }
    }

    private void loadConfigurationData() throws IOException, WorkbenchException {
        IPath loadPath = ServicesCorePlugin.getDefault().getStateLocation().append(DEFAULT_SAVE_FILE_NAME);
        File loadFile = loadPath.toFile();
        if (!loadFile.exists()) {
            return;
        }
        BufferedReader reader = new BufferedReader(new FileReader(loadFile));
        XMLMemento rootMemento = XMLMemento.createReadRoot((Reader)reader);
        this.fProjectToTemplateConfigurationMap.clear();
        this.fTemplateToProjectMap.clear();
        this.fBuildConfigToBuildScenarioMap.clear();
        this.fBuildScenarioToSConfigMap.clear();
        this.doLoadConfigurations((IMemento)rootMemento, TEMPLATE_SERVICE_CONFIGURATION_ELEMENT_NAME);
        HashMap<String, IConfiguration> confSet = new HashMap<String, IConfiguration>();
        for (IProject project : this.fProjectToTemplateConfigurationMap.keySet()) {
            IConfiguration[] bconfs;
            IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
            if (buildInfo == null) continue;
            IConfiguration[] iConfigurationArray = bconfs = buildInfo.getManagedProject().getConfigurations();
            int n = bconfs.length;
            int n2 = 0;
            while (n2 < n) {
                IConfiguration bconf = iConfigurationArray[n2];
                confSet.put(bconf.getId(), bconf);
                ++n2;
            }
        }
        HashMap<Integer, BuildScenario> IdToBuildScenarioMap = new HashMap<Integer, BuildScenario>();
        IMemento[] iMementoArray = rootMemento.getChildren(BUILD_SCENARIO_ELEMENT_NAME);
        int n = iMementoArray.length;
        int n3 = 0;
        while (n3 < n) {
            IMemento bsMemento = iMementoArray[n3];
            BuildScenario bs = BuildScenario.loadScenario(bsMemento);
            Integer id = bsMemento.getInteger(ATTR_ID);
            IdToBuildScenarioMap.put(id, bs);
            ++n3;
        }
        iMementoArray = rootMemento.getChildren(CONFIG_ID_ELEMENT_NAME);
        n = iMementoArray.length;
        n3 = 0;
        while (n3 < n) {
            BuildScenario bs;
            IMemento configMemento = iMementoArray[n3];
            String configId = configMemento.getString(ATTR_ID);
            Integer buildScenarioId = configMemento.getInteger(ATTR_BUILD_SCENARIO_ID);
            IConfiguration config = (IConfiguration)confSet.get(configId);
            if (config != null && (bs = (BuildScenario)IdToBuildScenarioMap.get(buildScenarioId)) != null) {
                this.setBuildScenarioForBuildConfigurationInternal((BuildScenario)IdToBuildScenarioMap.get(buildScenarioId), config);
            }
            ++n3;
        }
    }

    private void modifyServiceConfigurationForBuildScenario(IServiceConfiguration sConfig, BuildScenario bs) {
        IService syncService = null;
        for (IService service : sConfig.getServices()) {
            ServiceProvider provider = (ServiceProvider)sConfig.getServiceProvider(service);
            if (!(provider instanceof IRemoteExecutionServiceProvider)) continue;
            if (provider instanceof ISyncServiceProvider && bs.getSyncProvider() == null) {
                syncService = service;
                continue;
            }
            ((IRemoteExecutionServiceProvider)provider).setRemoteToolsConnection(bs.getRemoteConnection());
            ((IRemoteExecutionServiceProvider)provider).setConfigLocation(bs.getLocation());
        }
        if (syncService != null) {
            sConfig.disable(syncService);
        }
    }

    private void saveServiceConfigurations(IMemento memento, IServiceConfiguration[] configs, String mementoChildName) {
        IServiceConfiguration[] iServiceConfigurationArray = configs;
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            IServiceConfiguration config = iServiceConfigurationArray[n2];
            String configurationName = config.getName();
            String projectName = this.fTemplateToProjectMap.get(config).getName();
            IMemento configMemento = memento.createChild(mementoChildName);
            configMemento.putString(ATTR_NAME, configurationName);
            configMemento.putString(ATTR_PROJECT, projectName);
            Set services = config.getServices();
            for (IService service : services) {
                Set disabledProviders;
                if (!config.isDisabled(service)) {
                    IServiceProvider provider = config.getServiceProvider(service);
                    IMemento serviceMemento = configMemento.createChild(SERVICE_ELEMENT_NAME);
                    serviceMemento.putString(ATTR_ID, service.getId());
                    serviceMemento.putString(ATTR_PROVIDER_ID, provider.getId());
                    BuildConfigurationManager.saveProviderState(provider, serviceMemento);
                }
                if (!(config instanceof ServiceConfiguration) || (disabledProviders = ((ServiceConfiguration)config).getFormerServiceProviders(service)).isEmpty()) continue;
                IMemento disabledMemento = configMemento.createChild(DISABLED_PROVIDERS_ELEMENT_NAME);
                disabledMemento.putString(ATTR_ID, service.getId());
                for (IServiceProvider disabledProvider : disabledProviders) {
                    IMemento providerMemento = disabledMemento.createChild(PROVIDER_ELEMENT_NAME);
                    providerMemento.putString(ATTR_PROVIDER_ID, disabledProvider.getId());
                    BuildConfigurationManager.saveProviderState(disabledProvider, providerMemento);
                }
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBuildScenarioForBuildConfigurationInternal(BuildScenario bs, IConfiguration bconf) {
        Map<String, BuildScenario> map = this.fBuildConfigToBuildScenarioMap;
        synchronized (map) {
            BuildScenario oldbs = this.fBuildConfigToBuildScenarioMap.get(bconf.getId());
            this.fBuildConfigToBuildScenarioMap.put(bconf.getId(), bs);
            if (oldbs != null && !this.fBuildConfigToBuildScenarioMap.containsValue(oldbs)) {
                this.deleteBuildScenario(bconf.getOwner().getProject(), oldbs);
            }
            this.addBuildScenario(bconf.getOwner().getProject(), bs);
        }
    }
}

