/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.sync.core;

import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ui.IMemento;

public class BuildScenario {
    private static final String ATTR_SYNC_PROVIDER = "sync-provider";
    private static final String ATTR_REMOTE_CONNECTION_ID = "remote-connection-id";
    private static final String ATTR_LOCATION = "location";
    private static final String ATTR_REMOTE_SERVICES_ID = "remote-services-id";
    final String syncProvider;
    final IRemoteConnection remoteConnection;
    final String location;

    public BuildScenario(String sp, IRemoteConnection rc, String l) {
        this.syncProvider = sp;
        this.remoteConnection = rc;
        this.location = l;
    }

    public String getSyncProvider() {
        return this.syncProvider;
    }

    public IRemoteConnection getRemoteConnection() {
        return this.remoteConnection;
    }

    public String getLocation() {
        return this.location;
    }

    public void saveScenario(IMemento memento) {
        if (this.syncProvider != null) {
            memento.putString(ATTR_SYNC_PROVIDER, this.syncProvider);
        }
        memento.putString(ATTR_REMOTE_CONNECTION_ID, this.remoteConnection.getName());
        memento.putString(ATTR_LOCATION, this.location);
        memento.putString(ATTR_REMOTE_SERVICES_ID, this.remoteConnection.getRemoteServices().getId());
    }

    public static BuildScenario loadScenario(IMemento memento) {
        String sp = memento.getString(ATTR_SYNC_PROVIDER);
        String rc = memento.getString(ATTR_REMOTE_CONNECTION_ID);
        String l = memento.getString(ATTR_LOCATION);
        String rs = memento.getString(ATTR_REMOTE_SERVICES_ID);
        if (rc == null || l == null || rs == null) {
            return null;
        }
        IRemoteServices remoteService = PTPRemoteCorePlugin.getDefault().getRemoteServices(rs);
        if (remoteService == null) {
            return null;
        }
        IRemoteConnection remoteConnection = remoteService.getConnectionManager().getConnection(rc);
        if (remoteConnection == null) {
            return null;
        }
        return new BuildScenario(sp, remoteConnection, l);
    }
}

