/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.sync.core;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.utils.UNCPathConverter;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;

public class SyncUNCPathConverter
extends UNCPathConverter {
    private static Map<String, IRemoteConnection> fConnMap = new HashMap<String, IRemoteConnection>();

    public URI toURI(IPath path) {
        String server = path.segment(0);
        IRemoteConnection conn = fConnMap.get(server);
        if (conn == null) {
            IRemoteServices[] services;
            IRemoteServices[] iRemoteServicesArray = services = PTPRemoteCorePlugin.getDefault().getAllRemoteServices((IProgressMonitor)new NullProgressMonitor());
            int n = services.length;
            int n2 = 0;
            while (n2 < n) {
                IRemoteServices service = iRemoteServicesArray[n2];
                conn = service.getConnectionManager().getConnection(server);
                if (conn != null) {
                    fConnMap.put(server, conn);
                    break;
                }
                ++n2;
            }
        }
        if (conn != null) {
            String scheme = conn.getRemoteServices().getScheme();
            String filePath = path.removeFirstSegments(1).makeAbsolute().toString();
            try {
                return new URI(scheme, server, filePath, null);
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        return null;
    }

    public URI toURI(String path) {
        return this.toURI((IPath)new Path(path));
    }
}

