/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.analysis.types;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.eclipse.photran.internal.core.parser.ASTExplicitShapeSpecNode;
import org.eclipse.photran.internal.core.parser.IASTNode;
import org.eclipse.photran.internal.core.parser.IExpr;
import org.eclipse.photran.internal.core.vpg.IPhotranSerializable;
import org.eclipse.photran.internal.core.vpg.PhotranVPGSerializer;

public class Dimension
implements IPhotranSerializable {
    private static final long serialVersionUID = 1L;
    private String lboundAsString;
    private String uboundAsString;

    public Dimension(ASTExplicitShapeSpecNode node) {
        IExpr lbound = node.getLb();
        IExpr ubound = node.getUb();
        this.lboundAsString = lbound == null ? null : Dimension.getSourceCodeFromASTNode(lbound);
        this.uboundAsString = ubound == null ? null : Dimension.getSourceCodeFromASTNode(ubound);
    }

    public boolean hasConstantBounds() {
        return this.uboundAsString != null && this.isLiteralInteger(this.lboundAsString) && this.isLiteralInteger(this.uboundAsString);
    }

    private boolean isLiteralInteger(String string) {
        if (string == null) {
            return true;
        }
        string = string.trim();
        int i = 0;
        int len = string.length();
        while (i < len) {
            if (!Character.isDigit(string.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int getConstantLowerBound() {
        return this.lboundAsString == null ? 1 : Integer.parseInt(this.lboundAsString.trim());
    }

    public int getConstantUpperBound() {
        return Integer.parseInt(this.uboundAsString.trim());
    }

    private static String getSourceCodeFromASTNode(IASTNode node) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        node.printOn(new PrintStream(out), null);
        return out.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.lboundAsString != null) {
            sb.append(this.lboundAsString);
            sb.append(":");
        }
        sb.append(this.uboundAsString);
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof Dimension)) {
            return false;
        }
        Dimension o = (Dimension)other;
        return this.equals(this.lboundAsString, o.lboundAsString) && this.equals(this.uboundAsString, o.uboundAsString);
    }

    private boolean equals(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a != null && b != null) {
            return a.equals(b);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode(this.lboundAsString) + this.hashCode(this.uboundAsString);
    }

    private int hashCode(Object o) {
        return o == null ? 0 : o.hashCode();
    }

    private Dimension() {
    }

    public static Dimension readFrom(InputStream in) throws IOException {
        Dimension result = new Dimension();
        result.lboundAsString = (String)PhotranVPGSerializer.deserialize(in);
        result.uboundAsString = (String)PhotranVPGSerializer.deserialize(in);
        return result;
    }

    public void writeTo(OutputStream out) throws IOException {
        PhotranVPGSerializer.serialize(this.lboundAsString, out);
        PhotranVPGSerializer.serialize(this.uboundAsString, out);
    }

    public char getSerializationCode() {
        return 'M';
    }
}

