/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.vpg;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.FortranCorePlugin;
import org.eclipse.photran.internal.core.analysis.binding.Binder;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.analysis.binding.ImplicitSpec;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.analysis.binding.VariableAccess;
import org.eclipse.photran.internal.core.analysis.flow.ControlFlowAnalysis;
import org.eclipse.photran.internal.core.analysis.loops.LoopReplacer;
import org.eclipse.photran.internal.core.lexer.ASTLexerFactory;
import org.eclipse.photran.internal.core.lexer.FixedFormReplacement;
import org.eclipse.photran.internal.core.lexer.IAccumulatingLexer;
import org.eclipse.photran.internal.core.lexer.LexerException;
import org.eclipse.photran.internal.core.lexer.Terminal;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.lexer.preprocessor.fortran_include.IncludeLoaderCallback;
import org.eclipse.photran.internal.core.parser.ASTExecutableProgramNode;
import org.eclipse.photran.internal.core.parser.ASTNodeWithErrorRecoverySymbols;
import org.eclipse.photran.internal.core.parser.Parser;
import org.eclipse.photran.internal.core.sourceform.ISourceForm;
import org.eclipse.photran.internal.core.sourceform.SourceForm;
import org.eclipse.photran.internal.core.vpg.AnnotationType;
import org.eclipse.photran.internal.core.vpg.EdgeType;
import org.eclipse.photran.internal.core.vpg.Messages;
import org.eclipse.photran.internal.core.vpg.PhotranTokenRef;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.rephraserengine.core.util.LRUCache;
import org.eclipse.rephraserengine.core.vpg.ILazyVPGPopulator;
import org.eclipse.rephraserengine.core.vpg.IVPGNode;
import org.eclipse.rephraserengine.core.vpg.VPGDB;
import org.eclipse.rephraserengine.core.vpg.VPGDependency;
import org.eclipse.rephraserengine.core.vpg.VPGEdge;
import org.eclipse.rephraserengine.core.vpg.VPGLog;
import org.eclipse.rephraserengine.core.vpg.eclipse.EclipseVPGWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhotranVPGWriter
extends EclipseVPGWriter<IFortranAST, Token, PhotranTokenRef> {
    protected LRUCache<String, List<Definition>> moduleSymTabCache = new LRUCache(5);
    protected long moduleSymTabCacheHits = 0L;
    protected long moduleSymTabCacheMisses = 0L;
    private static final int MODULE_SYMTAB_CACHE_SIZE = 5;
    protected Parser parser = new Parser();
    private List<IMarker> errorLogMarkers = null;
    private boolean isDefinitionCachingEnabled = false;

    protected PhotranVPGWriter(VPGDB<IFortranAST, Token, PhotranTokenRef> db, VPGLog<Token, PhotranTokenRef> log) {
        super(db, log);
    }

    public void markFileAsExportingSubprogram(IFile file, String subprogramName) {
        this.db.ensure(new VPGDependency("subprogram:" + PhotranVPGWriter.canonicalizeIdentifier(subprogramName), PhotranVPGWriter.getFilenameForIFile((IFile)file)));
    }

    public void markFileAsImportingSubprogram(IFile file, String subprogramName) {
        this.db.ensure(new VPGDependency(PhotranVPGWriter.getFilenameForIFile((IFile)file), "subprogram:" + PhotranVPGWriter.canonicalizeIdentifier(subprogramName)));
    }

    public void markFileAsExportingModule(IFile file, String moduleName) {
        this.db.ensure(new VPGDependency("module:" + PhotranVPGWriter.canonicalizeIdentifier(moduleName), PhotranVPGWriter.getFilenameForIFile((IFile)file)));
    }

    public void markFileAsImportingModule(IFile file, String moduleName) {
        this.db.ensure(new VPGDependency(PhotranVPGWriter.getFilenameForIFile((IFile)file), "module:" + PhotranVPGWriter.canonicalizeIdentifier(moduleName)));
    }

    public void markFileAsUsingCommonBlock(IFile file, String commonBlockName) {
        this.db.ensure(new VPGDependency(PhotranVPGWriter.getFilenameForIFile((IFile)file), "common:" + PhotranVPGWriter.canonicalizeIdentifier(commonBlockName)));
    }

    public void setDefinitionFor(PhotranTokenRef tokenRef, Definition definition) {
        this.db.setAnnotation((IVPGNode)tokenRef, (Enum)AnnotationType.DEFINITION_ANNOTATION_TYPE, (Serializable)definition);
    }

    public void markDefinitionVisibilityInScope(PhotranTokenRef definitionTokenRef, ScopingNode scope, Definition.Visibility visibility) {
        VPGEdge privateEdge = new VPGEdge((IVPGNode)definitionTokenRef, (IVPGNode)scope.getRepresentativeToken(), (Enum)EdgeType.DEFINITION_IS_PRIVATE_IN_SCOPE_EDGE_TYPE);
        if (visibility.equals((Object)Definition.Visibility.PRIVATE)) {
            this.db.ensure(privateEdge);
        } else {
            this.db.delete(privateEdge);
        }
    }

    public void markScope(PhotranTokenRef identifier, ScopingNode scope) {
        this.db.ensure(new VPGEdge((IVPGNode)identifier, (IVPGNode)scope.getRepresentativeToken(), (Enum)EdgeType.DEFINED_IN_SCOPE_EDGE_TYPE));
    }

    public void markIllegalShadowing(PhotranTokenRef shadowingIdent, PhotranTokenRef shadowedIdent) {
        this.db.ensure(new VPGEdge((IVPGNode)shadowingIdent, (IVPGNode)shadowedIdent, (Enum)EdgeType.ILLEGAL_SHADOWING_EDGE_TYPE));
    }

    public void markBinding(PhotranTokenRef reference, PhotranTokenRef definition) {
        this.db.ensure(new VPGEdge((IVPGNode)reference, (IVPGNode)definition, (Enum)EdgeType.BINDING_EDGE_TYPE));
    }

    public void markRenamedBinding(PhotranTokenRef reference, PhotranTokenRef definition) {
        this.db.ensure(new VPGEdge((IVPGNode)reference, (IVPGNode)definition, (Enum)EdgeType.RENAMED_BINDING_EDGE_TYPE));
    }

    public void setScopeImplicitSpec(ScopingNode scope, ImplicitSpec implicitSpec) {
        if (implicitSpec != null) {
            this.db.setAnnotation((IVPGNode)scope.getRepresentativeToken(), (Enum)AnnotationType.SCOPE_IMPLICIT_SPEC_ANNOTATION_TYPE, (Serializable)implicitSpec);
        } else {
            this.db.deleteAnnotation((IVPGNode)scope.getRepresentativeToken(), (Enum)AnnotationType.SCOPE_IMPLICIT_SPEC_ANNOTATION_TYPE);
        }
    }

    public void setDefaultScopeVisibilityToPrivate(ScopingNode scope) {
        this.db.setAnnotation((IVPGNode)scope.getRepresentativeToken(), (Enum)AnnotationType.SCOPE_DEFAULT_VISIBILITY_IS_PRIVATE_ANNOTATION_TYPE, (Serializable)Boolean.TRUE);
    }

    public void setModuleSymbolTable(Token moduleNameToken, List<Definition> symbolTable) {
        PhotranVPG vpg = PhotranVPG.getInstance();
        this.clearModuleSymbolTableEntries(moduleNameToken);
        String filename = "module:" + PhotranVPGWriter.canonicalizeIdentifier(moduleNameToken.getText());
        PhotranTokenRef tokenRef = (PhotranTokenRef)vpg.getVPGNode(filename, 0, 0);
        this.db.setAnnotation((IVPGNode)tokenRef, (Enum)AnnotationType.MODULE_TOKENREF_ANNOTATION_TYPE, (Serializable)moduleNameToken.getTokenRef());
        int entries = 0;
        for (Definition def : symbolTable) {
            tokenRef = (PhotranTokenRef)vpg.getVPGNode(filename, entries++, 0);
            this.db.setAnnotation((IVPGNode)tokenRef, (Enum)AnnotationType.MODULE_SYMTAB_ENTRY_ANNOTATION_TYPE, (Serializable)def);
        }
        tokenRef = (PhotranTokenRef)vpg.getVPGNode(filename, 0, 0);
        this.db.setAnnotation((IVPGNode)tokenRef, (Enum)AnnotationType.MODULE_SYMTAB_ENTRY_COUNT_ANNOTATION_TYPE, (Serializable)Integer.valueOf(entries));
    }

    public List<Definition> getModuleSymbolTable(String moduleName) {
        if (this.moduleSymTabCache.contains((Object)moduleName)) {
            ++this.moduleSymTabCacheHits;
            return (List)this.moduleSymTabCache.get((Object)moduleName);
        }
        ++this.moduleSymTabCacheMisses;
        int entries = this.countModuleSymbolTableEntries(moduleName);
        if (entries == 0) {
            return new LinkedList<Definition>();
        }
        String filename = "module:" + PhotranVPGWriter.canonicalizeIdentifier(moduleName);
        ArrayList<Definition> result = new ArrayList<Definition>(entries);
        int i = 0;
        while (i < entries) {
            PhotranTokenRef tokenRef = (PhotranTokenRef)PhotranVPG.getInstance().getVPGNode(filename, i, 0);
            Serializable entry = this.db.getAnnotation((IVPGNode)tokenRef, (Enum)AnnotationType.MODULE_SYMTAB_ENTRY_ANNOTATION_TYPE);
            if (entry != null && entry instanceof Definition) {
                result.add((Definition)entry);
            }
            ++i;
        }
        this.moduleSymTabCache.cache((Object)moduleName, result);
        return result;
    }

    protected int countModuleSymbolTableEntries(String canonicalizedModuleName) {
        String filename = "module:" + canonicalizedModuleName;
        PhotranTokenRef tokenRef = (PhotranTokenRef)PhotranVPG.getInstance().getVPGNode(filename, 0, 0);
        Serializable result = this.db.getAnnotation((IVPGNode)tokenRef, (Enum)AnnotationType.MODULE_SYMTAB_ENTRY_COUNT_ANNOTATION_TYPE);
        return result == null || !(result instanceof Integer) ? 0 : (Integer)result;
    }

    private void clearModuleSymbolTableEntries(Token moduleNameToken) {
        PhotranVPG vpg = PhotranVPG.getInstance();
        String canonicalizedModuleName = PhotranVPGWriter.canonicalizeIdentifier(moduleNameToken.getText());
        this.moduleSymTabCache.remove((Object)canonicalizedModuleName);
        int entries = this.countModuleSymbolTableEntries(canonicalizedModuleName);
        if (entries > 0) {
            String filename = "module:" + canonicalizedModuleName;
            int i = 0;
            while (i < entries) {
                PhotranTokenRef tokenRef = (PhotranTokenRef)vpg.getVPGNode(filename, i, 0);
                this.db.deleteAnnotation((IVPGNode)tokenRef, (Enum)AnnotationType.MODULE_SYMTAB_ENTRY_ANNOTATION_TYPE);
                ++i;
            }
            PhotranTokenRef tokenRef = (PhotranTokenRef)vpg.getVPGNode(filename, 0, 0);
            this.db.setAnnotation((IVPGNode)tokenRef, (Enum)AnnotationType.MODULE_SYMTAB_ENTRY_COUNT_ANNOTATION_TYPE, (Serializable)Integer.valueOf(0));
        }
    }

    public void printModuleSymTabCacheStatisticsOn(PrintStream out) {
        out.println("Module Symbol Table Cache Statistics:");
        long edgeTotal = this.moduleSymTabCacheHits + this.moduleSymTabCacheMisses;
        float edgeHitRatio = edgeTotal == 0L ? 0.0f : (float)this.moduleSymTabCacheHits / (float)edgeTotal * 100.0f;
        out.println("    Hit Ratio:        " + this.moduleSymTabCacheHits + "/" + edgeTotal + " (" + (long)Math.round(edgeHitRatio) + "%)");
    }

    public void resetStatistics() {
        this.moduleSymTabCacheMisses = 0L;
        this.moduleSymTabCacheHits = 0L;
    }

    public void computeDependencies(String filename) {
        if (PhotranVPG.getInstance().isVirtualFile(filename)) {
            return;
        }
        this.computeDependenciesUsingFastTokenizer(filename);
    }

    private void computeDependenciesUsingFastTokenizer(String filename) {
        try {
            IFile file = PhotranVPGWriter.getIFileForFilename((String)filename);
            if (file == null) {
                return;
            }
            BufferedReader r = new BufferedReader(new InputStreamReader(file.getContents(true), file.getCharset()));
            StreamTokenizer st = new StreamTokenizer(r);
            st.commentChar(33);
            st.eolIsSignificant(false);
            st.slashSlashComments(false);
            st.slashStarComments(false);
            st.wordChars(95, 95);
            while (st.nextToken() != -1) {
                if (st.ttype != -3) continue;
                if (st.sval.equalsIgnoreCase("module")) {
                    st.nextToken();
                    if (st.ttype == -3) {
                        this.markFileAsExportingModule(file, st.sval);
                        continue;
                    }
                    st.pushBack();
                    continue;
                }
                if (!st.sval.equalsIgnoreCase("use")) continue;
                st.nextToken();
                if (st.ttype == -3) {
                    this.markFileAsImportingModule(file, st.sval);
                    continue;
                }
                st.pushBack();
            }
        }
        catch (Exception e) {
            FortranCorePlugin.log((Throwable)e);
        }
    }

    private void computeDependenciesUsingLexer(String filename) {
        ISourceForm sourceForm = this.determineSourceForm(filename);
        try {
            IAccumulatingLexer lexer = new ASTLexerFactory().createLexer(PhotranVPGWriter.getIFileForFilename((String)filename), sourceForm);
            long start = System.currentTimeMillis();
            this.calculateDependencies(filename, lexer);
            PhotranVPG.getInstance().debug("  - Elapsed time in calculateDependencies: " + (System.currentTimeMillis() - start) + " ms", filename);
        }
        catch (Exception e) {
            this.log.logError((Throwable)e, (IVPGNode)new PhotranTokenRef(filename, 0, 0));
        }
    }

    private ISourceForm determineSourceForm(final String filename) {
        IFile file = PhotranVPGWriter.getIFileForFilename((String)filename);
        if (file == null) {
            return SourceForm.of((String)filename);
        }
        return SourceForm.of((IFile)file).configuredWith((Object)new IncludeLoaderCallback(file.getProject()){

            public Reader getIncludedFileAsStream(String fileToInclude) throws FileNotFoundException {
                PhotranVPGWriter.this.db.ensure(new VPGDependency(filename, PhotranVPGWriter.getFilenameForIFile((IFile)this.getIncludedFile(fileToInclude))));
                return super.getIncludedFileAsStream(fileToInclude);
            }

            public void logError(String message, IFile topLevelFile, int offset) {
                PhotranVPG.getInstance().getLog().clearEntriesFor(PhotranVPG.getFilenameForIFile((IFile)topLevelFile));
                PhotranVPG.getInstance().getLog().logError(message, (IVPGNode)new PhotranTokenRef(topLevelFile, offset, 0));
            }
        });
    }

    private void calculateDependencies(String filename, IAccumulatingLexer lexer) {
        if (!PhotranVPG.getInstance().isVirtualFile(filename)) {
            this.db.deleteAllIncomingDependenciesFor(filename);
            this.db.deleteAllOutgoingDependenciesFor(filename);
        }
        if (lexer == null) {
            return;
        }
        try {
            this.calculateFileDepsFromModuleAndUseStmts(filename, lexer);
        }
        catch (LexerException e) {
            if (e.getFile() != null && e.getFile().getIFile() != null) {
                filename = PhotranVPG.getFilenameForIFile((IFile)e.getFile().getIFile());
            }
            this.log.logError(e.getMessage(), (IVPGNode)new PhotranTokenRef(filename, e.getTokenOffset(), e.getTokenLength()));
        }
        catch (Exception e) {
            this.log.logError((Throwable)e);
        }
    }

    private void calculateFileDepsFromModuleAndUseStmts(String filename, IAccumulatingLexer lexer) throws Exception {
        IFile file = PhotranVPGWriter.getIFileForFilename((String)filename);
        int state = 0;
        Token tok = lexer.yylex();
        while (tok != null && tok.getTerminal() != Terminal.END_OF_INPUT) {
            if (state == 0 && tok.getTerminal() == Terminal.T_USE) {
                state = 1;
            } else if (state == 0 && tok.getTerminal() == Terminal.T_MODULE) {
                state = 2;
            } else if (state == 1) {
                if (tok.getTerminal() == Terminal.T_IDENT) {
                    this.markFileAsImportingModule(file, tok.getText());
                }
                state = 0;
            } else if (state == 2) {
                if (tok.getTerminal() == Terminal.T_IDENT) {
                    this.markFileAsExportingModule(file, tok.getText());
                }
                state = 0;
            }
            tok = lexer.yylex();
        }
    }

    public void computeEdgesAndAnnotationsFromModifiedAST(String filename, IFortranAST ast) {
        if (ast == null) {
            throw new IllegalArgumentException(String.valueOf(filename) + " returned null AST");
        }
        try {
            String charset = Charset.defaultCharset().name();
            ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
            ast.getRoot().printOn(new PrintStream((OutputStream)out, false, charset), null);
            ast = this.parse(filename, new InputStreamReader((InputStream)new ByteArrayInputStream(out.toByteArray()), charset));
            this.computeEdgesAndAnnotations(filename, ast);
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    public IFortranAST parse(String filename) {
        return this.parse(filename, null);
    }

    /*
     * Exception decompiling
     */
    private IFortranAST parse(String filename, Reader stream) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void checkForErrors(ASTExecutableProgramNode ast, String filename) {
        ASTNodeWithErrorRecoverySymbols firstError = PhotranVPG.findFirstErrorIn(ast);
        if (firstError != null) {
            PhotranTokenRef errorTokenRef = this.getErrorTokenRef(filename, firstError.getErrorToken());
            this.log.clearEntriesFor(filename);
            this.log.logError(Messages.bind((String)Messages.PhotranVPGBuilder_FileContainsSyntaxErrors, (Object)filename), (IVPGNode)errorTokenRef);
        }
    }

    private PhotranTokenRef getErrorTokenRef(String filename, Token errorToken) {
        if (this.isPreprocessed(errorToken)) {
            return null;
        }
        return new PhotranTokenRef(filename, errorToken.getStreamOffset(), errorToken.getLength());
    }

    private boolean isPreprocessed(Token token) {
        return token.getPreprocessorDirective() != null && !(token.getPreprocessorDirective() instanceof FixedFormReplacement);
    }

    private void logError(IFile file, String message, Throwable e) {
        StringBuilder sb = new StringBuilder();
        sb.append(message);
        sb.append(": ");
        sb.append(e.getMessage());
        sb.append('\n');
        sb.append(e.getClass().getName());
        sb.append(":\n");
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        e.printStackTrace(new PrintStream(bs));
        sb.append(bs);
        if (file != null) {
            this.log.logError(sb.toString(), (IVPGNode)new PhotranTokenRef(file, 0, 0));
        } else {
            this.log.logError(sb.toString());
        }
    }

    public void populateVPG(String filename, IFortranAST ast) {
        if (!PhotranVPG.getInstance().isVirtualFile(filename)) {
            this.db.deleteAllIncomingDependenciesFor(filename);
            this.db.deleteAllOutgoingDependenciesFor(filename);
        }
        if (ast == null || PhotranVPGWriter.isEmpty(ast.getRoot())) {
            return;
        }
        long start = System.currentTimeMillis();
        Binder.bind(ast, PhotranVPGWriter.getIFileForFilename((String)filename));
        PhotranVPG.getInstance().debug("  - Elapsed time in Binder#bind: " + (System.currentTimeMillis() - start) + " ms", filename);
    }

    public ILazyVPGPopulator[] getLazyEdgePopulators() {
        return new ILazyVPGPopulator[]{new ControlFlowPopulator()};
    }

    public static boolean isEmpty(ASTExecutableProgramNode ast) {
        return ast.findFirstToken() == null;
    }

    public void logError(String message) {
        this.log.logError(message);
    }

    public void logError(String message, PhotranTokenRef tokenRef) {
        this.log.logError(message, (IVPGNode)tokenRef);
    }

    public String describeEdgeType(int edgeType) {
        return EdgeType.values()[edgeType].toString();
    }

    public String describeAnnotationType(int annotationType) {
        return AnnotationType.values()[annotationType].toString();
    }

    protected String describeToken(String filename, int offset, int length) {
        try {
            if (offset == -1 && length == 0) {
                return Messages.PhotranVPG_GlobalScope;
            }
            Token token = ((IFortranAST)PhotranVPG.getInstance().acquireTransientAST(filename)).findTokenByStreamOffsetLength(offset, length);
            if (token == null) {
                return this.db.describeToken(filename, offset, length);
            }
            return String.valueOf(token.getText()) + " " + Messages.bind((String)Messages.PhotranVPG_OffsetN, (Object)offset);
        }
        catch (Exception exception) {
            return this.db.describeToken(filename, offset, length);
        }
    }

    public static String canonicalizeIdentifier(String identifier) {
        return PhotranVPG.canonicalizeIdentifier(identifier);
    }

    public List<IMarker> recomputeErrorLogMarkers() {
        this.deleteExistingErrorMarkers();
        this.populateErrorLogMarkers();
        return this.errorLogMarkers;
    }

    private void deleteExistingErrorMarkers() {
        if (this.errorLogMarkers != null) {
            for (IMarker marker : this.errorLogMarkers) {
                try {
                    marker.delete();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            this.errorLogMarkers = null;
        }
    }

    private void populateErrorLogMarkers() {
        List errorLog = this.log.getEntries();
        this.errorLogMarkers = new ArrayList<IMarker>(errorLog.size());
        int i = 0;
        while (i < errorLog.size()) {
            try {
                VPGLog.Entry entry = (VPGLog.Entry)errorLog.get(i);
                this.errorLogMarkers.add(this.createMarkerFrom(entry));
            }
            catch (CoreException coreException) {}
            ++i;
        }
    }

    private IMarker createMarkerFrom(VPGLog.Entry entry) throws CoreException {
        IMarker marker = this.createMarkerOnResource(entry);
        if (marker != null) {
            this.setMarkerAttributes(marker, entry);
        }
        return marker;
    }

    private IMarker createMarkerOnResource(VPGLog.Entry entry) throws CoreException {
        PhotranTokenRef tr = (PhotranTokenRef)entry.getTokenRef();
        IFile file = tr == null ? null : tr.getFile();
        IFile res = file == null ? ResourcesPlugin.getWorkspace().getRoot() : file;
        return res.createMarker(this.determineMarkerType(entry));
    }

    private String determineMarkerType(VPGLog.Entry entry) {
        if (entry.isWarning()) {
            return "org.eclipse.photran.core.vpg.warningMarker";
        }
        return "org.eclipse.photran.core.vpg.errorMarker";
    }

    private void setMarkerAttributes(IMarker marker, VPGLog.Entry entry) throws CoreException {
        HashMap<String, Object> attribs = new HashMap<String, Object>(5);
        PhotranTokenRef tr = (PhotranTokenRef)entry.getTokenRef();
        if (tr != null) {
            attribs.put("charStart", tr.getOffset());
            attribs.put("charEnd", tr.getEndOffset());
        }
        attribs.put("message", entry.getMessage());
        attribs.put("userEditable", false);
        attribs.put("severity", 2);
        marker.setAttributes(attribs);
    }

    public void enableDefinitionCaching() {
        this.isDefinitionCachingEnabled = true;
    }

    public void disableDefinitionCaching() {
        this.isDefinitionCachingEnabled = false;
    }

    public boolean isDefinitionCachingEnabled() {
        return this.isDefinitionCachingEnabled;
    }

    public void markAccess(Token ident, VariableAccess access) {
        this.db.setAnnotation((IVPGNode)ident.getTokenRef(), (Enum)AnnotationType.VARIABLE_ACCESS_ANNOTATION_TYPE, (Serializable)access);
    }

    public void createFlow(PhotranTokenRef from, PhotranTokenRef to) {
        this.db.ensure(new VPGEdge((IVPGNode)from, (IVPGNode)to, (Enum)EdgeType.CONTROL_FLOW_EDGE_TYPE));
    }

    private static class ControlFlowPopulator
    implements ILazyVPGPopulator {
        private ControlFlowPopulator() {
        }

        public void populateVPG(String filename) {
            IFortranAST ast = (IFortranAST)PhotranVPG.getInstance().acquireTransientAST(filename);
            if (ast == null || PhotranVPGWriter.isEmpty(ast.getRoot())) {
                return;
            }
            LoopReplacer.replaceAllLoopsIn(ast.getRoot());
            long start = System.currentTimeMillis();
            ControlFlowAnalysis.analyze(filename, ast.getRoot());
            PhotranVPG.getInstance().debug("  - Elapsed time in ControlFlowAnalysis#analyze: " + (System.currentTimeMillis() - start) + " ms", filename);
        }

        public boolean dependentFilesMustBePopulated() {
            return false;
        }

        public int[] edgeTypesPopulated() {
            return new int[]{EdgeType.CONTROL_FLOW_EDGE_TYPE.ordinal()};
        }

        public int[] annotationTypesPopulated() {
            return new int[0];
        }
    }
}

