/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.editor;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public abstract class CompletionComputer {
    protected final IDocument document;
    protected final int prefixIndex;
    protected final String prefix;
    protected final int suffixIndex;
    protected final String suffix;
    protected final int replOffset;
    protected final int replLen;

    protected CompletionComputer(IDocument document, int offset) throws BadLocationException {
        this.document = document;
        this.prefixIndex = this.findPrefix(document, offset);
        this.prefix = document.get(this.prefixIndex, offset - this.prefixIndex).toLowerCase();
        this.suffixIndex = this.findSuffix(document, offset);
        this.suffix = document.get(offset, this.suffixIndex - offset).toLowerCase();
        this.replOffset = this.prefixIndex;
        this.replLen = this.suffixIndex - this.prefixIndex;
    }

    private int findPrefix(IDocument s, int offset) throws BadLocationException {
        --offset;
        while (offset >= 0) {
            char c = s.getChar(offset);
            if (!Character.isLetter(c) && !Character.isDigit(c) && c != '_') {
                return offset + 1;
            }
            --offset;
        }
        return 0;
    }

    private int findSuffix(IDocument s, int offset) throws BadLocationException {
        int length = s.getLength();
        while (offset < length) {
            char c = s.getChar(offset);
            if (!Character.isLetter(c) && !Character.isDigit(c) && c != '_') {
                return offset;
            }
            ++offset;
        }
        return length;
    }
}

