/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.editor;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.cdt.internal.ui.editor.CDocumentProvider;
import org.eclipse.cdt.internal.ui.text.TabsToSpacesConverter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.ITextViewerExtension7;
import org.eclipse.jface.text.MarginPainter;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.photran.internal.cdtinterface.ui.editor.CDTBasedSourceViewerConfiguration;
import org.eclipse.photran.internal.cdtinterface.ui.editor.CDTBasedTextEditor;
import org.eclipse.photran.internal.core.FortranCorePlugin;
import org.eclipse.photran.internal.core.preferences.FortranPreferences;
import org.eclipse.photran.internal.core.sourceform.SourceForm;
import org.eclipse.photran.internal.ui.FortranUIPlugin;
import org.eclipse.photran.internal.ui.editor.FortranKeywordRuleBasedScanner;
import org.eclipse.photran.internal.ui.editor.FortranSourceViewer;
import org.eclipse.photran.internal.ui.editor.FortranTemplateCompletionProcessor;
import org.eclipse.photran.internal.ui.editor.IFortranSourceViewerConfigurationFactory;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.WorkbenchChainedTextFontFieldEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FortranEditor
extends CDTBasedTextEditor
implements ISelectionChangedListener,
Preferences.IPropertyChangeListener {
    public static final String EDITOR_ID = "org.eclipse.photran.ui.FortranEditor";
    protected static String CONTEXT_MENU_ID = "#FortranEditorContextMenu";
    public static final String SOURCE_VIEWER_CONFIG_EXTENSION_POINT_ID = "org.eclipse.photran.ui.sourceViewerConfig";
    public static String[] PARTITION_TYPES = new String[]{"__dftl_partition_content_type"};
    protected static String FORTRAN_EDITOR_CONTEXT_ID = "org.eclipse.photran.ui.FortranEditorContext";
    protected static String BLOCK_COMMENT_COMMAND_ID = "org.eclipse.photran.ui.CommentCommand";
    protected static final RGB VERTICAL_LINE_COLOR = new RGB(176, 180, 185);
    public Object reconcilerTasks = null;
    protected IPreferenceStore fCombinedPreferenceStore;
    protected Composite fMainComposite;
    protected Color verticalLineColor;
    protected TabsToSpacesConverter tabToSpacesConverter;
    protected ProjectionAnnotationModel annotationModel;

    public FortranEditor() {
        this.setSourceViewerConfiguration(this.createSourceViewerConfiguration());
        this.setRangeIndicator((Annotation)new DefaultRangeIndicator());
        this.useCDTDocumentProvider();
        IPreferenceStore store = FortranUIPlugin.getDefault().getPreferenceStore();
        IPreferenceStore generalTextStore = EditorsUI.getPreferenceStore();
        this.fCombinedPreferenceStore = new ChainedPreferenceStore(new IPreferenceStore[]{store, generalTextStore, this.getPreferenceStore()});
        this.setPreferenceStore(this.fCombinedPreferenceStore);
        WorkbenchChainedTextFontFieldEditor.startPropagate((IPreferenceStore)store, (String)"org.eclipse.jface.textfont");
        this.useCDTRulerContextMenuID();
        this.setEditorContextMenuId(CONTEXT_MENU_ID);
        FortranCorePlugin.getDefault().getPluginPreferences().addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        IDocument document = this.getDocumentProvider().getDocument((Object)input);
        if (document == null) {
            return;
        }
        this.configurePartitionScanner(document);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        if (FortranPreferences.ENABLE_FOLDING.getValue()) {
            this.installProjectionSupport();
        }
        this.createLightGrayLines();
    }

    protected boolean isTabsToSpacesConversionEnabled() {
        return FortranPreferences.CONVERT_TABS_TO_SPACES.getValue();
    }

    protected void installTabsToSpacesConverter() {
        ISourceViewer sourceViewer = this.getSourceViewer();
        SourceViewerConfiguration config = this.getSourceViewerConfiguration();
        if (config != null && sourceViewer instanceof ITextViewerExtension7) {
            int tabWidth = config.getTabWidth(sourceViewer);
            this.tabToSpacesConverter = new TabsToSpacesConverter();
            this.tabToSpacesConverter.setNumberOfSpacesPerTab(tabWidth);
            IDocumentProvider provider = this.getDocumentProvider();
            if (provider instanceof CDocumentProvider) {
                CDocumentProvider cProvider = (CDocumentProvider)provider;
                this.tabToSpacesConverter.setLineTracker(cProvider.createLineTracker((Object)this.getEditorInput()));
            } else {
                this.tabToSpacesConverter.setLineTracker((ILineTracker)new DefaultLineTracker());
            }
            this.tabToSpacesConverter.setNumberOfSpacesPerTab(FortranPreferences.TAB_WIDTH.getValue());
            ((ITextViewerExtension7)sourceViewer).setTabsToSpacesConverter((IAutoEditStrategy)this.tabToSpacesConverter);
        } else {
            this.tabToSpacesConverter = null;
        }
    }

    protected void uninstallTabsToSpacesConverter() {
        super.uninstallTabsToSpacesConverter();
        this.tabToSpacesConverter = null;
    }

    public void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        try {
            IContributionItem refactorMenu = (IContributionItem)Class.forName("org.eclipse.rephraserengine.ui.menus.RefactorMenu").newInstance();
            MenuManager refactorSubmenu = new MenuManager("Refactor");
            refactorSubmenu.add(refactorMenu);
            menu.appendToGroup("group.edit", (IContributionItem)refactorSubmenu);
        }
        catch (Throwable throwable) {}
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        FortranSourceViewer sourceViewer = new FortranSourceViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)sourceViewer);
        return sourceViewer;
    }

    private void installProjectionSupport() {
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        ProjectionSupport projectionSupport = new ProjectionSupport(viewer, this.getAnnotationAccess(), this.getSharedColors());
        projectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.error");
        projectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.warning");
        projectionSupport.install();
        viewer.doOperation(19);
        this.annotationModel = viewer.getProjectionAnnotationModel();
    }

    public void updateFoldingStructure(ArrayList<Position> positions) {
        try {
            if (this.annotationModel != null) {
                this.annotationModel.modifyAnnotations(null, this.mapAnnotationsToPositions(positions), null);
            }
        }
        catch (Throwable throwable) {}
    }

    private HashMap<ProjectionAnnotation, Position> mapAnnotationsToPositions(ArrayList<Position> positions) {
        HashMap<ProjectionAnnotation, Position> newAnnotations = new HashMap<ProjectionAnnotation, Position>();
        int i = 0;
        while (i < positions.size()) {
            ProjectionAnnotation annotation = new ProjectionAnnotation();
            newAnnotations.put(annotation, positions.get(i));
            annotation.setRangeIndication(true);
            ++i;
        }
        return newAnnotations;
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.eclipse.ui.textEditorScope", FORTRAN_EDITOR_CONTEXT_ID});
    }

    protected void createLightGrayLines() {
        this.verticalLineColor = new Color(null, VERTICAL_LINE_COLOR);
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer instanceof ITextViewerExtension2) {
            ITextViewerExtension2 painter = (ITextViewerExtension2)sourceViewer;
            int[] columns = this.getColumnsToDrawVerticalLinesOn();
            int i = 0;
            while (i < columns.length) {
                MarginPainter p = new MarginPainter((ITextViewer)this.getSourceViewer());
                p.setMarginRulerColumn(columns[i]);
                p.setMarginRulerColor(this.verticalLineColor);
                painter.addPainter((IPainter)p);
                ++i;
            }
        }
    }

    protected int[] getColumnsToDrawVerticalLinesOn() {
        if (this.isFixedForm()) {
            int endColumnWidth = FortranPreferences.FIXED_FORM_COMMENT_COLUMN.getValue();
            return new int[]{5, 6, endColumnWidth};
        }
        return new int[0];
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent event) {
        return FortranPreferences.respondToPreferenceChange((String)event.getProperty()) || super.affectsTextPresentation(event);
    }

    protected SourceViewerConfiguration createSourceViewerConfiguration() {
        IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor(SOURCE_VIEWER_CONFIG_EXTENSION_POINT_ID);
        if (configs.length > 0) {
            try {
                IFortranSourceViewerConfigurationFactory factory = (IFortranSourceViewerConfigurationFactory)configs[configs.length - 1].createExecutableExtension("factory");
                return factory.create(this);
            }
            catch (CoreException coreException) {}
        }
        return new FortranSourceViewerConfiguration(this);
    }

    protected void configurePartitionScanner(IDocument document) {
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new RuleBasedPartitionScanner(), PARTITION_TYPES);
        partitioner.connect(document);
        document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
    }

    protected ITokenScanner getTokenScanner() {
        return new FortranKeywordRuleBasedScanner(this.isFixedForm(), this.getSourceViewer());
    }

    public boolean isFixedForm() {
        IFile file = this.getIFile();
        if (file != null) {
            return SourceForm.isFixedForm((IFile)this.getIFile());
        }
        IEditorInput input = this.getEditorInput();
        if (input != null) {
            return SourceForm.isFixedForm((String)input.getName());
        }
        return false;
    }

    public IFile getIFile() {
        IEditorInput input = this.getEditorInput();
        return input != null && input instanceof IFileEditorInput ? ((IFileEditorInput)input).getFile() : null;
    }

    public IDocument getIDocument() {
        IEditorInput input = this.getEditorInput();
        if (input == null) {
            return null;
        }
        IDocumentProvider dp = this.getDocumentProvider();
        if (dp == null) {
            return null;
        }
        return dp.getDocument((Object)input);
    }

    public ITextSelection getSelection() {
        ISelectionProvider provider = this.getSelectionProvider();
        if (provider == null) {
            return null;
        }
        ISelection sel = provider.getSelection();
        if (!(sel instanceof ITextSelection)) {
            return null;
        }
        return (ITextSelection)sel;
    }

    public Shell getShell() {
        return this.getSite().getShell();
    }

    public ISourceViewer getSourceViewerx() {
        return super.getSourceViewer();
    }

    public IReconciler getReconciler() {
        return this.getSourceViewerConfiguration().getReconciler(this.getSourceViewer());
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
        boolean convertTabs = FortranPreferences.CONVERT_TABS_TO_SPACES.getValue();
        if (convertTabs && this.tabToSpacesConverter == null) {
            this.installTabsToSpacesConverter();
        } else if (!convertTabs && this.tabToSpacesConverter != null) {
            this.uninstallTabsToSpacesConverter();
        }
        if (this.tabToSpacesConverter != null) {
            this.tabToSpacesConverter.setNumberOfSpacesPerTab(FortranPreferences.TAB_WIDTH.getValue());
        }
    }

    public void dispose() {
        FortranCorePlugin.getDefault().getPluginPreferences().removePropertyChangeListener((Preferences.IPropertyChangeListener)this);
        super.dispose();
    }

    public static class FortranSourceViewerConfiguration
    extends CDTBasedSourceViewerConfiguration {
        protected static final Color WHITE = new Color(null, new RGB(255, 255, 255));
        protected PresentationReconciler reconciler;

        public FortranSourceViewerConfiguration(FortranEditor editor) {
            super((ITextEditor)editor);
        }

        public int getTabWidth(ISourceViewer sourceViewer) {
            return FortranPreferences.TAB_WIDTH.getValue();
        }

        public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
            return PARTITION_TYPES;
        }

        public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
            if (this.reconciler == null) {
                this.reconciler = new PresentationReconciler();
                DefaultDamagerRepairer dr = new DefaultDamagerRepairer(this.getTokenScanner());
                this.reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
                this.reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
            }
            return this.reconciler;
        }

        protected ITokenScanner getTokenScanner() {
            return ((FortranEditor)this.editor).getTokenScanner();
        }

        public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
            ContentAssistant assistant = new ContentAssistant();
            FortranTemplateCompletionProcessor templateProcessor = new FortranTemplateCompletionProcessor();
            String[] stringArray = PARTITION_TYPES;
            int n = PARTITION_TYPES.length;
            int n2 = 0;
            while (n2 < n) {
                String partitionType = stringArray[n2];
                assistant.setContentAssistProcessor((IContentAssistProcessor)templateProcessor, partitionType);
                ++n2;
            }
            assistant.enableAutoActivation(false);
            assistant.setProposalPopupOrientation(21);
            assistant.setContextInformationPopupBackground(WHITE);
            assistant.setProposalSelectorBackground(WHITE);
            return assistant;
        }
    }
}

