/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.editor;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.photran.internal.core.FortranCorePlugin;
import org.eclipse.photran.internal.core.preferences.FortranPreferences;
import org.eclipse.swt.custom.CaretEvent;
import org.eclipse.swt.custom.CaretListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public final class HorizontalRuler
extends Composite
implements PaintListener,
CaretListener,
SelectionListener,
ControlListener,
Preferences.IPropertyChangeListener {
    private IVerticalRuler verticalRuler = null;
    private StyledText styledText = null;

    public HorizontalRuler(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout(1, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.addPaintListener(this);
        FortranCorePlugin.getDefault().getPluginPreferences().addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
    }

    public void configure(IVerticalRuler verticalRuler, StyledText styledText) {
        this.verticalRuler = verticalRuler;
        this.styledText = styledText;
        styledText.addCaretListener((CaretListener)this);
        styledText.getHorizontalBar().addSelectionListener((SelectionListener)this);
        verticalRuler.getControl().addControlListener((ControlListener)this);
    }

    public void paintControl(PaintEvent e) {
        if (this.verticalRuler != null && this.styledText != null && !this.styledText.isDisposed()) {
            new RulerPainter().paint(e.gc);
        }
    }

    public void caretMoved(CaretEvent event) {
        this.redraw();
    }

    public void widgetSelected(SelectionEvent e) {
        this.redraw();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.redraw();
    }

    public void controlMoved(ControlEvent e) {
        this.redraw();
    }

    public void controlResized(ControlEvent e) {
        this.redraw();
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
        this.redraw();
    }

    public void dispose() {
        FortranCorePlugin.getDefault().getPluginPreferences().removePropertyChangeListener((Preferences.IPropertyChangeListener)this);
        super.dispose();
    }

    private final class RulerPainter {
        private int height;
        private int controlWidth;
        private int left;
        private int verticalRulerWidth;
        private int scrollBarWidth;
        private int characterWidth;
        private int numCharsScrolled;
        private int rulerWidth;

        private RulerPainter() {
            this.height = HorizontalRuler.this.getSize().y;
            this.controlWidth = HorizontalRuler.this.getSize().x;
            this.left = HorizontalRuler.this.verticalRuler.getWidth() - HorizontalRuler.this.styledText.getHorizontalPixel();
            this.verticalRulerWidth = HorizontalRuler.this.verticalRuler.getWidth();
            this.scrollBarWidth = ((HorizontalRuler)HorizontalRuler.this).styledText.getVerticalBar().getSize().x;
        }

        public void paint(GC gc) {
            gc.setFont(HorizontalRuler.this.styledText.getFont());
            this.characterWidth = gc.getFontMetrics().getAverageCharWidth();
            this.numCharsScrolled = HorizontalRuler.this.styledText.getHorizontalIndex();
            this.rulerWidth = this.controlWidth - this.scrollBarWidth - this.left + this.numCharsScrolled * this.characterWidth;
            this.drawBackground(gc);
            if (this.isFixedWidthFont(gc)) {
                this.drawTicks(gc);
                this.drawTabs(gc);
                this.drawNumbers(gc);
            }
            this.drawCursorPosition(gc);
        }

        private void drawBackground(GC gc) {
            gc.setBackground(gc.getDevice().getSystemColor(15));
            gc.setForeground(gc.getDevice().getSystemColor(1));
            gc.fillGradientRectangle(0, 0, this.controlWidth, this.height * 2, true);
        }

        private boolean isFixedWidthFont(GC gc) {
            return gc.getCharWidth('i') == gc.getCharWidth('w');
        }

        private void drawTicks(GC gc) {
            gc.setForeground(gc.getDevice().getSystemColor(16));
            int i = 0;
            while (i <= this.rulerWidth / this.characterWidth) {
                int x = this.left + i * this.characterWidth - this.characterWidth / 2 + 1;
                int tickHeight = i % 10 == 0 ? 0 : (i % 5 == 0 ? 3 : 1);
                if (x >= this.verticalRulerWidth && tickHeight > 0) {
                    int center = this.height / 2;
                    int y1 = center - tickHeight + 1;
                    int y2 = center + tickHeight - 1;
                    gc.drawLine(x, y1, x, y2);
                }
                ++i;
            }
        }

        private void drawTabs(GC gc) {
            gc.setBackground(gc.getDevice().getSystemColor(15));
            int tabSize = FortranPreferences.TAB_WIDTH.getValue();
            int i = tabSize + 1;
            while (i <= this.rulerWidth / this.characterWidth) {
                int x = this.left + i * this.characterWidth - this.characterWidth / 2 + 1;
                int y = this.height - 1;
                if (x >= this.verticalRulerWidth) {
                    gc.fillPolygon(new int[]{x, y - 3, x - 3, y, x + 3, y});
                }
                i += tabSize;
            }
        }

        private void drawNumbers(GC gc) {
            gc.setForeground(gc.getDevice().getSystemColor(16));
            Font origFont = gc.getFont();
            gc.setFont(gc.getDevice().getSystemFont());
            int i = 10;
            while (i <= this.rulerWidth / this.characterWidth) {
                String string = Integer.toString(i / 10);
                string = string.substring(string.length() - 1);
                Point extent = gc.textExtent(string);
                int x = this.left + i * this.characterWidth - extent.x / 2 - 1;
                int y = (this.height - extent.y) / 2;
                if (x >= this.verticalRulerWidth) {
                    gc.drawText(string, x, y, true);
                }
                i += 10;
            }
            gc.setFont(origFont);
        }

        private void drawCursorPosition(GC gc) {
            gc.setForeground(gc.getDevice().getSystemColor(15));
            Point caretLocation = HorizontalRuler.this.styledText.getCaret().getLocation();
            int rectWidth = this.isFixedWidthFont(gc) ? gc.getFontMetrics().getAverageCharWidth() : ((HorizontalRuler)HorizontalRuler.this).styledText.getCaret().getSize().x;
            gc.drawRectangle(this.verticalRulerWidth + caretLocation.x, 0, rectWidth, this.height - 1);
        }
    }
}

